/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis;

import com.baomidou.mybatisplus.annotation.TableName;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.IndexInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.platform.core.utils.collection.Pair;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogColumnEntity;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.enums.ShardingRuleEnum;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis.MybatisTableBuildService;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.util.ColumnInfoDtoUtil;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;

public class AuditLogColumnTableBuildServiceImpl
extends MybatisTableBuildService {
    public AuditLogColumnTableBuildServiceImpl() {
        super("SYS_SUPPORT_AUDIT_LOG_COLUMN", ShardingRuleEnum.MONTH);
        this.setOldTableName(AuditLogColumnEntity.class.getAnnotation(TableName.class).value());
    }

    @Override
    public String getNewTableName(Pair<String, String> schema2TableName) {
        return "SYS_SP_AUDIT_LOG_COLUMN_" + this.changeSuffix(this.getSuffix());
    }

    @Override
    public MetadataParam getTableMetaDataInfo(String newTableName) {
        MetadataParam metadataParam = new MetadataParam();
        metadataParam.setTableInfo(this.getTableInfo());
        metadataParam.setColumnInfo(this.getColumnInfoList());
        metadataParam.setIndexInfo(this.getIndexInfoList(newTableName));
        return metadataParam;
    }

    private TableInfoDto getTableInfo() {
        TableInfoDto tableInfoDto = new TableInfoDto();
        tableInfoDto.setTableDec("\u7cfb\u7edf\u5ba1\u8ba1\u65e5\u5fd7\u5217\u8bb0\u5f55");
        tableInfoDto.setPollName("master");
        return tableInfoDto;
    }

    private List<ColumnInfoDto> getColumnInfoList() {
        ColumnInfoDtoUtil columnInfoDtoUtil = new ColumnInfoDtoUtil(Lists.newArrayListWithCapacity((int)22));
        columnInfoDtoUtil.add(JDBCType.CLOB, "AFTER_VALUE", "\u4fee\u6539\u4e4b\u540e\u7684\u503c");
        columnInfoDtoUtil.add(JDBCType.CLOB, "BEFORE_VALUE", "\u4fee\u6539\u4e4b\u524d\u7684\u503c");
        columnInfoDtoUtil.add(JDBCType.CLOB, "ANNOTATION_INFO", "\u5b57\u6bb5\u6ce8\u89e3\u4fe1\u606f");
        columnInfoDtoUtil.add(JDBCType.BIGINT, "AUDIT_LOG_COLUMN_ID", "\u4e3b\u952e", 20L);
        columnInfoDtoUtil.add(JDBCType.BIGINT, "CREATOR", "\u521b\u5efa\u4eba", 20L);
        columnInfoDtoUtil.add(JDBCType.BIGINT, "LAST_EDITOR", "\u66f4\u65b0\u4eba", 20L);
        columnInfoDtoUtil.add(JDBCType.BIGINT, "TABLE_ID", "\u5ba1\u8ba1\u65e5\u5fd7\u5173\u8054\u8868\u5b57\u6bb5", 20L);
        columnInfoDtoUtil.add(JDBCType.BIGINT, "TENANT_ID", "\u6240\u5c5e\u79df\u6237", 20L);
        columnInfoDtoUtil.add(JDBCType.TIMESTAMP, "CREATE_TIME", "\u521b\u5efa\u65f6\u95f4");
        columnInfoDtoUtil.add(JDBCType.TIMESTAMP, "LAST_TIME", "\u66f4\u65b0\u65f6\u95f4");
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "AFTER_VERSION", "\u4fee\u6539\u4e4b\u540e\u7684\u7248\u672c", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "BEFORE_VERSION", "\u4fee\u6539\u4e4b\u524d\u7684\u7248\u672c", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "COLUMN_DESC", "\u5217\u63cf\u8ff0", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "COLUMN_NAME", "\u5217\u540d", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "COMMIT_ID", "\u5f53\u6b21\u4f1a\u8bdd\u63d0\u4ea4\u552f\u4e00\u6807\u8bc6", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "CREATOR_NAME", "\u521b\u5efa\u4eba\u59d3\u540d", 255L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "LAST_EDITOR_NAME", "\u6700\u540e\u4e00\u6b21\u4fee\u6539\u4eba\u59d3\u540d", 255L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "OPERATE_MODE", "\u4fee\u6539\u6a21\u5f0f INSERT\uff1a\u6dfb\u52a0/UPDATE\uff1a\u4fee\u6539\uff1aDELETE\uff1a\u5220\u9664", 16L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "REMARK", "\u5907\u6ce8", 256L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "SERVER_VERSION", "\u670d\u52a1\u7248\u672c", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "TABLE_NAME", "\u8868\u540d\u79f0", 128L);
        columnInfoDtoUtil.add(JDBCType.CHAR, "DEL_FLAG", "\u5220\u9664\u6807\u8bc6", 1L);
        HashMap consumerMap = Maps.newHashMapWithExpectedSize((int)2);
        consumerMap.put("TENANT_ID", action -> action.setDefaultValue("0"));
        consumerMap.put("DEL_FLAG", action -> action.setDefaultValue("0"));
        consumerMap.put("AUDIT_LOG_COLUMN_ID", action -> {
            action.setPk("1");
            action.setRequired("1");
        });
        List<ColumnInfoDto> result = columnInfoDtoUtil.getColumnInfoDtoList();
        result.forEach(action -> {
            if (consumerMap.containsKey(action.getColumnName())) {
                ((Consumer)consumerMap.get(action.getColumnName())).accept(action);
            }
        });
        return result;
    }

    private List<IndexInfoDto> getIndexInfoList(String newTableName) {
        ArrayList<IndexInfoDto> indexInfoList = new ArrayList<IndexInfoDto>();
        IndexInfoDto indexInfoDto = new IndexInfoDto();
        indexInfoDto.setIndexColumns(Collections.singletonList("COMMIT_ID"));
        indexInfoDto.setUnique(false);
        indexInfoDto.setIndexName(this.getIndexName("ID_ALOG_COLUMN_CM", newTableName));
        indexInfoDto.setIndexComment("\u63d0\u4ea4\u6807\u8bc6\u7d22\u5f15");
        indexInfoList.add(indexInfoDto);
        return indexInfoList;
    }
}

