/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis.factory.impl;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis.factory.BaseBuildTableService;
import java.sql.JDBCType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class BuildOracleTableServiceImpl
extends BaseBuildTableService {
    private Map<String, Consumer<ColumnInfoDto>> JDBC_TYPE_2_METHOD;

    private void init() {
        if (ObjectUtils.isEmpty(this.JDBC_TYPE_2_METHOD)) {
            HashMap<String, Consumer<ColumnInfoDto>> jdbcType2Method = new HashMap<String, Consumer<ColumnInfoDto>>();
            jdbcType2Method.put(JDBCType.CHAR.name(), columnInfoDto -> columnInfoDto.setDataType("char"));
            jdbcType2Method.put(JDBCType.VARCHAR.name(), this::buildVarCharColumn);
            jdbcType2Method.put(JDBCType.TIMESTAMP.name(), this::buildDateColumn);
            jdbcType2Method.put(JDBCType.CLOB.name(), columnInfoDto -> columnInfoDto.setDataType("clob"));
            jdbcType2Method.put(JDBCType.INTEGER.name(), this::buildIntColumn);
            jdbcType2Method.put(JDBCType.BIGINT.name(), this::buildBigIntColumn);
            this.JDBC_TYPE_2_METHOD = jdbcType2Method;
        }
    }

    @Override
    public List<ColumnInfoDto> changeDataTypeByJDBCType(List<ColumnInfoDto> param) {
        this.init();
        return param.stream().peek(action -> {
            String jdbcType = action.getJdbcType();
            Consumer<ColumnInfoDto> columnInfoDtoConsumer = this.JDBC_TYPE_2_METHOD.get(jdbcType);
            if (ObjectUtils.isNull((Object[])new Object[]{columnInfoDtoConsumer})) {
                throw new IllegalStateException(String.format("\u6682\u4e0d\u652f\u6301\u7c7b\u578b%s", jdbcType));
            }
            columnInfoDtoConsumer.accept((ColumnInfoDto)action);
        }).collect(Collectors.toList());
    }

    private void buildVarCharColumn(ColumnInfoDto columnInfoDto) {
        columnInfoDto.setDataLength(Long.valueOf(Math.min(columnInfoDto.getDataLength() * 3L, 3999L)));
        columnInfoDto.setDataType("varchar2");
    }

    private void buildDateColumn(ColumnInfoDto columnInfoDto) {
        columnInfoDto.setDataType("TIMESTAMP");
        columnInfoDto.setDataLength(Optional.ofNullable(columnInfoDto.getDataLength()).orElse(6L));
    }

    private void buildIntColumn(ColumnInfoDto columnInfoDto) {
        columnInfoDto.setDataType("NUMBER");
        columnInfoDto.setDataDot(Optional.ofNullable(columnInfoDto.getDataDot()).orElse(0));
    }

    private void buildBigIntColumn(ColumnInfoDto columnInfoDto) {
        columnInfoDto.setDataType("NUMBER");
        columnInfoDto.setDataDot(Optional.ofNullable(columnInfoDto.getDataDot()).orElse(0));
    }
}

