/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dynamictable.handler;

import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.collection.Pair;
import com.jxdinfo.hussar.support.audit.core.support.dynamictable.DynamicTableHandler;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.factory.DynamicTableProcessorFactory;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.processor.DynamicTableProcessor;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

public class DynamicTableHandlerImpl
implements DynamicTableHandler {
    private static final Logger log = LoggerFactory.getLogger(DynamicTableHandlerImpl.class);
    public static final Set<String> TABLE_NAME_SET = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

    public String dynamicTableName(String schemaTableName) {
        Pair<String, String> schema2TableName = this.splitTableName(schemaTableName);
        String schema = (String)schema2TableName.getKey();
        String tableName = (String)schema2TableName.getValue();
        DynamicTableProcessor processor = DynamicTableProcessorFactory.getByTableName(tableName);
        if (ObjectUtils.isEmpty((Object)processor)) {
            return schemaTableName;
        }
        String newTableName = processor.getNewTableName(schema2TableName);
        if (!TABLE_NAME_SET.contains(newTableName)) {
            ((DynamicTableHandlerImpl)SpringContextUtil.getBean(this.getClass())).checkAndCreateNewTable(processor, newTableName, schema2TableName);
        }
        return schema + newTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void checkAndCreateNewTable(DynamicTableProcessor processor, String newTableName, Pair<String, String> schemaTableName) {
        try {
            if (TABLE_NAME_SET.contains(newTableName)) {
                return;
            }
            boolean flag = processor.checkTableNameExist(newTableName, schemaTableName);
            if (flag) {
                TABLE_NAME_SET.add(newTableName);
                return;
            }
            String string = newTableName.intern();
            synchronized (string) {
                if (!TABLE_NAME_SET.contains(newTableName) && (flag = processor.createTable(newTableName, schemaTableName))) {
                    TABLE_NAME_SET.add(newTableName);
                }
            }
        }
        catch (Exception e) {
            log.error("\u68c0\u6d4b\u6216\u521b\u5efa\u8868\u5f02\u5e38", (Throwable)e);
        }
    }

    private Pair<String, String> splitTableName(String schemaTableName) {
        if (schemaTableName.contains(".")) {
            String[] split = schemaTableName.split("\\.");
            String tableName = split[split.length - 1];
            if (schemaTableName.length() > tableName.length()) {
                String schema = schemaTableName.substring(0, schemaTableName.length() - tableName.length());
                return Pair.of((Object)schema, (Object)tableName);
            }
        }
        return Pair.of((Object)"", (Object)schemaTableName);
    }
}

