/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis.factory;

import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis.factory.BaseBuildTableService;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis.factory.impl.BuildDMTableServiceImpl;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis.factory.impl.BuildGaussTableServiceImpl;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis.factory.impl.BuildHighGoTableServiceImpl;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis.factory.impl.BuildKingBaseTableServiceImpl;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis.factory.impl.BuildMysqlTableServiceImpl;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis.factory.impl.BuildOracleTableServiceImpl;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis.factory.impl.BuildOscarTableServiceImpl;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis.factory.impl.BuildPostgreSqlTableServiceImpl;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis.factory.impl.BuildSqlServerTableServiceImpl;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.ObjectUtils;

public class BuildTableFactory {
    private static final Map<DbType, BaseBuildTableService> ACTIONS = new HashMap<DbType, BaseBuildTableService>();

    private BuildTableFactory() {
    }

    public static void addAction(DbType dbType, BaseBuildTableService action) {
        ACTIONS.put(dbType, action);
    }

    public static BaseBuildTableService getAction(DbType dbType) {
        BaseBuildTableService baseBuildTableService = ACTIONS.get(dbType);
        if (ObjectUtils.isEmpty((Object)baseBuildTableService)) {
            throw new IllegalStateException(String.format("\u8fd8\u672a\u652f\u6301%s", dbType));
        }
        return baseBuildTableService;
    }

    static {
        ACTIONS.put(DbType.MYSQL, new BuildMysqlTableServiceImpl());
        ACTIONS.put(DbType.ORACLE, new BuildOracleTableServiceImpl());
        ACTIONS.put(DbType.ORACLE_12C, new BuildOracleTableServiceImpl());
        ACTIONS.put(DbType.SQL_SERVER, new BuildSqlServerTableServiceImpl());
        ACTIONS.put(DbType.SQL_SERVER2005, new BuildSqlServerTableServiceImpl());
        ACTIONS.put(DbType.KINGBASE_ES, new BuildKingBaseTableServiceImpl());
        ACTIONS.put(DbType.POSTGRE_SQL, new BuildPostgreSqlTableServiceImpl());
        ACTIONS.put(DbType.DM, new BuildDMTableServiceImpl());
        ACTIONS.put(DbType.OSCAR, new BuildOscarTableServiceImpl());
        ACTIONS.put(DbType.GAUSS, new BuildGaussTableServiceImpl());
        ACTIONS.put(DbType.HIGH_GO, new BuildHighGoTableServiceImpl());
    }
}

