/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dynamictable.mongodb;

import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.collection.Pair;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.enums.ShardingRuleEnum;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.processor.SimpleDynamicTableProcessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;

public class MongoDbDynamicTableBuildService
extends SimpleDynamicTableProcessor {
    Logger log = LoggerFactory.getLogger(MongoDbDynamicTableBuildService.class);

    public MongoDbDynamicTableBuildService() {
    }

    public MongoDbDynamicTableBuildService(String documentName, ShardingRuleEnum shardingRuleEnum) {
        this.setOldTableName(documentName);
        this.setShardingRuleService(shardingRuleEnum.getShardingRule());
    }

    @Override
    public boolean checkTableNameExist(String newTableName, Pair<String, String> schemaTableName) {
        MongoTemplate mongoTemplate = (MongoTemplate)SpringContextUtil.getBean(MongoTemplate.class);
        return mongoTemplate.collectionExists(newTableName);
    }

    @Override
    public boolean createTable(String newTableName, Pair<String, String> schemaTableName) {
        String oldTableName = (String)schemaTableName.getValue();
        MongoTemplate mongoTemplate = (MongoTemplate)SpringContextUtil.getBean(MongoTemplate.class);
        List indexInfoList = mongoTemplate.indexOps(oldTableName).getIndexInfo();
        indexInfoList.stream().filter(indexInfo -> !"_id".equals(indexInfo.getName())).forEach(indexInfo -> {
            Index indexDefinition = new Index();
            indexInfo.getIndexFields().forEach(indexField -> indexDefinition.on(indexField.getKey(), indexField.getDirection() != null ? indexField.getDirection() : Sort.Direction.ASC));
            indexDefinition.named(indexInfo.getName());
            indexInfo.getExpireAfter().ifPresent(arg_0 -> ((Index)indexDefinition).expire(arg_0));
            if (indexInfo.isUnique()) {
                indexDefinition.unique();
            }
            if (indexInfo.isSparse()) {
                indexDefinition.sparse();
            }
            mongoTemplate.indexOps(newTableName).ensureIndex((IndexDefinition)indexDefinition);
        });
        return true;
    }
}

