/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dao.utils;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.ConvertUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.ObjectUtil;
import com.jxdinfo.hussar.platform.core.utils.lang.MultiLangUtil;
import com.jxdinfo.hussar.support.audit.core.util.QueryAuditUtils;
import com.jxdinfo.hussar.support.audit.plugin.dao.utils.ColumsDto;
import com.jxdinfo.hussar.support.mp.exception.MpRuntimeException;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class QueryWrapperUtils {
    public static QueryWrapper createGroupQueryWrapper(QueryWrapper queryWrapper, Object searchObj, Map<String, String[]> parameterMap) {
        if (HussarUtils.isEmpty(parameterMap)) {
            throw new MpRuntimeException("audit::query.group.data.empty");
        }
        PropertyDescriptor[] propertyDescriptors = BeanUtil.getPropertyDescriptors(searchObj.getClass());
        Optional<String[]> first = parameterMap.entrySet().stream().filter(e -> HussarUtils.equals(e.getKey(), (Object)"field_groupby")).map(e -> (String[])e.getValue()).findFirst();
        if (!first.isPresent()) {
            throw new MpRuntimeException(MultiLangUtil.getTranslateName((String)"audit::query.group.field.missing"));
        }
        String[] groupKeys = first.get();
        List<String> groupList = Arrays.stream(groupKeys).filter(e -> QueryAuditUtils.validateFieldExist((String)e, (PropertyDescriptor[])propertyDescriptors)).collect(Collectors.toList());
        List<ColumsDto> groupColumDtoList = QueryWrapperUtils.getColumnByPro(groupList, searchObj);
        List groupColumList = groupColumDtoList.stream().map(gc -> gc.getColumns()).collect(Collectors.toList());
        if (HussarUtils.isEmpty(groupColumList)) {
            throw new MpRuntimeException(MultiLangUtil.getTranslateName((String)"audit::query.group.field.invalid"));
        }
        queryWrapper.groupBy(groupColumList);
        List selectList = groupColumDtoList.stream().map(gc -> gc.getColumns() + " as " + gc.getProp()).collect(Collectors.toList());
        selectList.add("count(*) as totalCount");
        queryWrapper.select((String[])ConvertUtil.convert(selectList, String[].class));
        return queryWrapper;
    }

    private static List<ColumsDto> getColumnByPro(List<String> groupList, Object searchObj) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(searchObj.getClass());
        if (ObjectUtil.isEmpty((Object)tableInfo)) {
            return null;
        }
        List fieldList = tableInfo.getFieldList();
        List<ColumsDto> columsDtoList = fieldList.stream().filter(fList -> CollectionUtil.contains((Collection)groupList, (Object)fList.getProperty())).map(fList -> {
            ColumsDto columsDto = new ColumsDto();
            columsDto.setColumns(fList.getColumn());
            columsDto.setProp(fList.getProperty());
            return columsDto;
        }).collect(Collectors.toList());
        return columsDtoList;
    }
}

