/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dao.support.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogEntity;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogTableEntity;
import com.jxdinfo.hussar.support.audit.core.auditlog.service.AuditLogService;
import com.jxdinfo.hussar.support.audit.core.auditlog.vo.AuditLogItemVo;
import com.jxdinfo.hussar.support.audit.plugin.dao.service.AuditLogColumnDaoService;
import com.jxdinfo.hussar.support.audit.plugin.dao.service.AuditLogDaoService;
import com.jxdinfo.hussar.support.audit.plugin.dao.service.AuditLogTableDaoService;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AuditDaoServiceImpl
implements AuditLogService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditDaoServiceImpl.class);
    @Autowired
    private AuditLogDaoService daoService;
    @Autowired
    private AuditLogTableDaoService auditLogTableDaoService;
    @Autowired
    private AuditLogColumnDaoService auditLogColumnDaoService;

    public void saveAuditLogDataChanges(List<AuditLogItemVo> auditLogItemVos) {
        if (HussarUtils.isEmpty(auditLogItemVos)) {
            LOGGER.warn("\u5ba1\u8ba1\u65e5\u5fd7\u6570\u636e\u53d8\u5316\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u4fdd\u5b58\u6570\u636e");
            return;
        }
        for (AuditLogItemVo auditLogItemVo : auditLogItemVos) {
            AuditLogTableEntity auditLogTable = auditLogItemVo.getAuditLogTable();
            this.auditLogTableDaoService.save(auditLogTable);
            Set auditLogColumnSet = auditLogItemVo.getAuditLogColumnSet();
            if (HussarUtils.isNotEmpty((Object)auditLogColumnSet)) {
                auditLogColumnSet.stream().forEach(auditLogColumnEntity -> auditLogColumnEntity.setTableId(auditLogTable.getId()));
            }
            this.auditLogColumnDaoService.saveBatchNoTransaction(auditLogColumnSet);
        }
    }

    public boolean save(AuditLogEntity entity) {
        return this.daoService.save(entity);
    }

    public boolean udateByCommit(AuditLogEntity entity) {
        if (HussarUtils.isEmpty((Object)entity) || HussarUtils.isEmpty((Object)entity.getCommitId())) {
            return false;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(AuditLogEntity::getCommitId, (Object)entity.getCommitId());
        return this.daoService.update(entity, (Wrapper)queryWrapper);
    }
}

