/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.archive.enums.ArchiveExecType;
import com.jxdinfo.hussar.support.audit.core.archive.handler.ArchiveHandler;
import com.jxdinfo.hussar.support.audit.core.archive.service.ArchiveService;
import com.jxdinfo.hussar.support.audit.core.archive.vo.ArchiveConfigVo;
import com.jxdinfo.hussar.support.audit.core.archive.vo.ArchiveRecordVo;
import com.jxdinfo.hussar.support.audit.plugin.archive.factory.ArchiveHandlerFactory;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
public class AuditLogArchiveServiceImpl
implements ArchiveService {
    private static final Logger logger = LoggerFactory.getLogger(AuditLogArchiveServiceImpl.class);

    @Async
    public void archiveData(List<ArchiveConfigVo> archiveConfigVoList, ArchiveExecType archiveExecType) {
        if (HussarUtils.isEmpty(archiveConfigVoList)) {
            logger.debug("\u5f52\u6863\u6570\u636e\u5931\u8d25\uff0c\u5f52\u6863\u914d\u7f6e\u4e3a\u7a7a");
            return;
        }
        for (ArchiveConfigVo archiveConfigVo : archiveConfigVoList) {
            String sourceTableName = archiveConfigVo.getSourceTableName();
            ArchiveHandler archiveHandler = ArchiveHandlerFactory.getArchiveHandler(sourceTableName);
            logger.debug("\u5f00\u59cb\u6267\u884c\u5f52\u6863\u5904\u7406\u5668\uff1a{}", (Object)archiveHandler.getClass().getName());
            archiveHandler.archiveData(archiveConfigVo, archiveExecType);
        }
    }

    @Async
    public void archiveData(List<ArchiveRecordVo> archiveRecordVos) {
        if (HussarUtils.isEmpty(archiveRecordVos)) {
            logger.debug("\u5f52\u6863\u6570\u636e\u5931\u8d25\uff0c\u5f52\u6863\u8bb0\u5f55\u4e3a\u7a7a");
            return;
        }
        for (ArchiveRecordVo archiveRecordVo : archiveRecordVos) {
            String sourceTableName = archiveRecordVo.getSourceTableName();
            ArchiveHandler archiveHandler = ArchiveHandlerFactory.getArchiveHandler(sourceTableName);
            logger.debug("\u624b\u52a8\u5f52\u6863\uff0c\u5f00\u59cb\u6267\u884c\u5f52\u6863\u5904\u7406\u5668\uff1a{}", (Object)archiveHandler.getClass().getSimpleName());
            archiveHandler.archiveData(archiveRecordVo);
        }
    }
}

