/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.impl;

import com.jxdinfo.hussar.support.audit.plugin.archive.conditions.MybatisCondition;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.factory.CreateTableHandlerFactory;
import com.jxdinfo.hussar.support.audit.plugin.archive.service.ArchiveCreateTableService;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="archiveCreateTableDaoService")
@Conditional(value={MybatisCondition.class})
public class ArchiveCreateTableDaoServiceImpl
implements ArchiveCreateTableService {
    @Override
    public Boolean checkTableExist(String tableName, String originTableName) {
        return CreateTableHandlerFactory.getCreateTableService(originTableName).checkTableExist(tableName);
    }

    @Override
    public void createTable(String newTableName, String originTableName) {
        CreateTableHandlerFactory.getCreateTableService(originTableName).createTable(newTableName, originTableName);
    }

    @Override
    public String getTableName(String originTableName, String tableNameSuffix) {
        String tableNamePrefix = originTableName.replace("_SUPPORT", "");
        return tableNamePrefix + "_" + tableNameSuffix;
    }
}

