/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.impl;

import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.mybatisplus.annotation.DbType;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.IndexInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.audit.core.util.DataSourceUtil;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.convertor.DataTypeConvertorFactory;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.MybatisCreateTableService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.utils.MpUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractArchiveCreateTableService
implements MybatisCreateTableService,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AbstractArchiveCreateTableService.class);
    @Autowired
    private HussarDdlService hussarDdlService;

    @Override
    public Boolean checkTableExist(String tableName) {
        String dbType = this.getDbType();
        if (this.isNameLowerCase(dbType)) {
            tableName = tableName.toLowerCase();
        }
        logger.debug("\u68c0\u67e5\u8868\u662f\u5426\u5b58\u5728\uff1a{}", (Object)tableName);
        List metaTableInfos = this.hussarDdlService.selectTablesByTableNames((List)Lists.newArrayList((Object[])new String[]{tableName}), "master");
        if (HussarUtils.isNotEmpty((Object)metaTableInfos)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public void createTable(String newTableName, String originTableName) {
        String dbType = this.getDbType();
        if (this.isNameLowerCase(dbType)) {
            newTableName = newTableName.toLowerCase();
        }
        logger.debug("\u521b\u5efa\u8868\uff1a{}", (Object)newTableName);
        MetadataParam metadataParam = new MetadataParam();
        metadataParam.setTableInfo(this.getTableInfo(newTableName));
        metadataParam.setColumnInfo(this.getColumnInfoList(dbType));
        metadataParam.setIndexInfo(this.getIndexInfoList(dbType));
        metadataParam = DataTypeConvertorFactory.getConvertor(dbType).supplementaryMetadata(metadataParam);
        this.hussarDdlService.createTable(metadataParam);
        this.hussarDdlService.updateIndex(metadataParam);
        logger.debug("\u521b\u5efa\u8868\u6210\u529f\uff1a{}", (Object)newTableName);
    }

    public void afterPropertiesSet() throws Exception {
        this.registerArchiveCreateTableService();
    }

    private String getDbType() {
        DataSource dataSource = (DataSource)SpringContextUtil.getBean(DataSource.class);
        ItemDataSource itemDataSource = DataSourceUtil.getCurrentItemSource((DataSource)dataSource);
        if (HussarUtils.isEmpty((Object)itemDataSource)) {
            throw new HussarException("\u672a\u83b7\u53d6\u5230\u6570\u636e\u6e90\u4fe1\u606f");
        }
        if (HussarUtils.isEmpty((Object)itemDataSource.getDbType())) {
            return DbType.MYSQL.getDb();
        }
        if (DbType.KINGBASE_ES.getDb().equals(itemDataSource.getDbType().getDb())) {
            String dbMode = itemDataSource.getDbMode();
            if ("kingbase_mysql".equals(dbMode)) {
                return DbType.MYSQL.getDb();
            }
            if ("kingbase_oracle".equals(dbMode)) {
                return DbType.ORACLE.getDb();
            }
            if ("kingbase_pg".equals(dbMode)) {
                return DbType.POSTGRE_SQL.getDb();
            }
            return DbType.KINGBASE_ES.getDb();
        }
        return itemDataSource.getDbType().getDb();
    }

    protected boolean isNameLowerCase(String dbType) {
        if (HussarUtils.isBlank((CharSequence)dbType)) {
            return false;
        }
        return DbType.POSTGRE_SQL.getDb().equals(dbType) || DbType.GAUSS.getDb().equals(dbType) || DbType.HIGH_GO.getDb().equals(dbType);
    }

    protected abstract TableInfoDto getTableInfo(String var1);

    protected abstract List<ColumnInfoDto> getColumnInfoList(String var1);

    protected List<IndexInfoDto> getIndexInfoList(String dbType) {
        String columnName = "CREATE_TIME";
        columnName = this.isNameLowerCase(dbType) ? columnName.toLowerCase() : columnName;
        String idxPrefix = "IDX_";
        idxPrefix = this.isNameLowerCase(dbType) ? idxPrefix.toLowerCase() : idxPrefix;
        ArrayList indexInfoList = Lists.newArrayListWithCapacity((int)1);
        IndexInfoDto indexInfoDto = new IndexInfoDto();
        indexInfoDto.setIndexColumns(Collections.singletonList(columnName));
        indexInfoDto.setUnique(false);
        indexInfoDto.setIndexName(idxPrefix + MpUtils.idCreatorStr());
        indexInfoDto.setIndexComment("\u521b\u5efa\u65f6\u95f4\u7d22\u5f15");
        indexInfoList.add(indexInfoDto);
        return indexInfoList;
    }

    protected abstract void registerArchiveCreateTableService();
}

