/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.audit.core.util.DataSourceUtil;
import com.jxdinfo.hussar.support.audit.plugin.archive.conditions.MybatisCondition;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={MybatisCondition.class})
public class DruidDynamicInserter {
    private static final Logger log = LoggerFactory.getLogger(DruidDynamicInserter.class);

    public <T> void insertWithDynamicBatch(List<T> data, Function<List<T>, Boolean> insertOperation) {
        double usageRatio;
        DruidDataSource druidDataSource = this.getDruidDataSource();
        if (druidDataSource == null) {
            this.defaultBatchInsert(data, insertOperation, 500);
            return;
        }
        int retryCount = 0;
        int maxRetries = 30;
        long minWaitTimeMs = 1000L;
        long maxWaitTimeMs = 1500L;
        while (!((usageRatio = this.calculateConnectionUsageRatio(druidDataSource)) <= 0.7)) {
            if (++retryCount > maxRetries) {
                log.warn("\u5df2\u8fbe\u5230\u6700\u5927\u91cd\u8bd5\u6b21\u6570({})\uff0c\u5373\u4f7f\u8fde\u63a5\u4f7f\u7528\u7387({}%)\u4ecd\u9ad8\u4e8e70%\uff0c\u4e5f\u5c06\u7ee7\u7eed\u6267\u884c\u63d2\u5165\u64cd\u4f5c", (Object)maxRetries, (Object)String.format("%.2f", usageRatio * 100.0));
                break;
            }
            log.debug("\u8fde\u63a5\u4f7f\u7528\u7387({}%)\u8d85\u8fc770%\uff0c\u7b2c{}\u6b21\u5ef6\u8fdf\u6267\u884c\u63d2\u5165\u64cd\u4f5c", (Object)String.format("%.2f", usageRatio * 100.0), (Object)retryCount);
            long randomWaitTimeMs = minWaitTimeMs + (long)(Math.random() * (double)(maxWaitTimeMs - minWaitTimeMs));
            try {
                Thread.sleep(randomWaitTimeMs);
            }
            catch (InterruptedException e) {
                log.error("\u5ef6\u8fdf\u6267\u884c\u5f02\u5e38\uff0c\u539f\u56e0:", (Throwable)e);
                Thread.currentThread().interrupt();
                break;
            }
        }
        int batchSize = this.determineBatchSize(usageRatio);
        log.info("\u5f53\u524d\u8fde\u63a5\u4f7f\u7528\u7387: {}%\uff0c\u8c03\u6574\u540e\u6279\u6b21\u5927\u5c0f: {}", (Object)String.format("%.2f", usageRatio * 100.0), (Object)batchSize);
        this.defaultBatchInsert(data, insertOperation, batchSize);
    }

    public <T> boolean smartInsert(List<T> data, Function<List<T>, Boolean> insertOperation, long maxWaitTimeMs) throws InterruptedException {
        DruidDataSource druidDataSource = this.getDruidDataSource();
        if (druidDataSource == null) {
            return insertOperation.apply(data);
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < maxWaitTimeMs) {
            double usageRatio = this.calculateConnectionUsageRatio(druidDataSource);
            if (usageRatio > 0.85) {
                log.warn("\u6570\u636e\u5e93\u8fde\u63a5\u4f7f\u7528\u7387\u8fc7\u9ad8({}%)\uff0c\u7b49\u5f85\u540e\u518d\u5c1d\u8bd5\u63d2\u5165...", (Object)String.format("%.2f", usageRatio * 100.0));
                Thread.sleep(1000L);
                continue;
            }
            int batchSize = this.determineBatchSize(usageRatio);
            log.info("\u52a8\u6001\u667a\u80fd\u63d2\u5165\uff0c\u5f53\u524d\u8fde\u63a5\u4f7f\u7528\u7387: {}%\uff0c\u8c03\u6574\u540e\u6279\u6b21\u5927\u5c0f: {}", (Object)String.format("%.2f", usageRatio * 100.0), (Object)batchSize);
            this.defaultBatchInsert(data, insertOperation, batchSize);
            return true;
        }
        log.error("\u7b49\u5f85\u8d85\u65f6\uff0c\u672a\u80fd\u6267\u884c\u6570\u636e\u63d2\u5165\u64cd\u4f5c");
        return false;
    }

    private DruidDataSource getDruidDataSource() {
        try {
            DataSource dataSource = (DataSource)SpringContextUtil.getBean(DataSource.class);
            ItemDataSource itemDataSource = DataSourceUtil.getCurrentItemSource((DataSource)dataSource);
            if (HussarUtils.isEmpty((Object)itemDataSource)) {
                throw new HussarException("\u672a\u83b7\u53d6\u5230\u6570\u636e\u6e90\u4fe1\u606f");
            }
            DataSource realDataSource = itemDataSource.getDataSource();
            if (realDataSource instanceof DruidDataSource) {
                return (DruidDataSource)realDataSource;
            }
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6Druid\u6570\u636e\u6e90\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    private double calculateConnectionUsageRatio(DruidDataSource druidDataSource) {
        int activeCount = druidDataSource.getActiveCount();
        int maxActive = druidDataSource.getMaxActive();
        if (maxActive <= 0) {
            return 0.0;
        }
        return (double)activeCount / (double)maxActive;
    }

    private int determineBatchSize(double usageRatio) {
        if (usageRatio >= 0.9) {
            return 50;
        }
        if (usageRatio >= 0.7) {
            return 100;
        }
        if (usageRatio >= 0.5) {
            return 200;
        }
        return 500;
    }

    private <T> void defaultBatchInsert(List<T> data, Function<List<T>, Boolean> insertOperation, int batchSize) {
        if (HussarUtils.isEmpty(data)) {
            return;
        }
        int size = data.size();
        int i = 0;
        while (i < size) {
            int endIndex = Math.min(i + batchSize, size);
            if (i >= endIndex) {
                log.warn("\u68c0\u6d4b\u5230\u65e0\u6548\u7684\u7d22\u5f15\u8303\u56f4: i={}, endIndex={}, size={}", new Object[]{i, endIndex, size});
                break;
            }
            log.debug("\u5206\u6279\u63d2\u5165\u6570\u636e\uff0c\u6279\u6b21\u7d22\u5f15\u8303\u56f4: {}-{}\uff0c\u6279\u6b21\u5927\u5c0f: {}", new Object[]{i, endIndex - 1, endIndex - i});
            try {
                ArrayList<T> batch = new ArrayList<T>(data.subList(i, endIndex));
                insertOperation.apply(batch);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u63d2\u5165\u5931\u8d25\uff0c\u7d22\u5f15\u8303\u56f4: {}-{}", new Object[]{i, endIndex - 1, e});
            }
            i = endIndex;
        }
    }
}

