/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.archive.enums.ArchiveRecoverStatus;
import com.jxdinfo.hussar.support.audit.core.archive.model.ArchiveRecoverEntity;
import com.jxdinfo.hussar.support.audit.core.archive.service.ArchiveRecoverService;
import com.jxdinfo.hussar.support.audit.core.archive.service.RecoverService;
import com.jxdinfo.hussar.support.audit.core.archive.vo.ArchiveRecoverParam;
import com.jxdinfo.hussar.support.audit.core.archive.vo.ArchiveRecoverVo;
import com.jxdinfo.hussar.support.audit.core.archive.vo.RecoverDataParam;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.ArchiveRecoverDaoService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
public class ArchiveRecoverServiceImpl
implements ArchiveRecoverService {
    @Autowired
    private ArchiveRecoverDaoService archiveRecoverDaoService;
    @Autowired
    private RecoverService recoverService;

    public IPage<ArchiveRecoverVo> page(IPage<ArchiveRecoverVo> page, ArchiveRecoverParam recoverParam) {
        IPage pageList;
        Page pageParams = new Page(page.getCurrent(), page.getSize());
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(HussarUtils.isNotBlank((CharSequence)recoverParam.getSourceTableName()), ArchiveRecoverEntity::getSourceTableName, (Object)recoverParam.getSourceTableName().replace("%", "\\%"))).eq(HussarUtils.isNotEmpty((Object)recoverParam.getRecoverStatus()), ArchiveRecoverEntity::getRecoverStatus, (Object)recoverParam.getRecoverStatus())).orderByDesc(HussarBaseEntity::getCreateTime);
        if (HussarUtils.isNotBlank((CharSequence)recoverParam.getRecoverStartupTime())) {
            queryWrapper.ge(ArchiveRecoverEntity::getRecoverStartupTime, (Object)LocalDateTime.parse(recoverParam.getRecoverStartupTime(), dateTimeFormatter));
        }
        if (HussarUtils.isNotBlank((CharSequence)recoverParam.getRecoverEndTime())) {
            queryWrapper.le(ArchiveRecoverEntity::getRecoverEndTime, (Object)LocalDateTime.parse(recoverParam.getRecoverEndTime(), dateTimeFormatter));
        }
        if (HussarUtils.isEmpty((Object)(pageList = this.archiveRecoverDaoService.page((IPage)pageParams, (Wrapper)queryWrapper))) || HussarUtils.isEmpty((Object)pageList.getRecords())) {
            return new Page(page.getCurrent(), page.getSize());
        }
        HashMap tableNameMap = Maps.newHashMapWithExpectedSize((int)3);
        tableNameMap.put("SYS_SUPPORT_AUDIT_LOG", Lists.newArrayList((Object[])new String[]{"SYS_SUPPORT_AUDIT_LOG_TABLE", "SYS_SUPPORT_AUDIT_LOG_COLUMN"}));
        tableNameMap.put("SYS_SUPPORT_AUDIT_LOG_TABLE", Lists.newArrayList((Object[])new String[]{"SYS_SUPPORT_AUDIT_LOG", "SYS_SUPPORT_AUDIT_LOG_COLUMN"}));
        tableNameMap.put("SYS_SUPPORT_AUDIT_LOG_COLUMN", Lists.newArrayList((Object[])new String[]{"SYS_SUPPORT_AUDIT_LOG", "SYS_SUPPORT_AUDIT_LOG_TABLE"}));
        List records = pageList.getRecords();
        ArrayList archiveRecoverVos = Lists.newArrayListWithCapacity((int)records.size());
        records.forEach(record -> {
            ArchiveRecoverVo recoverVo = new ArchiveRecoverVo();
            BeanUtil.copy((Object)record, (Object)recoverVo);
            recoverVo.setOtherTableNames((List)tableNameMap.get(record.getSourceTableName()));
            archiveRecoverVos.add(recoverVo);
        });
        Page pageResult = new Page(page.getCurrent(), page.getSize());
        pageResult.setRecords((List)archiveRecoverVos);
        pageResult.setTotal(pageList.getTotal());
        return pageResult;
    }

    public Boolean recover(Long archiveRecoverId) {
        ArchiveRecoverEntity archiveRecoverEntity = (ArchiveRecoverEntity)this.archiveRecoverDaoService.getById(archiveRecoverId);
        if (HussarUtils.isEmpty((Object)archiveRecoverEntity)) {
            throw new HussarException("\u6062\u590d\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (!ArchiveRecoverStatus.RECOVER_FAIL.getCode().equals(archiveRecoverEntity.getRecoverStatus())) {
            throw new HussarException("\u6062\u590d\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ArchiveRecoverEntity::getSourceTableName, (Object)archiveRecoverEntity.getSourceTableName())).eq(ArchiveRecoverEntity::getRecoverStatus, (Object)ArchiveRecoverStatus.RECOVERING.getCode())).eq(ArchiveRecoverEntity::getRecoverStartupTime, (Object)archiveRecoverEntity.getRecoverStartupTime())).eq(ArchiveRecoverEntity::getRecoverEndTime, (Object)archiveRecoverEntity.getRecoverEndTime());
        long count = this.archiveRecoverDaoService.count((Wrapper)queryWrapper);
        if (count > 0L) {
            throw new HussarException("\u8be5\u8868\u6570\u636e\u6b63\u5728\u6062\u590d\u4e2d");
        }
        queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ArchiveRecoverEntity::getSourceTableName, (Object)archiveRecoverEntity.getSourceTableName())).eq(ArchiveRecoverEntity::getRecoverStatus, (Object)ArchiveRecoverStatus.RECOVER_SUCCESS.getCode())).eq(ArchiveRecoverEntity::getRecoverStartupTime, (Object)archiveRecoverEntity.getRecoverStartupTime())).eq(ArchiveRecoverEntity::getRecoverEndTime, (Object)archiveRecoverEntity.getRecoverEndTime())).gt(ArchiveRecoverEntity::getDataStorageTime, (Object)LocalDateTime.now());
        count = this.archiveRecoverDaoService.count((Wrapper)queryWrapper);
        if (count > 0L) {
            throw new HussarException("\u8be5\u8868\u6570\u636e\u5df2\u7ecf\u6062\u590d");
        }
        LocalDateTime recoverStartupTime = archiveRecoverEntity.getRecoverStartupTime();
        LocalDateTime recoverEndTime = archiveRecoverEntity.getRecoverEndTime();
        List recoverEntities = this.archiveRecoverDaoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ArchiveRecoverEntity::getRecoverStatus, (Object)ArchiveRecoverStatus.RECOVER_FAIL.getCode())).eq(ArchiveRecoverEntity::getRecoverStartupTime, (Object)recoverStartupTime)).le(ArchiveRecoverEntity::getRecoverEndTime, (Object)recoverEndTime));
        if (HussarUtils.isEmpty((Object)recoverEntities)) {
            throw new HussarException("\u9700\u8981\u6062\u590d\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        List recoverVos = recoverEntities.stream().map(entity -> {
            ArchiveRecoverVo recoverVo = new ArchiveRecoverVo();
            BeanUtil.copy((Object)entity, (Object)recoverVo);
            return recoverVo;
        }).collect(Collectors.toList());
        archiveRecoverEntity.setRecoverStatus(ArchiveRecoverStatus.RECOVERING.getCode());
        this.archiveRecoverDaoService.updateById(archiveRecoverEntity);
        RecoverDataParam recoverDataParam = new RecoverDataParam();
        recoverDataParam.setArchiveRecoverVos(recoverVos);
        this.recoverService.recoverData(recoverDataParam);
        return Boolean.TRUE;
    }

    public Boolean exitsProtectedData() {
        ArrayList tableNames = Lists.newArrayList((Object[])new String[]{"SYS_SUPPORT_AUDIT_LOG", "SYS_SUPPORT_AUDIT_LOG_TABLE", "SYS_SUPPORT_AUDIT_LOG_COLUMN"});
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ArchiveRecoverEntity::getSourceTableName, (Collection)tableNames)).eq(ArchiveRecoverEntity::getRecoverStatus, (Object)ArchiveRecoverStatus.RECOVER_SUCCESS.getCode())).gt(ArchiveRecoverEntity::getDataStorageTime, (Object)LocalDateTime.now());
        long count = this.archiveRecoverDaoService.count((Wrapper)queryWrapper);
        return count > 0L;
    }
}

