/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogTableEntity;
import com.jxdinfo.hussar.support.audit.plugin.archive.conditions.MybatisCondition;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.dao.AuditLogTableArchiveMapper;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.AuditLogTableArchiveDaoService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
@Conditional(value={MybatisCondition.class})
public class AuditLogTableArchiveDaoServiceImpl
implements AuditLogTableArchiveDaoService {
    private static final int MAX_BATCH_SIZE = 100;
    @Autowired
    private AuditLogTableArchiveMapper auditLogTableArchiveMapper;

    @Override
    public int batchInsert(String tableNamePrefix, String tableNameSuffix, List<AuditLogTableEntity> auditLogTableEntities) {
        if (HussarUtils.isEmpty(auditLogTableEntities)) {
            return 0;
        }
        int size = auditLogTableEntities.size();
        int batchIndex = size % 100 == 0 ? size / 100 : size / 100 + 1;
        for (int i = 0; i < batchIndex; ++i) {
            int start = i * 100;
            int end = Math.min(start + 100, size);
            List<AuditLogTableEntity> subList = auditLogTableEntities.subList(start, end);
            this.auditLogTableArchiveMapper.batchInsert(tableNamePrefix, tableNameSuffix, subList);
        }
        return size;
    }

    @Override
    public int deleteByCreateTime(String tableNamePrefix, String tableNameSuffix, LocalDateTime startTime, LocalDateTime endTime) {
        return this.auditLogTableArchiveMapper.deleteByCreateTime(tableNamePrefix, tableNameSuffix, startTime, endTime);
    }

    @Override
    public List<AuditLogTableEntity> selectByCreateTime(String tableNamePrefix, String tableNameSuffix, LocalDateTime startTime, LocalDateTime endTime) {
        return this.auditLogTableArchiveMapper.selectListByCreateTime(tableNamePrefix, tableNameSuffix, startTime, endTime);
    }

    @Override
    public LocalDateTime selectMinCreateTime(LocalDateTime endTime) {
        return this.auditLogTableArchiveMapper.selectMinCreateTime(endTime);
    }
}

