/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.IndexInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.factory.CreateTableHandlerFactory;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.impl.AbstractArchiveCreateTableService;
import com.jxdinfo.hussar.support.audit.plugin.archive.utils.ColumnInfoDtoUtil;
import com.jxdinfo.hussar.support.mp.utils.MpUtils;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.stereotype.Service;

@Service(value="auditLogTableArchiveCreateTableService")
public class AuditLogTableArchiveCreateTableServiceImpl
extends AbstractArchiveCreateTableService {
    @Override
    protected TableInfoDto getTableInfo(String newTableName) {
        TableInfoDto tableInfoDto = new TableInfoDto();
        tableInfoDto.setTableName(newTableName);
        tableInfoDto.setTableDec("\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55\u5f52\u6863\u8868");
        tableInfoDto.setPollName("master");
        return tableInfoDto;
    }

    @Override
    protected List<ColumnInfoDto> getColumnInfoList() {
        ColumnInfoDtoUtil columnInfoDtoUtil = new ColumnInfoDtoUtil(Lists.newArrayListWithCapacity((int)24));
        columnInfoDtoUtil.add(JDBCType.CLOB, "DIFF_VALUE", "\u53d8\u66f4\u7684\u503c");
        columnInfoDtoUtil.add(JDBCType.CLOB, "QUERY_CONDITION", "\u67e5\u8be2\u6761\u4ef6\u5220\u9664\u548c\u4fee\u6539");
        columnInfoDtoUtil.add(JDBCType.BIGINT, "TENANT_ID", "\u6240\u5c5e\u79df\u6237", 20L);
        columnInfoDtoUtil.add(JDBCType.BIGINT, "AUDIT_LOG_TABLE_ID", "\u4e3b\u952e", 20L);
        columnInfoDtoUtil.add(JDBCType.BIGINT, "CREATOR", "\u521b\u5efa\u4eba", 20L);
        columnInfoDtoUtil.add(JDBCType.BIGINT, "LAST_EDITOR", "\u66f4\u65b0\u4eba", 20L);
        columnInfoDtoUtil.add(JDBCType.INTEGER, "TOTAL", "\u4fee\u6539\u5217\u603b\u6570\u91cf", 11L);
        columnInfoDtoUtil.add(JDBCType.TIMESTAMP, "CREATE_TIME", "\u521b\u5efa\u65f6\u95f4");
        columnInfoDtoUtil.add(JDBCType.TIMESTAMP, "LAST_TIME", "\u66f4\u65b0\u65f6\u95f4");
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "AFTER_VERSION", "\u4fee\u6539\u4e4b\u540e\u7684\u7248\u672c", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "BEFORE_VERSION", "\u4fee\u6539\u4e4b\u524d\u7684\u7248\u672c", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "CREATOR_NAME", "\u521b\u5efa\u4eba\u59d3\u540d", 255L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "LAST_EDITOR_NAME", "\u6700\u540e\u4e00\u6b21\u4fee\u6539\u4eba\u59d3\u540d", 255L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "METHOD_ID", "\u65b9\u6cd5ID", 512L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "OPERATE_MODE", "\u64cd\u4f5c\u7c7b\u578b INSERT\uff1a\u6dfb\u52a0/UPDATE\uff1a\u4fee\u6539\uff1aDELETE\uff1a\u5220\u9664", 16L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "REMARK", "\u5907\u6ce8", 256L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "SCHEMA_NAME", "\u6570\u636e\u5e93\u540d\u79f0", 1024L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "SERVER_NAME", "\u670d\u52a1\u540d\u79f0", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "SERVER_VERSION", "\u670d\u52a1\u7248\u672c", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "TABLE_DESC", "\u8868\u63cf\u8ff0", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "TABLE_NAME", "\u4fee\u6539\u7684\u8868\u540d\u79f0", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "COMMIT_ID", "\u5f53\u6b21\u4f1a\u8bdd\u63d0\u4ea4\u552f\u4e00\u6807\u8bc6", 128L);
        columnInfoDtoUtil.add(JDBCType.CHAR, "DEL_FLAG", "\u5220\u9664\u6807\u8bc6", 1L);
        HashMap consumerMap = Maps.newHashMapWithExpectedSize((int)2);
        consumerMap.put("TENANT_ID", action -> action.setDefaultValue("0"));
        consumerMap.put("DEL_FLAG", action -> action.setDefaultValue("0"));
        consumerMap.put("AUDIT_LOG_TABLE_ID", action -> {
            action.setPk("1");
            action.setRequired("1");
        });
        List<ColumnInfoDto> result = columnInfoDtoUtil.getColumnInfoDtoList();
        result.forEach(action -> {
            if (consumerMap.containsKey(action.getColumnName())) {
                ((Consumer)consumerMap.get(action.getColumnName())).accept(action);
            }
        });
        return result;
    }

    @Override
    protected List<IndexInfoDto> getIndexInfoList() {
        ArrayList indexInfoList = Lists.newArrayListWithCapacity((int)2);
        IndexInfoDto indexInfoDto = new IndexInfoDto();
        indexInfoDto.setIndexColumns(Collections.singletonList("CREATE_TIME"));
        indexInfoDto.setUnique(false);
        indexInfoDto.setIndexName("IDX_" + MpUtils.idCreatorStr());
        indexInfoDto.setIndexComment("\u521b\u5efa\u65f6\u95f4\u7d22\u5f15");
        indexInfoList.add(indexInfoDto);
        return indexInfoList;
    }

    @Override
    protected void registerArchiveCreateTableService() {
        CreateTableHandlerFactory.register("SYS_SUPPORT_AUDIT_LOG_TABLE", this);
    }
}

