/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogEntity;
import com.jxdinfo.hussar.support.audit.plugin.archive.conditions.MybatisCondition;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.dao.AuditLogArchiveMapper;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.AuditLogArchiveDaoService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
@Conditional(value={MybatisCondition.class})
public class AuditLogArchiveDaoServiceImpl
implements AuditLogArchiveDaoService {
    private static final int MAX_BATCH_SIZE = 100;
    @Autowired
    private AuditLogArchiveMapper auditLogArchiveMapper;

    @Override
    public int batchInsert(String tableNamePrefix, String tableNameSuffix, List<AuditLogEntity> auditLogEntityList) {
        if (HussarUtils.isEmpty(auditLogEntityList)) {
            return 0;
        }
        int size = auditLogEntityList.size();
        int batchIndex = size % 100 == 0 ? size / 100 : size / 100 + 1;
        for (int i = 0; i < batchIndex; ++i) {
            int startIndex = i * 100;
            int endIndex = Math.min(startIndex + 100, size);
            List<AuditLogEntity> subList = auditLogEntityList.subList(startIndex, endIndex);
            this.auditLogArchiveMapper.batchInsert(tableNamePrefix, tableNameSuffix, subList);
        }
        return size;
    }

    @Override
    public int deleteByCreateTime(String tableNamePrefix, String tableNameSuffix, LocalDateTime startTime, LocalDateTime endTime) {
        return this.auditLogArchiveMapper.deleteByCreateTime(tableNamePrefix, tableNameSuffix, startTime, endTime);
    }

    @Override
    public List<AuditLogEntity> selectByCreateTime(String tableNamePrefix, String tableNameSuffix, LocalDateTime startTime, LocalDateTime endTime) {
        return this.auditLogArchiveMapper.selectListByCreateTime(tableNamePrefix, tableNameSuffix, startTime, endTime);
    }

    @Override
    public LocalDateTime selectMinCreateTime(LocalDateTime endTime) {
        return this.auditLogArchiveMapper.selectMinCreateTime(endTime);
    }
}

