/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.mongo.repository;

import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogTableEntity;
import com.jxdinfo.hussar.support.audit.plugin.archive.conditions.MongoCondition;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
@Conditional(value={MongoCondition.class})
public class AuditLogTableArchiveRepository {
    private static final String AUDIT_LOG_TABLE_ENTITY = "auditLogTableEntity";
    @Autowired
    private MongoTemplate mongoTemplate;

    public Integer batchInsert(String tablePrefix, String tableSuffix, List<AuditLogTableEntity> auditLogTableEntities) {
        this.mongoTemplate.insert(auditLogTableEntities, AUDIT_LOG_TABLE_ENTITY + tableSuffix);
        return auditLogTableEntities.size();
    }

    public List<AuditLogTableEntity> selectListByCreateTime(String tablePrefix, String tableSuffix, LocalDateTime startTime, LocalDateTime endTime) {
        Criteria criteria = Criteria.where((String)"createTime").gte((Object)startTime).lte((Object)endTime);
        Query query = Query.query((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, AuditLogTableEntity.class, AUDIT_LOG_TABLE_ENTITY + tableSuffix);
    }

    public LocalDateTime selectMinCreateTime() {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.group((String[])new String[0]).min("createTime").as("createTime")});
        AggregationResults aggregate = this.mongoTemplate.aggregate(aggregation, AuditLogTableEntity.class, AuditLogTableEntity.class);
        return ((AuditLogTableEntity)aggregate.getMappedResults().get(0)).getCreateTime();
    }

    public Long deleteByCreateTime(String tablePrefix, String tableSuffix, LocalDateTime startTime, LocalDateTime endTime) {
        Criteria criteria = Criteria.where((String)"createTime").gte((Object)startTime).lte((Object)endTime);
        Query query = Query.query((CriteriaDefinition)criteria);
        return this.mongoTemplate.remove(query, AUDIT_LOG_TABLE_ENTITY + tableSuffix).getDeletedCount();
    }
}

