/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.mongo.handler;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogTableEntity;
import com.jxdinfo.hussar.support.audit.plugin.archive.conditions.MongoCondition;
import com.jxdinfo.hussar.support.audit.plugin.archive.factory.RecoverHandlerFactory;
import com.jxdinfo.hussar.support.audit.plugin.archive.handler.AbstractRecoverHandler;
import com.jxdinfo.hussar.support.audit.plugin.archive.mongo.repository.AuditLogTableArchiveRepository;
import com.jxdinfo.hussar.support.audit.plugin.mongodb.repository.AuditLogTableRepository;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service(value="auditLogTableMongoRecoverHandler")
@HussarDs(value="master")
@Conditional(value={MongoCondition.class})
public class AuditLogTableMongoRecoverHandler
extends AbstractRecoverHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuditLogTableMongoRecoverHandler.class);
    @Autowired
    private AuditLogTableArchiveRepository auditLogTableArchiveRepository;
    @Autowired
    private AuditLogTableRepository auditLogTableRepository;
    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    protected long getSourceDataCount(LocalDateTime startTime, LocalDateTime endTime) {
        Criteria criteria = Criteria.where((String)"createTime").gte((Object)startTime).lte((Object)endTime);
        Query query = Query.query((CriteriaDefinition)criteria);
        return this.mongoTemplate.count(query, AuditLogTableEntity.class);
    }

    @Override
    protected Long recoverColdDataByJson(String jsonFileContent) {
        List logTableEntities = JsonUtil.parseArray((String)jsonFileContent, AuditLogTableEntity.class);
        if (HussarUtils.isEmpty((Object)logTableEntities)) {
            return 0L;
        }
        logger.debug("\u6062\u590d\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55\u51b7\u6570\u636e\uff0c\u6279\u91cf\u6062\u590d\u81f3\u6e90\u6570\u636e\u8868");
        this.auditLogTableRepository.saveAll((Iterable)logTableEntities);
        return logTableEntities.size();
    }

    @Override
    protected long getArchiveDataCount(String tableName, LocalDateTime startTime, LocalDateTime endTime) {
        Criteria criteria = Criteria.where((String)"createTime").gte((Object)startTime).lte((Object)endTime);
        Query query = Query.query((CriteriaDefinition)criteria);
        return this.mongoTemplate.count(query, AuditLogTableEntity.class, "auditLogTableEntity" + tableName.substring(tableName.lastIndexOf("_") + 1));
    }

    @Override
    protected void removeArchiveTableData(String tableNamePrefix, String tableNameSuffix, LocalDateTime archiveStartTime, LocalDateTime archiveEndTime) {
        this.auditLogTableArchiveRepository.deleteByCreateTime(tableNamePrefix, tableNameSuffix, archiveStartTime, archiveEndTime);
    }

    @Override
    protected void recoverWarmDataByDay(String archiveTablePrefix, String tableNameSuffix, YearMonth yearMonth, Integer day, Integer batchSize) {
        logger.debug("\u6309\u5929\u6062\u590d\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55\u70ed\u6570\u636e\uff0c\u5e74\u6708:{}\uff0c\u5929:{}", (Object)yearMonth, (Object)day);
        LocalDateTime startTime = LocalDateTime.of(yearMonth.getYear(), yearMonth.getMonth(), (int)day, 0, 0);
        LocalDateTime endTime = LocalDateTime.of(yearMonth.getYear(), yearMonth.getMonth(), (int)day, 23, 59, 59);
        logger.debug("\u6309\u5929\u6062\u590d\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55\u70ed\u6570\u636e\uff0c\u67e5\u8be2\u5f52\u6863\u8868\uff0c\u5f00\u59cb\u65f6\u95f4:{}\uff0c\u7ed3\u675f\u65f6\u95f4:{}", (Object)startTime, (Object)endTime);
        List<AuditLogTableEntity> auditLogTableEntities = this.auditLogTableArchiveRepository.selectListByCreateTime(archiveTablePrefix, tableNameSuffix, startTime, endTime);
        if (HussarUtils.isEmpty(auditLogTableEntities)) {
            logger.debug("\u6309\u5929\u6062\u590d\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55\u70ed\u6570\u636e\uff0c\u5f52\u6863\u8868\u65e0\u6570\u636e");
            return;
        }
        logger.debug("\u6309\u5929\u6062\u590d\u5ba1\u8ba1\u65e5\u5fd7\u6e29\u6570\u636e\uff0c\u6279\u91cf\u6062\u590d\u81f3\u5ba1\u8ba1\u65e5\u5fd7\uff0c\u6279\u91cf\u6570\u91cf\uff1a{}", (Object)batchSize);
        for (int i = 0; i < auditLogTableEntities.size(); i += batchSize.intValue()) {
            int endIndex = Math.min(i + batchSize, auditLogTableEntities.size());
            List<AuditLogTableEntity> batch = auditLogTableEntities.subList(i, endIndex);
            this.auditLogTableRepository.saveAll(batch);
        }
    }

    @Override
    public void registryRecoverHandler() {
        RecoverHandlerFactory.register("SYS_SUPPORT_AUDIT_LOG_TABLE", this);
    }
}

