/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.handler;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.FileUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IoUtil;
import com.jxdinfo.hussar.platform.core.utils.file.ZipUtil;
import com.jxdinfo.hussar.support.audit.core.archive.HussarBaseMultipartFile;
import com.jxdinfo.hussar.support.audit.core.archive.enums.ArchiveDataType;
import com.jxdinfo.hussar.support.audit.core.archive.enums.ArchiveExecType;
import com.jxdinfo.hussar.support.audit.core.archive.enums.ArchiveRecoverStatus;
import com.jxdinfo.hussar.support.audit.core.archive.enums.ArchiveStatus;
import com.jxdinfo.hussar.support.audit.core.archive.handler.ArchiveHandler;
import com.jxdinfo.hussar.support.audit.core.archive.model.ArchiveRecordEntity;
import com.jxdinfo.hussar.support.audit.core.archive.model.ArchiveRecoverEntity;
import com.jxdinfo.hussar.support.audit.core.archive.service.ArchiveBaseConfigService;
import com.jxdinfo.hussar.support.audit.core.archive.vo.ArchiveConfigVo;
import com.jxdinfo.hussar.support.audit.core.archive.vo.ArchiveRecordVo;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.ArchiveRecordDaoService;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.ArchiveRecoverDaoService;
import com.jxdinfo.hussar.support.audit.plugin.archive.service.ArchiveCreateTableService;
import com.jxdinfo.hussar.support.audit.plugin.archive.utils.LocalDateTimeUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.lock.HussarLockGuard;
import com.jxdinfo.hussar.support.lock.HussarLockManager;
import com.jxdinfo.hussar.support.lock.HussarLockType;
import com.jxdinfo.hussar.support.lock.annotation.HussarLockExecutionStrategy;
import com.jxdinfo.hussar.support.mp.utils.MpUtils;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.thread.core.RejectedExecutionHandlerEnum;
import com.jxdinfo.hussar.support.thread.support.executor.HussarTaskExecutor;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractArchiveHandler
implements ArchiveHandler,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AbstractArchiveHandler.class);
    @Autowired
    private ArchiveRecoverDaoService archiveRecoverService;
    @Autowired
    private ArchiveRecordDaoService archiveRecordService;
    @Autowired
    private ArchiveCreateTableService archiveCreateTableService;
    @Autowired
    private HussarLockManager hussarLockManager;
    @Autowired
    private OssService ossService;
    @Autowired
    private HussarTaskExecutor hussarTaskExecutor;
    @Autowired
    private ArchiveBaseConfigService archiveBaseConfigService;

    public void archiveData(ArchiveConfigVo archiveConfigVo, ArchiveExecType archiveExecType) {
        logger.debug("\u5f00\u59cb\u5f52\u6863\u6570\u636e");
        LocalDateTime coldArchiveTime = archiveConfigVo.getColdArchiveTime();
        LocalDateTime minCreateTime = this.getMinCreateTime(coldArchiveTime);
        this.archiveColdData(archiveConfigVo, minCreateTime, archiveExecType);
        this.archiveWarmData(archiveConfigVo, minCreateTime, archiveExecType);
        logger.debug("\u6570\u636e\u5f52\u6863\u5b8c\u6210");
    }

    public abstract void registryArchiveHandler();

    public void archiveData(ArchiveRecordVo recordVo) {
        logger.debug("\u5f00\u59cb\u6839\u636e\u5f52\u6863\u8bb0\u5f55\u4fe1\u606f\u5f52\u6863\u6570\u636e");
        LocalDateTime startTime = recordVo.getArchiveStartupTime();
        LocalDateTime endTime = recordVo.getArchiveEndTime();
        Integer archiveType = recordVo.getArchiveType();
        String sourceTableName = recordVo.getSourceTableName();
        logger.debug("\u5f52\u6863\u6570\u636e\uff0c\u6839\u636e\u6e90\u6570\u636e\u8868\u540d\u67e5\u8be2\u5f52\u6863\u914d\u7f6e\uff0c\u6e90\u6570\u636e\u8868\u540d:{}", (Object)sourceTableName);
        List configEntities = this.archiveBaseConfigService.getArchiveConfigList();
        if (HussarUtils.isEmpty((Object)configEntities)) {
            logger.debug("\u5f52\u6863\u914d\u7f6e\u4e0d\u5b58\u5728");
            return;
        }
        logger.debug("\u5f52\u6863\u6570\u636e\uff0c\u6839\u636e\u65f6\u95f4\u533a\u95f4\u83b7\u53d6\u6e90\u6570\u636e\u8868\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4:{}\uff0c\u7ed3\u675f\u65f6\u95f4:{}", (Object)startTime, (Object)endTime);
        Long count = this.getSourceDataCount(startTime, endTime);
        if (count <= 0L) {
            logger.debug("\u5f52\u6863\u6570\u636e\uff0c\u6e90\u6570\u636e\u8868\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u9700\u5f52\u6863");
            return;
        }
        ArchiveRecordEntity archiveRecordEntity = new ArchiveRecordEntity();
        BeanUtil.copy((Object)recordVo, (Object)archiveRecordEntity);
        if (archiveType.equals(ArchiveDataType.COLD_DATA.getCode())) {
            logger.debug("\u5f52\u6863\u6570\u636e\uff0c\u5f00\u59cb\u6309\u6708\u5f52\u6863\u51b7\u6570\u636e");
            this.archiveColdDataByMonth(count, ArchiveDataType.COLD_DATA, archiveRecordEntity);
            return;
        }
        logger.debug("\u5f00\u59cb\u6839\u636e\u5f52\u6863\u8bb0\u5f55\u6309\u6708\u5f52\u6863\u6e29\u6570\u636e");
        this.archiveWarmDataByMonth(archiveRecordEntity, endTime, false);
        logger.debug("\u6839\u636e\u5f52\u6863\u4fe1\u606f\u6570\u636e\u5f52\u6863\u5b8c\u6210");
    }

    protected abstract LocalDateTime getMinCreateTime(LocalDateTime var1);

    protected abstract Long getSourceDataCount(LocalDateTime var1, LocalDateTime var2);

    protected Long getArchiveRecoverCount(String sourceTableName, LocalDateTime startTime, LocalDateTime endTime) {
        return this.archiveRecoverService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ArchiveRecoverEntity::getSourceTableName, (Object)sourceTableName)).eq(ArchiveRecoverEntity::getRecoverStatus, (Object)ArchiveRecoverStatus.RECOVER_SUCCESS.getCode())).eq(ArchiveRecoverEntity::getRecoverStartupTime, (Object)startTime)).eq(ArchiveRecoverEntity::getRecoverEndTime, (Object)endTime)).gt(ArchiveRecoverEntity::getDataStorageTime, (Object)LocalDateTime.now()));
    }

    protected ArchiveRecordEntity getArchiveRecordEntity(String sourceTableName, ArchiveDataType archiveDataType, LocalDateTime startTime, LocalDateTime endTime, ArchiveStatus archiveStatus) {
        return (ArchiveRecordEntity)this.archiveRecordService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ArchiveRecordEntity::getSourceTableName, (Object)sourceTableName)).eq(ArchiveRecordEntity::getArchiveType, (Object)archiveDataType.getCode())).eq(ArchiveRecordEntity::getArchiveStatus, (Object)archiveStatus.getCode())).eq(ArchiveRecordEntity::getArchiveStartupTime, (Object)startTime)).eq(ArchiveRecordEntity::getArchiveEndTime, (Object)endTime));
    }

    protected HussarLockGuard lock(String sourceTableName, String tableNameSuffix) {
        String lockKey = "hussar:archive:lock:" + sourceTableName + ":" + tableNameSuffix;
        return this.hussarLockManager.acquire(HussarLockType.REENTRANT_LOCK, HussarLockExecutionStrategy.UNLIMITED, lockKey, Duration.ofMinutes(30L));
    }

    protected abstract void removeSourceData(LocalDateTime var1, LocalDateTime var2);

    protected abstract long getArchiveDataCount(String var1, String var2, LocalDateTime var3, LocalDateTime var4);

    protected void updateArchiveRecord(ArchiveRecordEntity archiveRecordEntity, String dataLocation, LocalDateTime archiveEndTime, ArchiveStatus archiveStatus, Long count, String exceptionInfo) {
        if (HussarUtils.isNotBlank((CharSequence)dataLocation)) {
            archiveRecordEntity.setDataLocation(dataLocation);
        }
        archiveRecordEntity.setArchiveEndTime(archiveEndTime);
        archiveRecordEntity.setArchiveStatus(archiveStatus.getCode());
        if (HussarUtils.isNotEmpty((Object)count)) {
            archiveRecordEntity.setArchiveDataCount(Integer.valueOf(Math.toIntExact(count)));
        } else {
            archiveRecordEntity.setArchiveDataCount(null);
        }
        if (HussarUtils.isNotEmpty((Object)exceptionInfo)) {
            archiveRecordEntity.setArchiveFailMsg(exceptionInfo);
        }
        this.archiveRecordService.updateById(archiveRecordEntity);
    }

    protected ApiResponse<Long> uploadZipFile(File zipFile) {
        ApiResponse apiResponse;
        FileInputStream inputStream = null;
        try {
            ApiResponse uploadResult;
            inputStream = new FileInputStream(zipFile);
            HussarBaseMultipartFile multipartFile = new HussarBaseMultipartFile(zipFile.getName(), zipFile.getName(), "application/octet-stream", (InputStream)inputStream);
            apiResponse = uploadResult = this.ossService.backgroundUpload((MultipartFile)multipartFile);
        }
        catch (Exception e) {
            try {
                throw new HussarException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IoUtil.closeQuietly((Closeable)inputStream);
        return apiResponse;
    }

    public void afterPropertiesSet() throws Exception {
        this.registryArchiveHandler();
    }

    protected void archiveColdData(ArchiveConfigVo archiveConfigVo, LocalDateTime minCreateTime, ArchiveExecType archiveExecType) {
        logger.debug("\u5f00\u59cb\u5f52\u6863\u51b7\u6570\u636e");
        if (HussarUtils.isEmpty((Object)minCreateTime)) {
            logger.debug("\u6570\u636e\u6700\u65e9\u521b\u5efa\u65f6\u95f4\u4e3a\u7a7a\uff0c\u65e0\u9700\u5f52\u6863\u51b7\u6570\u636e");
            return;
        }
        LocalDateTime coldArchiveTime = archiveConfigVo.getColdArchiveTime();
        if (minCreateTime.isAfter(coldArchiveTime)) {
            logger.debug("\u5ba1\u8ba1\u65e5\u5fd7\u6570\u636e\u6700\u65e9\u65e5\u671f\u665a\u4e8e\u51b7\u6570\u636e\u5f52\u6863\u5f00\u59cb\u65f6\u95f4\uff0c\u6700\u65e9\u521b\u5efa\u65f6\u95f4:{} \u51b7\u6570\u636e\u5f52\u6863\u5f00\u59cb\u65f6\u95f4:{}", (Object)minCreateTime, (Object)coldArchiveTime);
            return;
        }
        String sourceTableName = archiveConfigVo.getSourceTableName();
        List<YearMonth> yearMonthList = LocalDateTimeUtils.getYearMonthList(minCreateTime, coldArchiveTime);
        if (HussarUtils.isEmpty(yearMonthList)) {
            logger.debug("\u5f52\u6863\u51b7\u6570\u636e\uff0c\u51b7\u6570\u636e\u5f52\u6863\u6708\u4efd\u5217\u8868\u4e3a\u7a7a");
            return;
        }
        yearMonthList = yearMonthList.subList(0, yearMonthList.size() - 1);
        logger.debug("\u5f52\u6863\u51b7\u6570\u636e\uff0c\u5f52\u6863\u5f00\u59cb\u65f6\u95f4:{} \u51b7\u6570\u636e\u5f52\u6863\u7ed3\u675f\u65f6\u95f4:{}\uff0c\u6708\u4efd\u5217\u8868\uff1a{}", new Object[]{coldArchiveTime, minCreateTime, yearMonthList});
        List<ArchiveRecordEntity> recordEntities = this.handleArchiveRecords(archiveExecType, coldArchiveTime, yearMonthList, sourceTableName, ArchiveDataType.COLD_DATA);
        if (HussarUtils.isEmpty(recordEntities)) {
            logger.debug("\u5f52\u6863\u51b7\u6570\u636e\uff0c\u65e0\u5f52\u6863\u8bb0\u5f55");
            return;
        }
        for (ArchiveRecordEntity recordEntity : recordEntities) {
            this.hussarTaskExecutor.execute(() -> this.archiveColdDataByMonth(recordEntity));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ArchiveRecordEntity> handleArchiveRecords(ArchiveExecType archiveExecType, LocalDateTime archiveTime, List<YearMonth> yearMonthList, String sourceTableName, ArchiveDataType archiveDataType) {
        List existsRecordEntities;
        logger.debug("\u6279\u91cf\u4fdd\u5b58\u5f52\u6863\u8bb0\u5f55\uff0c\u83b7\u53d6\u5f52\u6863\u8bb0\u5f55\u9501");
        HussarLockGuard lockGuard = this.lock(sourceTableName, archiveDataType.getCode().toString());
        if (HussarUtils.isEmpty((Object)lockGuard)) {
            logger.debug("\u5f52\u6863\u8bb0\u5f55\u9501\u5df2\u5360\u7528");
            return Lists.newArrayListWithCapacity((int)0);
        }
        logger.debug("\u6279\u91cf\u4fdd\u5b58\u5f52\u6863\u8bb0\u5f55\uff0c\u83b7\u53d6\u5f52\u6863\u8bb0\u5f55\u9501\u6210\u529f");
        ArrayList recordEntities = Lists.newArrayListWithCapacity((int)yearMonthList.size());
        try {
            if (HussarUtils.isEmpty(yearMonthList)) {
                logger.debug("\u5f52\u6863\u6708\u4efd\u5217\u8868\u4e3a\u7a7a\uff0c\u8df3\u51fa\u5f52\u6863");
                ArrayList arrayList = Lists.newArrayListWithCapacity((int)0);
                return arrayList;
            }
            List startTimeList = yearMonthList.stream().map(yearMonth -> yearMonth.atDay(1).atStartOfDay()).collect(Collectors.toList());
            existsRecordEntities = this.archiveRecordService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ArchiveRecordEntity::getSourceTableName, (Object)sourceTableName)).in(ArchiveRecordEntity::getArchiveStartupTime, startTimeList));
            if (HussarUtils.isNotEmpty((Object)existsRecordEntities) && existsRecordEntities.size() == yearMonthList.size()) {
                logger.debug("\u83b7\u53d6\u5f52\u6863\u8bb0\u5f55\u6210\u529f");
                List list = existsRecordEntities;
                return list;
            }
            if (HussarUtils.isNotEmpty((Object)existsRecordEntities)) {
                List exitsYearMonthList = existsRecordEntities.stream().map(recordEntity -> YearMonth.from(recordEntity.getArchiveStartupTime())).collect(Collectors.toList());
                yearMonthList = yearMonthList.stream().filter(yearMonth -> !exitsYearMonthList.contains(yearMonth)).collect(Collectors.toList());
            }
            for (YearMonth yearMonth2 : yearMonthList) {
                LocalDateTime monthStartTime = yearMonth2.atDay(1).atStartOfDay();
                LocalDateTime monthEndTime = yearMonth2.atEndOfMonth().atTime(23, 59, 59);
                if (monthEndTime.isAfter(archiveTime)) {
                    monthEndTime = archiveTime;
                }
                ArchiveRecordEntity recordEntity2 = new ArchiveRecordEntity();
                recordEntity2.setArchiveRecordId(MpUtils.idCreator());
                recordEntity2.setSourceTableName(sourceTableName);
                recordEntity2.setArchiveType(archiveDataType.getCode());
                recordEntity2.setArchiveStatus(ArchiveStatus.ARCHIVING.getCode());
                recordEntity2.setArchiveExecType(archiveExecType.getCode());
                recordEntity2.setArchiveStartupTime(monthStartTime);
                recordEntity2.setArchiveEndTime(monthEndTime);
                recordEntities.add(recordEntity2);
            }
            this.archiveRecordService.saveBatch(recordEntities);
        }
        finally {
            logger.debug("\u91ca\u653e\u5f52\u6863\u8bb0\u5f55\u9501");
            lockGuard.releaseLock();
        }
        if (HussarUtils.isNotEmpty((Object)existsRecordEntities)) {
            recordEntities.addAll(existsRecordEntities);
        }
        return recordEntities;
    }

    private void archiveColdDataByMonth(ArchiveRecordEntity recordEntity) {
        logger.debug("\u5f00\u59cb\u6309\u6708\u5f52\u6863\u51b7\u6570\u636e");
        LocalDateTime startTime = recordEntity.getArchiveStartupTime();
        LocalDateTime endTime = recordEntity.getArchiveEndTime();
        logger.debug("\u6309\u6708\u5f52\u6863\u51b7\u6570\u636e\uff0c\u6839\u636e\u8d77\u59cb\u65f6\u95f4\u67e5\u8be2\u539f\u8868\u6570\u636e\u6570\u91cf\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)startTime, (Object)endTime);
        long count = this.getSourceDataCount(startTime, endTime);
        if (count == 0L) {
            logger.debug("\u8be5\u6708\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u5f00\u59cb\u65f6\u95f4:{}, \u7ed3\u675f\u65f6\u95f4:{}", (Object)startTime, (Object)endTime);
            this.updateArchiveRecord(recordEntity, null, endTime, ArchiveStatus.ARCHIVE_SUCCESS, ArchiveStatus.ARCHIVING.getCode().equals(recordEntity.getArchiveStatus()) ? Long.valueOf(count) : null, null);
            return;
        }
        String sourceTableName = recordEntity.getSourceTableName();
        logger.debug("\u6309\u6708\u5f52\u6863\u51b7\u6570\u636e\uff0c\u67e5\u8be2\u662f\u5426\u6709\u6062\u590d\u6210\u529f\u4e14\u672a\u8d85\u8fc7\u6570\u636e\u6682\u5b58\u65f6\u95f4\u7684\u6062\u590d\u8bb0\u5f55");
        long recoverCount = this.getArchiveRecoverCount(sourceTableName, startTime, endTime);
        if (recoverCount > 0L) {
            logger.debug("\u8be5\u6708\u6570\u636e\u5df2\u7ecf\u6062\u590d\u6210\u529f\u4e14\u7cfb\u7edf\u5f53\u524d\u65f6\u95f4\u672a\u8d85\u8fc7\u6570\u636e\u6682\u5b58\u65f6\u95f4\uff0c\u5f00\u59cb\u65f6\u95f4:{}, \u7ed3\u675f\u65f6\u95f4:{}", (Object)startTime, (Object)endTime);
            return;
        }
        Integer archiveType = recordEntity.getArchiveType();
        logger.debug("\u6309\u6708\u5f52\u6863\u51b7\u6570\u636e\uff0c\u4fee\u6539\u5f52\u6863\u8bb0\u5f55\u4e3a\u5f52\u6863\u4e2d");
        recordEntity.setArchiveStatus(ArchiveStatus.ARCHIVING.getCode());
        recordEntity.setArchiveType(ArchiveDataType.COLD_DATA.getCode());
        this.archiveRecordService.updateById(recordEntity);
        if (ArchiveDataType.WARM_DATA.getCode().equals(archiveType)) {
            this.archiveColdDataByMonth(count, ArchiveDataType.WARM_DATA, recordEntity);
            return;
        }
        this.archiveColdDataByMonth(count, ArchiveDataType.COLD_DATA, recordEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archiveColdDataByMonth(Long count, ArchiveDataType archiveDataType, ArchiveRecordEntity recordEntity) {
        logger.debug("\u6309\u6708\u5f52\u6863\u51b7\u6570\u636e\uff0c\u52a0\u5206\u5e03\u5f0f\u9501");
        LocalDateTime startTime = recordEntity.getArchiveStartupTime();
        LocalDateTime endTime = recordEntity.getArchiveEndTime();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMM");
        String tableNameSuffix = startTime.format(formatter);
        String sourceTableName = recordEntity.getSourceTableName();
        String tableNamePrefix = sourceTableName.replace("_SUPPORT", "");
        HussarLockGuard lockGuard = this.lock(sourceTableName, tableNameSuffix);
        if (HussarUtils.isEmpty((Object)lockGuard)) {
            logger.debug("\u83b7\u53d6\u51b7\u6570\u636e\u5f52\u6863\u9501\u5931\u8d25");
            return;
        }
        logger.debug("\u6309\u6708\u5f52\u6863\u51b7\u6570\u636e\uff0c\u4fdd\u5b58\u5f52\u6863\u8bb0\u5f55");
        File archiveFile = null;
        File zipFile = null;
        try {
            logger.debug("\u6309\u6708\u5f52\u6863\u51b7\u6570\u636e\uff0c\u521b\u5efa\u5f52\u6863\u6587\u4ef6");
            String tmpDir = FileUtil.getTempDirPath();
            archiveFile = new File(tmpDir + File.separator + sourceTableName + "_" + tableNameSuffix + ".txt");
            if (!archiveFile.exists()) {
                archiveFile.createNewFile();
            }
            int days = LocalDateTimeUtils.getDaysOfMonth(startTime);
            for (int i = 1; i <= days; ++i) {
                LocalDateTime dayStartTime = LocalDateTime.of(startTime.getYear(), startTime.getMonth(), i, 0, 0);
                LocalDateTime dayEndTime = LocalDateTime.of(startTime.getYear(), startTime.getMonth(), i, 23, 59, 59);
                if (dayEndTime.isAfter(endTime)) {
                    dayEndTime = endTime;
                }
                this.archiveColdDataByDay(tableNamePrefix, tableNameSuffix, archiveFile, archiveDataType, dayStartTime, dayEndTime);
            }
            logger.debug("\u6309\u6708\u5f52\u6863\u51b7\u6570\u636e\uff0c\u4e0a\u4f20\u5f52\u6863\u6587\u4ef6");
            zipFile = ZipUtil.zip((File)archiveFile);
            ApiResponse<Long> uploadResult = this.uploadZipFile(zipFile);
            if (archiveDataType == ArchiveDataType.COLD_DATA) {
                logger.debug("\u6309\u6708\u5f52\u6863\u51b7\u6570\u636e\uff0c\u5220\u9664\u539f\u8868\u6570\u636e");
                this.removeSourceData(startTime, endTime);
            }
            if (archiveDataType == ArchiveDataType.WARM_DATA) {
                logger.debug("\u6309\u6708\u5f52\u6863\u51b7\u6570\u636e\uff0c\u5220\u9664\u5f52\u6863\u8868\u6570\u636e");
                this.removeArchiveDataWithRetry(tableNamePrefix, tableNameSuffix, startTime, endTime);
                logger.debug("\u6309\u6708\u5f52\u6863\u51b7\u6570\u636e\uff0c\u5220\u9664\u8d85\u671f\u5f52\u6863\u8bb0\u5f55");
                this.archiveRecordService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ArchiveRecordEntity::getSourceTableName, (Object)sourceTableName)).eq(ArchiveRecordEntity::getArchiveType, (Object)archiveDataType.getCode())).eq(ArchiveRecordEntity::getArchiveStatus, (Object)ArchiveStatus.ARCHIVE_SUCCESS.getCode())).eq(ArchiveRecordEntity::getArchiveStartupTime, (Object)startTime)).eq(ArchiveRecordEntity::getArchiveEndTime, (Object)endTime));
            }
            logger.debug("\u6309\u6708\u5f52\u6863\u51b7\u6570\u636e\uff0c\u66f4\u65b0\u5f52\u6863\u8868\u72b6\u6001\u4e3a\u6210\u529f");
            this.updateArchiveRecord(recordEntity, ((Long)uploadResult.getData()).toString(), endTime, ArchiveStatus.ARCHIVE_SUCCESS, count, null);
        }
        catch (Exception e) {
            try {
                logger.error("\u5ba1\u8ba1\u65e5\u5fd7\u6570\u636e\u5f52\u6863\u5931\u8d25\uff0c\u5f52\u6863\u8bb0\u5f55ID\uff1a{}", (Object)recordEntity.getArchiveRecordId(), (Object)e);
                String exceptionInfo = String.format("\u51b7\u6570\u636e\u5f52\u6863\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s", e.getMessage());
                this.updateArchiveRecord(recordEntity, null, endTime, ArchiveStatus.ARCHIVE_FAIL, null, exceptionInfo);
            }
            catch (Throwable throwable) {
                logger.debug("\u6309\u6708\u5f52\u6863\u51b7\u6570\u636e\uff0c\u91ca\u653e\u5206\u5e03\u5f0f\u9501");
                lockGuard.releaseLock();
                FileUtil.deleteQuietly(archiveFile);
                FileUtil.deleteQuietly(zipFile);
                throw throwable;
            }
            logger.debug("\u6309\u6708\u5f52\u6863\u51b7\u6570\u636e\uff0c\u91ca\u653e\u5206\u5e03\u5f0f\u9501");
            lockGuard.releaseLock();
            FileUtil.deleteQuietly((File)archiveFile);
            FileUtil.deleteQuietly(zipFile);
        }
        logger.debug("\u6309\u6708\u5f52\u6863\u51b7\u6570\u636e\uff0c\u91ca\u653e\u5206\u5e03\u5f0f\u9501");
        lockGuard.releaseLock();
        FileUtil.deleteQuietly((File)archiveFile);
        FileUtil.deleteQuietly((File)zipFile);
    }

    protected abstract void archiveColdDataByDay(String var1, String var2, File var3, ArchiveDataType var4, LocalDateTime var5, LocalDateTime var6);

    protected void archiveWarmData(ArchiveConfigVo archiveConfigVo, LocalDateTime minCreateTime, ArchiveExecType archiveExecType) {
        logger.debug("\u5f00\u59cb\u5f52\u6863\u6e29\u6570\u636e");
        LocalDateTime warmArchiveTime = archiveConfigVo.getWarmArchiveTime();
        if (HussarUtils.isNotEmpty((Object)minCreateTime) && minCreateTime.isAfter(warmArchiveTime)) {
            logger.debug("\u5ba1\u8ba1\u65e5\u5fd7\u6570\u636e\u6700\u65e9\u65e5\u671f\u665a\u4e8e\u6e29\u6570\u636e\u5f52\u6863\u5f00\u59cb\u65f6\u95f4\uff0c\u6700\u65e9\u521b\u5efa\u65f6\u95f4:{} \u6e29\u6570\u636e\u5f52\u6863\u5f00\u59cb\u65f6\u95f4:{}", (Object)minCreateTime, (Object)warmArchiveTime);
            return;
        }
        logger.debug("\u5f52\u6863\u6e29\u6570\u636e\uff0c\u5224\u65ad\u6700\u65e9\u521b\u5efa\u65f6\u95f4\u662f\u5426\u665a\u4e8e\u51b7\u6570\u636e\u5f52\u6863\u5f00\u59cb\u65f6\u95f4");
        LocalDateTime coldArchiveTime = archiveConfigVo.getColdArchiveTime();
        if (HussarUtils.isNotEmpty((Object)minCreateTime) && minCreateTime.isAfter(coldArchiveTime)) {
            coldArchiveTime = minCreateTime;
        }
        List<YearMonth> yearMonthList = LocalDateTimeUtils.getYearMonthList(coldArchiveTime, warmArchiveTime);
        logger.debug("\u5f52\u6863\u6e29\u6570\u636e\uff0c\u6e29\u6570\u636e\u5f52\u6863\u5f00\u59cb\u65f6\u95f4:{}\uff0c\u51b7\u6570\u636e\u5f52\u6863\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u5e74\u6708\u5217\u8868\uff1a{}", new Object[]{warmArchiveTime, coldArchiveTime, yearMonthList});
        List<ArchiveRecordEntity> recordEntities = this.handleArchiveRecords(archiveExecType, warmArchiveTime, yearMonthList, archiveConfigVo.getSourceTableName(), ArchiveDataType.WARM_DATA);
        if (HussarUtils.isEmpty(recordEntities)) {
            logger.debug("\u5f52\u6863\u6e29\u6570\u636e\uff0c\u65e0\u5f52\u6863\u8bb0\u5f55\uff0c\u5f52\u6863\u7ed3\u675f");
            return;
        }
        for (ArchiveRecordEntity recordEntity : recordEntities) {
            this.hussarTaskExecutor.execute(() -> this.archiveWarmDataByMonth(recordEntity, warmArchiveTime));
        }
    }

    private void archiveWarmDataByMonth(ArchiveRecordEntity recordEntity, LocalDateTime archiveTime) {
        logger.debug("\u5f00\u59cb\u6309\u6708\u5f52\u6863\u6e29\u6570\u636e");
        LocalDateTime startTime = recordEntity.getArchiveStartupTime();
        LocalDateTime endTime = recordEntity.getArchiveEndTime();
        YearMonth currentMonth = YearMonth.from(archiveTime);
        YearMonth dataMonth = YearMonth.from(startTime);
        LocalDateTime archiveEndTime = currentMonth.equals(dataMonth) ? archiveTime : endTime;
        logger.debug("\u6309\u6708\u5f52\u6863\u6e29\u6570\u636e\uff0c\u67e5\u8be2\u539f\u8868\u6570\u636e\uff0c\u5f52\u6863\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u5f52\u6863\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)startTime, (Object)archiveEndTime);
        long count = this.getSourceDataCount(startTime, archiveEndTime);
        if (count == 0L) {
            logger.debug("\u5ba1\u8ba1\u65e5\u5fd7\u6570\u636e\u65e0\u6b64\u6708\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a{} \u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)startTime, (Object)archiveEndTime);
            this.updateArchiveRecord(recordEntity, null, endTime, ArchiveStatus.ARCHIVE_SUCCESS, ArchiveStatus.ARCHIVING.getCode().equals(recordEntity.getArchiveStatus()) ? Long.valueOf(count) : null, null);
            return;
        }
        String sourceTableName = recordEntity.getSourceTableName();
        if (currentMonth.equals(dataMonth)) {
            logger.debug("\u6309\u6708\u5f52\u6863\u6e29\u6570\u636e\uff0c\u5224\u65ad\u662f\u5426\u5df2\u7ecf\u6062\u590d\u4e14\u7cfb\u7edf\u5f53\u524d\u65f6\u95f4\u5c0f\u4e8e\u6570\u636e\u6682\u5b58\u65f6\u95f4");
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ArchiveRecoverEntity::getSourceTableName, (Object)sourceTableName)).eq(ArchiveRecoverEntity::getRecoverStatus, (Object)ArchiveRecoverStatus.RECOVER_SUCCESS.getCode())).eq(ArchiveRecoverEntity::getRecoverStartupTime, (Object)startTime)).le(ArchiveRecoverEntity::getRecoverEndTime, (Object)archiveTime)).gt(ArchiveRecoverEntity::getDataStorageTime, (Object)LocalDateTime.now());
            long recoverCount = this.archiveRecoverService.count((Wrapper)queryWrapper);
            if (recoverCount > 0L && ArchiveStatus.ARCHIVE_SUCCESS.getCode().equals(recordEntity.getArchiveStatus())) {
                logger.debug("\u6309\u6708\u5f52\u6863\u6e29\u6570\u636e\uff0c\u589e\u91cf\u66f4\u65b0\u5f52\u6863\u6e29\u6570\u636e\uff0c\u5f52\u6863\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)archiveTime);
                this.updateArchiveRecord(recordEntity, null, endTime, ArchiveStatus.ARCHIVING, count, null);
                this.archiveWarmDataByMonth(recordEntity, archiveTime, true);
                return;
            }
            queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ArchiveRecoverEntity::getSourceTableName, (Object)sourceTableName)).eq(ArchiveRecoverEntity::getRecoverStatus, (Object)ArchiveRecoverStatus.RECOVER_SUCCESS.getCode())).eq(ArchiveRecoverEntity::getRecoverStartupTime, (Object)startTime);
            recoverCount = this.archiveRecoverService.count((Wrapper)queryWrapper);
            if (recoverCount == 0L && ArchiveStatus.ARCHIVE_SUCCESS.getCode().equals(recordEntity.getArchiveStatus())) {
                logger.debug("\u6309\u6708\u5f52\u6863\u6e29\u6570\u636e\uff0c\u589e\u91cf\u66f4\u65b0\u5f52\u6863\u6e29\u6570\u636e\uff0c\u5f52\u6863\u65f6\u95f4\uff1a{}", (Object)archiveTime);
                this.updateArchiveRecord(recordEntity, null, endTime, ArchiveStatus.ARCHIVING, count, null);
                this.archiveWarmDataByMonth(recordEntity, archiveTime, true);
                return;
            }
        } else {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ArchiveRecoverEntity::getSourceTableName, (Object)sourceTableName)).eq(ArchiveRecoverEntity::getRecoverStatus, (Object)ArchiveRecoverStatus.RECOVER_SUCCESS.getCode())).eq(ArchiveRecoverEntity::getRecoverStartupTime, (Object)startTime)).eq(ArchiveRecoverEntity::getRecoverEndTime, (Object)endTime)).gt(ArchiveRecoverEntity::getDataStorageTime, (Object)LocalDateTime.now());
            long recoverCount = this.archiveRecoverService.count((Wrapper)queryWrapper);
            if (recoverCount > 0L) {
                logger.debug("\u6309\u6708\u5f52\u6863\u6e29\u6570\u636e\uff0c\u8be5\u6708\u6570\u636e\u5df2\u7ecf\u6062\u590d\u4e14\u5728\u4fdd\u62a4\u671f\u5185\uff0c\u6682\u65f6\u65e0\u6cd5\u5f52\u6863");
                this.updateArchiveRecord(recordEntity, null, endTime, ArchiveStatus.ARCHIVE_SUCCESS, null, null);
                return;
            }
        }
        this.updateArchiveRecord(recordEntity, null, endTime, ArchiveStatus.ARCHIVING, count, null);
        this.archiveWarmDataByMonth(recordEntity, archiveTime, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archiveWarmDataByMonth(ArchiveRecordEntity recordEntity, LocalDateTime warmArchiveTime, boolean isIncrement) {
        String sourceTableName = recordEntity.getSourceTableName();
        logger.debug("\u6309\u6708\u5f52\u6863\u6e29\u6570\u636e\uff0c\u52a0\u5206\u5e03\u5f0f\u9501");
        LocalDateTime startTime = recordEntity.getArchiveStartupTime();
        LocalDateTime endTime = recordEntity.getArchiveEndTime();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMM");
        String tableNameSuffix = startTime.format(formatter);
        HussarLockGuard lockGuard = this.lock(sourceTableName, tableNameSuffix);
        if (HussarUtils.isEmpty((Object)lockGuard)) {
            logger.debug("\u83b7\u53d6\u5f52\u6863\u9501\u5931\u8d25");
            return;
        }
        try {
            String tableNamePrefix = sourceTableName.replace("_SUPPORT", "");
            String newTableName = tableNamePrefix + "_" + tableNameSuffix;
            logger.debug("\u6309\u6708\u5f52\u6863\u6e29\u6570\u636e\uff0c\u521b\u5efa\u5f52\u6863\u8868\uff0c\u8868\u540d:{}", (Object)newTableName);
            boolean tableExist = this.createArchiveTable(newTableName, sourceTableName);
            int startDays = 1;
            LocalDateTime incStartTime = null;
            if (isIncrement) {
                startDays = endTime.getDayOfMonth();
                incStartTime = endTime;
                endTime = warmArchiveTime;
            }
            int days = endTime.getDayOfMonth();
            ThreadPoolTaskExecutor taskExecutor = this.buildTaskExecutor();
            ArrayList futures = Lists.newArrayListWithCapacity((int)days);
            logger.debug("\u6309\u6708\u5f52\u6863\u6e29\u6570\u636e\uff0c\u8d77\u59cb\u5929\uff1a{}\uff0c\u603b\u5929\u6570\uff1a{}", (Object)1, (Object)days);
            for (int i = startDays; i <= days; ++i) {
                LocalDateTime dayStartTime = HussarUtils.isNotEmpty((Object)incStartTime) ? incStartTime : LocalDateTime.of(startTime.getYear(), startTime.getMonth(), i, 0, 0, 0);
                LocalDateTime dayEndTime = LocalDateTime.of(startTime.getYear(), startTime.getMonth(), i, 23, 59, 59);
                if (dayEndTime.isAfter(endTime)) {
                    dayEndTime = endTime;
                }
                LocalDateTime finalDayStartTime = dayStartTime;
                LocalDateTime finalDayEndTime = dayEndTime;
                Future future = taskExecutor.submit(() -> this.archiveWarmDataByDay(tableNamePrefix, tableNameSuffix, finalDayStartTime, finalDayEndTime, tableExist, warmArchiveTime));
                futures.add(future);
            }
            for (Future future1 : futures) {
                future1.get();
            }
            logger.debug("\u6309\u6708\u5f52\u6863\u6e29\u6570\u636e\uff0c\u6700\u7ec8\u5f52\u6863\u6761\u6570\u9700\u8981\u67e5\u8be2\u5f52\u6863\u8868\u8fdb\u884c\u786e\u5b9a");
            long count = this.getArchiveDataCount(tableNamePrefix, tableNameSuffix, startTime, endTime);
            logger.debug("\u6309\u6708\u5f52\u6863\u6e29\u6570\u636e\uff0c\u5f52\u6863\u6210\u529f\uff0c\u5f52\u6863\u8bb0\u5f55ID\uff1a{}\uff0c\u5f52\u6863\u6570\u636e\u884c\u6570\uff1a{}", (Object)recordEntity.getArchiveRecordId(), (Object)count);
            logger.debug("\u6309\u6708\u5f52\u6863\u6e29\u6570\u636e\uff0c\u5220\u9664\u539f\u6570\u636e\u8868\u6570\u636e");
            this.removeSourceData(isIncrement ? incStartTime : startTime, endTime);
            logger.debug("\u6309\u6708\u5f52\u6863\u6e29\u6570\u636e\uff0c\u66f4\u65b0\u5f52\u6863\u8bb0\u5f55");
            this.updateArchiveRecord(recordEntity, newTableName, endTime, ArchiveStatus.ARCHIVE_SUCCESS, count, null);
        }
        catch (Exception e) {
            logger.error("\u5ba1\u8ba1\u65e5\u5fd7\u6570\u636e\u5f52\u6863\u5931\u8d25\uff0c\u5f52\u6863\u8bb0\u5f55ID\uff1a{}", (Object)recordEntity.getArchiveRecordId(), (Object)e);
            String exceptionInfo = String.format("\u6e29\u6570\u636e\u5f52\u6863\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s", e.getMessage());
            this.updateArchiveRecord(recordEntity, null, endTime, ArchiveStatus.ARCHIVE_FAIL, null, exceptionInfo);
        }
        finally {
            logger.debug("\u6309\u6708\u5f52\u6863\u6e29\u6570\u636e\uff0c\u91ca\u653e\u5206\u5e03\u5f0f\u9501");
            lockGuard.releaseLock();
        }
    }

    protected long archiveWarmDataByDay(String tableNamePrefix, String tableNameSuffix, LocalDateTime dayStartTime, LocalDateTime dayEndTime, Boolean tableExist, LocalDateTime warmArchiveTime) {
        logger.debug("\u6309\u5929\u5f52\u6863\u6e29\u6570\u636e\uff0c\u5f00\u59cb\u67e5\u8be2\u539f\u8868\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)dayStartTime, (Object)dayEndTime);
        long dayCount = this.getSourceDataCount(dayStartTime, dayEndTime);
        if (dayCount == 0L) {
            logger.debug("\u6309\u5929\u5f52\u6863\u6e29\u6570\u636e\uff0c\u672a\u67e5\u8be2\u5230\u6e29\u6570\u636e");
            return 0L;
        }
        YearMonth currentMonth = YearMonth.from(warmArchiveTime);
        YearMonth dataMonth = YearMonth.from(dayStartTime);
        if (Boolean.TRUE.equals(tableExist) && !currentMonth.equals(dataMonth)) {
            logger.debug("\u6309\u5929\u5f52\u6863\u6e29\u6570\u636e\uff0c\u5220\u9664\u5f52\u6863\u8868\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)dayStartTime, (Object)dayEndTime);
            this.removeArchiveDataWithRetry(tableNamePrefix, tableNameSuffix, dayStartTime, dayEndTime);
        }
        long pageSize = 500L;
        long pageCount = dayCount / pageSize + (long)(dayCount % pageSize == 0L ? 0 : 1);
        logger.debug("\u6309\u5929\u5f52\u6863\u6e29\u6570\u636e\uff0c\u5206\u9875\u5f52\u6863\u6570\u636e\uff0c\u5206\u4e3a{}\u9875\uff0c\u6bcf\u9875{}\u6761", (Object)pageCount, (Object)pageSize);
        long count = 0L;
        int i = 1;
        while ((long)i <= pageCount) {
            count += (long)this.archiveWarmDataByPage(tableNamePrefix, tableNameSuffix, dayStartTime, dayEndTime, i);
            ++i;
        }
        logger.debug("\u6309\u5929\u5f52\u6863\u6e29\u6570\u636e\uff0c\u5f52\u6863\u5b8c\u6210\uff0c\u5f52\u6863\u6570\u636e\u884c\u6570\uff1a{}", (Object)count);
        return count;
    }

    private void removeArchiveDataWithRetry(String tableNamePrefix, String tableNameSuffix, LocalDateTime startTime, LocalDateTime endTime) {
        int maxRetries = 3;
        for (int retryCount = 0; retryCount < maxRetries; ++retryCount) {
            try {
                this.removeArchiveData(tableNamePrefix, tableNameSuffix, startTime, endTime);
                break;
            }
            catch (Exception e) {
                if (e.getMessage().contains("Deadlock") && retryCount < maxRetries - 1) {
                    try {
                        Thread.sleep((long)(Math.random() * 100.0) + 50L);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException("\u7ebf\u7a0b\u88ab\u4e2d\u65ad", ie);
                    }
                }
                throw e;
            }
        }
    }

    protected abstract void removeArchiveData(String var1, String var2, LocalDateTime var3, LocalDateTime var4);

    protected abstract int archiveWarmDataByPage(String var1, String var2, LocalDateTime var3, LocalDateTime var4, Integer var5);

    private Boolean createArchiveTable(String newTableName, String originTableName) {
        Boolean tableExist = this.archiveCreateTableService.checkTableExist(newTableName, originTableName);
        if (Boolean.FALSE.equals(tableExist)) {
            this.archiveCreateTableService.createTable(newTableName, originTableName);
        }
        return tableExist;
    }

    private ThreadPoolTaskExecutor buildTaskExecutor() {
        int cpuCores = Runtime.getRuntime().availableProcessors();
        String key = RejectedExecutionHandlerEnum.Abort.getKey();
        logger.debug("\u521b\u5efa\u7ebf\u7a0b\u6c60\uff0c\u6838\u5fc3\u7ebf\u7a0b\u6570\uff1a{}\uff0c\u6700\u5927\u7ebf\u7a0b\u6570\uff1a{}\uff0c\u961f\u5217\u5927\u5c0f\uff1a{}\uff0c\u62d2\u7edd\u7b56\u7565\uff1a{}", new Object[]{cpuCores, cpuCores * 4, 1024, key});
        return this.hussarTaskExecutor.createThreadPoolTaskExecutor(cpuCores, cpuCores * 4, 1024, RejectedExecutionHandlerEnum.instantiationHandler((String)key));
    }
}

