/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.factory;

import com.jxdinfo.hussar.support.audit.core.archive.handler.ArchiveHandler;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class ArchiveHandlerFactory {
    private static final Map<String, ArchiveHandler> ARCHIVE_HANDLER_MAP = new ConcurrentHashMap<String, ArchiveHandler>(8);

    public static void registry(String key, ArchiveHandler archiveHandler) {
        ARCHIVE_HANDLER_MAP.put(key, archiveHandler);
    }

    public static ArchiveHandler getArchiveHandler(String key) {
        return ARCHIVE_HANDLER_MAP.get(key);
    }

    public static Collection<ArchiveHandler> getAll() {
        return ARCHIVE_HANDLER_MAP.values();
    }
}

