/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.archive.service.ArchiveRecordService;
import com.jxdinfo.hussar.support.audit.core.archive.vo.ArchiveRecordParam;
import com.jxdinfo.hussar.support.audit.core.archive.vo.ArchiveRecordVo;
import com.jxdinfo.hussar.support.audit.core.archive.vo.ArchiveRecoverVo;
import com.jxdinfo.hussar.support.audit.core.config.AuditLogArchiveProperties;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.exception.HussarException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/archiveRecord"})
@Api(tags={"\u5f52\u6863\u8bb0\u5f55"})
public class ArchiveRecordFrontController {
    @Autowired
    private ArchiveRecordService archiveRecordService;
    @Autowired
    private AuditLogArchiveProperties auditLogArchiveProperties;

    @GetMapping(value={"/page"})
    @AuditLog(moduleName="\u5f52\u6863\u8bb0\u5f55", eventDesc="\u67e5\u8be2\u5f52\u6863\u8bb0\u5f55\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperation(value="\u67e5\u8be2\u5f52\u6863\u8bb0\u5f55\u5217\u8868", notes="\u67e5\u8be2\u5f52\u6863\u8bb0\u5f55\u5217\u8868", httpMethod="GET")
    public ApiResponse<IPage<ArchiveRecordVo>> getArchiveRecordPageList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page<ArchiveRecordVo> page, @ApiParam(value="\u5f52\u6863\u8bb0\u5f55\u53c2\u6570") ArchiveRecordParam archiveRecordParam) {
        if (!this.auditLogArchiveProperties.getEnable()) {
            throw new HussarException("\u5ba1\u8ba1\u65e5\u5fd7\u5f52\u6863\u672a\u5f00\u542f");
        }
        return ApiResponse.success((Object)this.archiveRecordService.selectPage(page, archiveRecordParam));
    }

    @GetMapping(value={"/archive"})
    @AuditLog(moduleName="\u5f52\u6863\u8bb0\u5f55", eventDesc="\u5f52\u6863\u6570\u636e", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.NULL_EVENT_TYPE)
    @ApiOperation(value="\u5f52\u6863\u6570\u636e", notes="\u5f52\u6863\u6570\u636e", httpMethod="GET")
    public ApiResponse<Boolean> archive(@RequestParam(value="archiveRecordId") @ApiParam(value="\u5f52\u6863\u8bb0\u5f55ID") Long archiveRecordId) {
        if (!this.auditLogArchiveProperties.getEnable()) {
            throw new HussarException("\u5ba1\u8ba1\u65e5\u5fd7\u5f52\u6863\u672a\u5f00\u542f");
        }
        return ApiResponse.success((Object)this.archiveRecordService.archive(archiveRecordId));
    }

    @GetMapping(value={"/recover"})
    @AuditLog(moduleName="\u5f52\u6863\u8bb0\u5f55", eventDesc="\u6062\u590d\u6570\u636e", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.NULL_EVENT_TYPE)
    @ApiOperation(value="\u6062\u590d\u6570\u636e", notes="\u6062\u590d\u6570\u636e", httpMethod="GET")
    public ApiResponse<Boolean> recover(@RequestParam(value="id") @ApiParam(value="\u5f52\u6863\u8bb0\u5f55ID") Long id, @RequestParam(value="dataStorageTime") @ApiParam(value="\u6570\u636e\u6682\u5b58\u65f6\u95f4") LocalDate dataStorageTime) {
        if (!this.auditLogArchiveProperties.getEnable()) {
            throw new HussarException("\u5ba1\u8ba1\u65e5\u5fd7\u5f52\u6863\u672a\u5f00\u542f");
        }
        LocalDateTime fullStorageTime = dataStorageTime.atTime(23, 59, 59);
        ArchiveRecoverVo recoverVo = new ArchiveRecoverVo();
        recoverVo.setArchiveRecordId(id);
        recoverVo.setDataStorageTime(fullStorageTime);
        return ApiResponse.success((Object)this.archiveRecordService.recover(recoverVo));
    }
}

