/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.report.dashboard.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.dataset.model.WordDataSetInfo;
import com.jxdinfo.hussar.dataset.vo.WordDataSetGroupAllVo;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.report.dashboard.emnus.DataSetTypeEnum;
import com.jxdinfo.hussar.report.dashboard.emnus.DataType;
import com.jxdinfo.hussar.report.dto.DashAppTreeDto;
import com.jxdinfo.hussar.report.dto.DashFormDto;
import com.jxdinfo.hussar.report.dto.DashFormGroupDto;
import dm.jdbc.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataSetToSysFormUtil {
    public static Map<String, Object> dataSetToSysFormAndField(WordDataSetInfo wordDataSetInfo) {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        List<Object> list = new ArrayList();
        DashFormDto sysForm = DataSetToSysFormUtil.dataSetToSysForm(wordDataSetInfo);
        list = DataSetToSysFormUtil.dataSetToField(wordDataSetInfo);
        resMap.put("info", sysForm);
        resMap.put("list", list);
        return resMap;
    }

    public static List<DashAppTreeDto> dataSetToAppTree(List<WordDataSetGroupAllVo> wordDataSetGroupAllVoList) {
        ArrayList<DashAppTreeDto> list = new ArrayList<DashAppTreeDto>();
        DashAppTreeDto appTreeExtendVo = new DashAppTreeDto();
        ArrayList<DashFormDto> noGroupList = new ArrayList<DashFormDto>();
        ArrayList<DashFormGroupDto> sysFormGroupVos = new ArrayList<DashFormGroupDto>();
        for (WordDataSetGroupAllVo wordDataSetGroupAllVo : wordDataSetGroupAllVoList) {
            if (HussarUtils.equals((Object)wordDataSetGroupAllVo.getGroupId(), (Object)1)) {
                List dataSetInfoDtos = wordDataSetGroupAllVo.getDataSetInfoDtos();
                for (WordDataSetInfo wordDataSetInfo : dataSetInfoDtos) {
                    DashFormDto sysFormDataVo = DataSetToSysFormUtil.dataSetToSysForm(wordDataSetInfo);
                    noGroupList.add(sysFormDataVo);
                }
                continue;
            }
            DashFormGroupDto sysFormGroupVo = new DashFormGroupDto();
            sysFormGroupVo.setId(wordDataSetGroupAllVo.getGroupId());
            sysFormGroupVo.setGroupName(wordDataSetGroupAllVo.getGroupName());
            sysFormGroupVo.setGroupType(wordDataSetGroupAllVo.getGroupType());
            sysFormGroupVo.setGroupIconType(wordDataSetGroupAllVo.getGroupIconType());
            sysFormGroupVo.setGroupIcon(wordDataSetGroupAllVo.getGroupIcon());
            sysFormGroupVo.setGroupIconColor(wordDataSetGroupAllVo.getGroupIconColor());
            sysFormGroupVo.setSeq(Integer.valueOf(wordDataSetGroupAllVo.getSeq()));
            sysFormGroupVo.setCreator(wordDataSetGroupAllVo.getCreator());
            sysFormGroupVo.setLastEditor(wordDataSetGroupAllVo.getLastEditor());
            sysFormGroupVo.setCreateTime(wordDataSetGroupAllVo.getCreateTime());
            sysFormGroupVo.setLastTime(wordDataSetGroupAllVo.getLastTime());
            ArrayList<DashFormDto> sysFormDataVos = new ArrayList<DashFormDto>();
            List dataSetInfoDtos = wordDataSetGroupAllVo.getDataSetInfoDtos();
            for (WordDataSetInfo wordDataSetInfo : dataSetInfoDtos) {
                DashFormDto sysFormDataVo = DataSetToSysFormUtil.dataSetToSysForm(wordDataSetInfo);
                sysFormDataVos.add(sysFormDataVo);
            }
            sysFormGroupVo.setSysFormList(sysFormDataVos);
            sysFormGroupVos.add(sysFormGroupVo);
        }
        appTreeExtendVo.setNoGroupList(noGroupList);
        appTreeExtendVo.setSysFormGroupVos(sysFormGroupVos);
        list.add(appTreeExtendVo);
        return list;
    }

    public static DashFormDto dataSetToSysForm(WordDataSetInfo wordDataSetInfo) {
        DashFormDto sysForm = new DashFormDto();
        sysForm.setFormName(wordDataSetInfo.getDataSetName());
        sysForm.setFormGroupId(wordDataSetInfo.getGroupId());
        sysForm.setTableName(wordDataSetInfo.getDataSetName());
        sysForm.setCreator(wordDataSetInfo.getCreator());
        sysForm.setLastEditor(wordDataSetInfo.getLastEditor());
        sysForm.setCreateTime(wordDataSetInfo.getCreateTime());
        sysForm.setLastTime(wordDataSetInfo.getLastTime());
        sysForm.setDesignType("dataSet");
        sysForm.setFormType(wordDataSetInfo.getDataSetType());
        sysForm.setId(wordDataSetInfo.getDataSetId());
        return sysForm;
    }

    public static List<WidgetField> dataSetToField(WordDataSetInfo wordDataSetInfo) {
        List<WidgetField> list = new ArrayList<WidgetField>();
        if (HussarUtils.isNotEmpty((Object)wordDataSetInfo.getData())) {
            String type = wordDataSetInfo.getDataSetType();
            list = HussarUtils.equals((Object)DataSetTypeEnum.DB.getCode(), (Object)type) || HussarUtils.equals((Object)DataSetTypeEnum.SQL.getCode(), (Object)type) ? DataSetToSysFormUtil.dataSetToSqlField(wordDataSetInfo) : DataSetToSysFormUtil.dataSetToApiField(wordDataSetInfo);
        }
        return list;
    }

    public static List<WidgetField> dataSetToApiField(WordDataSetInfo wordDataSetInfo) {
        List<WidgetField> list;
        block12: {
            list = new ArrayList<WidgetField>();
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                JSONObject jsonObject = JSON.parseObject((String)wordDataSetInfo.getData());
                JSONObject operations = (JSONObject)jsonObject.getJSONArray("operations").get(0);
                if (operations == null) break block12;
                JSONObject returnValue = operations.getJSONObject("returnValue");
                JSONArray properties = returnValue.getJSONArray("properties");
                String dataSetName = wordDataSetInfo.getDataSetName();
                JSONArray propertiesList = new JSONArray();
                if (properties != null) {
                    for (int i = 0; i < properties.size(); ++i) {
                        JSONObject fieldObj = properties.getJSONObject(i);
                        String type = fieldObj.getString("dataType");
                        if (!HussarUtils.equals((Object)"array", (Object)type) || !HussarUtils.equals((Object)DataSetTypeEnum.API.getCode(), (Object)wordDataSetInfo.getDataSetType())) continue;
                        properties = fieldObj.getJSONArray("properties");
                        break;
                    }
                }
                if (HussarUtils.equals((Object)DataSetTypeEnum.API.getCode(), (Object)wordDataSetInfo.getDataSetType())) {
                    JSONArray body = operations.getJSONArray("body");
                    if (HussarUtils.isNotEmpty((Object)body)) {
                        for (int i = 0; i < body.size(); ++i) {
                            JSONObject fieldObj = body.getJSONObject(i);
                            String type = fieldObj.getString("dataType");
                            if (HussarUtils.equals((Object)"array", (Object)type)) {
                                properties.add((Object)fieldObj.getJSONArray("properties"));
                                break;
                            }
                            properties.add((Object)fieldObj);
                        }
                    } else {
                        JSONArray query = operations.getJSONArray("query");
                        if (HussarUtils.isNotEmpty((Object)query)) {
                            for (int i = 0; i < query.size(); ++i) {
                                JSONObject fieldObj = query.getJSONObject(i);
                                String type = fieldObj.getString("dataType");
                                if (HussarUtils.equals((Object)"array", (Object)type)) {
                                    properties = fieldObj.getJSONArray("properties");
                                    break;
                                }
                                properties.add((Object)fieldObj);
                            }
                        }
                    }
                }
                list = DataSetToSysFormUtil.returnValueToWidgetField(properties, dataSetName, wordDataSetInfo.getDataSetType());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static List<WidgetField> returnValueToWidgetField(JSONArray properties, String dataSetName, String datasetType) {
        ArrayList<WidgetField> list = new ArrayList<WidgetField>();
        if (properties != null) {
            for (int i = 0; i < properties.size(); ++i) {
                JSONObject fieldObj = properties.getJSONObject(i);
                WidgetField field = new WidgetField();
                String id = fieldObj.getString("id");
                String name = fieldObj.getString("name");
                String type = fieldObj.getString("type");
                String dataType = fieldObj.getString("dataType");
                String comment = fieldObj.getString("comment");
                JSONArray propertiesList = fieldObj.getJSONArray("properties");
                if (StringUtil.isEmpty((String)id)) {
                    id = name;
                }
                field.setFieldId(id);
                if (HussarUtils.equals((Object)DataSetTypeEnum.API.getCode(), (Object)datasetType)) {
                    field.setName(name);
                } else {
                    field.setName(id);
                }
                field.setType(DataType.getIconByValue(dataType));
                field.setTitle(comment);
                field.setUsage(null);
                field.setIsRealField(true);
                field.setRealField(true);
                field.setIconClass(null);
                field.setProps(new JSONObject());
                field.setDataType(type);
                field.setIsRealField(true);
                field.setReadOnly(false);
                field.setVirtualField(false);
                field.setFieldAlias(comment);
                field.setRename(comment);
                field.setTable(dataSetName);
                field.setField(name);
                field.setParentKey(null);
                field.setChildren(DataSetToSysFormUtil.returnValueToWidgetField(propertiesList, dataSetName, datasetType));
                field.setI18ntitle(null);
                field.setParams(null);
                field.setResult(null);
                field.setPrimary(null);
                list.add(field);
            }
        }
        return list;
    }

    public static List<WidgetField> dataSetToSqlField(WordDataSetInfo wordDataSetInfo) {
        ArrayList<WidgetField> list = new ArrayList<WidgetField>();
        try {
            JSONArray projection;
            JSONObject jsonObject = JSON.parseObject((String)wordDataSetInfo.getData());
            JSONObject dataSetParam = jsonObject.getJSONObject("dataSetParam");
            if (dataSetParam != null && (projection = dataSetParam.getJSONArray("projection")) != null) {
                for (int i = 0; i < projection.size(); ++i) {
                    JSONObject fieldObj = projection.getJSONObject(i);
                    WidgetField field = new WidgetField();
                    String id = fieldObj.getString("id");
                    String name = fieldObj.getString("name");
                    String fieldName = fieldObj.getString("field");
                    String type = fieldObj.getString("type");
                    String dataType = fieldObj.getString("dataType");
                    String rename = fieldObj.getString("rename");
                    if (StringUtil.isEmpty((String)id)) {
                        id = name;
                    }
                    field.setFieldId(id);
                    field.setName(fieldName);
                    field.setType(DataType.getIconByValue(dataType));
                    field.setTitle(rename);
                    field.setUsage(null);
                    field.setIsRealField(true);
                    field.setRealField(true);
                    field.setIconClass(null);
                    field.setProps(new JSONObject());
                    field.setDataType(type);
                    field.setIsRealField(true);
                    field.setReadOnly(false);
                    field.setVirtualField(false);
                    field.setFieldAlias(rename);
                    field.setRename(rename);
                    field.setTable(wordDataSetInfo.getDataSetName());
                    field.setField(name);
                    field.setParentKey(null);
                    field.setChildren(new ArrayList());
                    field.setI18ntitle(null);
                    field.setParams(null);
                    field.setResult(null);
                    field.setPrimary(null);
                    list.add(field);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

