/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.report.dashboard.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.dataset.model.DataSetCommonParam;
import com.jxdinfo.hussar.dataset.model.DataSetCondition;
import com.jxdinfo.hussar.dataset.service.IDataSetEngineService;
import com.jxdinfo.hussar.dataset.vo.DataSetExecuteVO;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.report.dashboard.qo.ReportSuperQueryConditionDto;
import com.jxdinfo.hussar.report.dashboard.service.IReportDataSetToDashboardService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.dashboard.service.impl.DataSetToDashboardServiceImpl")
@HussarTokenDs
public class ReportDataSetToDashboardServiceImpl
implements IReportDataSetToDashboardService {
    private static final Logger logger = LoggerFactory.getLogger(ReportDataSetToDashboardServiceImpl.class);

    private IDataSetEngineService getDataSetEngineService() {
        try {
            return (IDataSetEngineService)SpringUtil.getBean(IDataSetEngineService.class);
        }
        catch (Exception e) {
            logger.warn("\u65e0\u6cd5\u83b7\u53d6 IDataSetEngineService \u5b9e\u4f8b: {}", (Object)e.getMessage());
            return null;
        }
    }

    public List<DataSetExecuteVO> formatResult(List<DataSetCommonParam> dataSetCommonParams) {
        List<DataSetExecuteVO> dataSetExecuteVOList = new ArrayList();
        dataSetExecuteVOList = (List)this.getDataSetEngineService().executeDataSetParam(dataSetCommonParams).getData();
        ObjectMapper objectMapper = new ObjectMapper();
        if (HussarUtils.isNotEmpty(dataSetExecuteVOList)) {
            for (DataSetExecuteVO dataSetExecuteVO : dataSetExecuteVOList) {
                String value = dataSetExecuteVO.getReturnValue();
                try {
                    JsonNode jsonNode = objectMapper.readTree(value);
                    if (jsonNode.isArray() || !jsonNode.isObject()) continue;
                    Map mapValue = (Map)objectMapper.readValue(value, Map.class);
                    boolean foundList = false;
                    for (Map.Entry entry : mapValue.entrySet()) {
                        if (!(entry.getValue() instanceof List)) continue;
                        List firstList = (List)entry.getValue();
                        String listJsonString = objectMapper.writeValueAsString((Object)firstList);
                        dataSetExecuteVO.setReturnValue(listJsonString);
                        foundList = true;
                        break;
                    }
                    if (foundList) continue;
                    dataSetExecuteVO.setReturnValue("[]");
                }
                catch (Exception e) {
                    System.err.println("\u65e0\u6548\u7684 JSON \u5b57\u7b26\u4e32: " + value);
                }
            }
        }
        return dataSetExecuteVOList;
    }

    public Object excuteDataSet(Map<String, Object> params, String dataSetId) {
        Integer current;
        Object aggregationRule;
        ArrayList<DataSetCommonParam> dataSetCommonParams = new ArrayList<DataSetCommonParam>();
        DataSetCommonParam dataSetCommonParam = new DataSetCommonParam();
        DataSetCondition dataSetCondition = new DataSetCondition();
        dataSetCondition.setDataSetId(dataSetId);
        dataSetCondition.setPagination(false);
        dataSetCondition.setDataSetFunctionType("CUSTOM_SQL");
        Object superQueryConditionMap = params.get("superQueryConditionDto");
        if (HussarUtils.isNotEmpty((Object)superQueryConditionMap)) {
            List<SuperQueryConditionDto> convertedConditions = this.convertToSuperQueryConditions(superQueryConditionMap);
            dataSetCondition.setSuperQueryConditionDto(convertedConditions);
        }
        if (HussarUtils.isNotEmpty((Object)(aggregationRule = params.get("groupAggregation")))) {
            dataSetCondition.setAggregationRule(aggregationRule);
        }
        dataSetCondition.setNeedConvert(Boolean.valueOf(false));
        Integer size = HussarUtils.isEmpty((Object)params.get("size")) ? null : Integer.valueOf(Integer.parseInt(params.get("size").toString()));
        Integer n = current = HussarUtils.isEmpty((Object)params.get("current")) ? null : Integer.valueOf(Integer.parseInt(params.get("current").toString()));
        if (HussarUtils.isNotEmpty((Object)size) && HussarUtils.isNotEmpty((Object)current)) {
            dataSetCondition.setPagination(true);
            dataSetCondition.setCurrent(current.intValue());
            dataSetCondition.setSize(size.intValue());
        }
        dataSetCommonParam.setDataSetCondition(dataSetCondition);
        dataSetCommonParams.add(dataSetCommonParam);
        List<DataSetExecuteVO> dataSetExecuteVOList = this.formatResult(dataSetCommonParams);
        if (HussarUtils.isEmpty(dataSetExecuteVOList)) {
            return new PageVo(new ArrayList(), Long.valueOf(0L));
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String returnValueStr = dataSetExecuteVOList.get(0).getReturnValue();
            List resultList = (List)objectMapper.readValue(returnValueStr, List.class);
            Long count = HussarUtils.isNotEmpty((Object)dataSetExecuteVOList.get(0).getCount()) ? dataSetExecuteVOList.get(0).getCount() : resultList.size();
            return new PageVo(resultList, count);
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362\u8fd4\u56de\u7ed3\u679c\u5931\u8d25", (Throwable)e);
            return new PageVo(new ArrayList(), Long.valueOf(0L));
        }
    }

    private List<SuperQueryConditionDto> convertToSuperQueryConditions(Object superQueryConditionMap) {
        ArrayList<SuperQueryConditionDto> result = new ArrayList<SuperQueryConditionDto>();
        if (superQueryConditionMap instanceof List) {
            List reportConditions = (List)superQueryConditionMap;
            for (ReportSuperQueryConditionDto reportCondition : reportConditions) {
                SuperQueryConditionDto superCondition = new SuperQueryConditionDto();
                superCondition.setField(reportCondition.getField());
                superCondition.setMatch(reportCondition.getMatch());
                superCondition.setRule(reportCondition.getRule());
                superCondition.setVal((Object)reportCondition.getVal());
                result.add(superCondition);
            }
        }
        return result;
    }
}

