/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.report.dashboard.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.dataset.model.WordDataSetInfo;
import com.jxdinfo.hussar.dataset.service.IDataSetGroupService;
import com.jxdinfo.hussar.dataset.service.IDataSetService;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.report.dashboard.emnus.WidgetType;
import com.jxdinfo.hussar.report.dashboard.json.ReportChartType;
import com.jxdinfo.hussar.report.dashboard.json.ReportDimension;
import com.jxdinfo.hussar.report.dashboard.json.ReportFilterData;
import com.jxdinfo.hussar.report.dashboard.json.ReportGroupAggregation;
import com.jxdinfo.hussar.report.dashboard.json.ReportMetric;
import com.jxdinfo.hussar.report.dashboard.json.ReportParamsData;
import com.jxdinfo.hussar.report.dashboard.json.ReportQueryDataJson;
import com.jxdinfo.hussar.report.dashboard.json.ReportQueryOrder;
import com.jxdinfo.hussar.report.dashboard.json.ReportShowField;
import com.jxdinfo.hussar.report.dashboard.qo.ReportSuperQueryConditionDto;
import com.jxdinfo.hussar.report.dashboard.run.plugin.base.data.ConvertData;
import com.jxdinfo.hussar.report.dashboard.run.plugin.base.service.support.AbstractPluginBaseRemoteService;
import com.jxdinfo.hussar.report.dashboard.service.IReportDashboardFeignService;
import com.jxdinfo.hussar.report.dashboard.service.IReportDataSetToDashboardService;
import com.jxdinfo.hussar.report.dashboard.util.ConstantUtil;
import com.jxdinfo.hussar.report.dashboard.util.DataSetToSysFormUtil;
import com.jxdinfo.hussar.report.dto.DashAppTreeDto;
import com.jxdinfo.hussar.report.dto.DashFormDto;
import com.jxdinfo.hussar.report.dto.DashFormGroupDto;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class ReportDashboardFeignServiceImpl
implements IReportDashboardFeignService {
    private static final Logger logger = LoggerFactory.getLogger(ReportDashboardFeignServiceImpl.class);
    @Resource
    private IReportDataSetToDashboardService dataSetToDashboardService;

    private IDataSetService getDataSetService() {
        try {
            return (IDataSetService)SpringUtil.getBean(IDataSetService.class);
        }
        catch (Exception e) {
            logger.warn("\u65e0\u6cd5\u83b7\u53d6 IDataSetService \u5b9e\u4f8b: {}", (Object)e.getMessage());
            return null;
        }
    }

    private IDataSetGroupService getDataSetGroupService() {
        try {
            return (IDataSetGroupService)SpringUtil.getBean(IDataSetGroupService.class);
        }
        catch (Exception e) {
            logger.warn("\u65e0\u6cd5\u83b7\u53d6 IDataSetGroupService \u5b9e\u4f8b: {}", (Object)e.getMessage());
            return null;
        }
    }

    public List<Map<String, Object>> getDataSourceList(String type, String key) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        List<Object> appTreeExtendVoList = new ArrayList();
        ApiResponse datasetList = this.getDataSetGroupService().getAllDataSetAndGroup();
        if (ApiResponse.isSuccess((ApiResponse)datasetList)) {
            List dataSetGroupAllVos = (List)datasetList.getData();
            appTreeExtendVoList = DataSetToSysFormUtil.dataSetToAppTree(dataSetGroupAllVos);
        }
        if (appTreeExtendVoList != null) {
            for (DashAppTreeDto vo : appTreeExtendVoList) {
                List noGroupList = vo.getNoGroupList();
                if (noGroupList != null) {
                    ArrayList<DashFormDto> resNoGroupList = new ArrayList<DashFormDto>();
                    for (DashFormDto sysFormDataVo : noGroupList) {
                        if ("2".equals(sysFormDataVo.getFormType())) continue;
                        resNoGroupList.add(sysFormDataVo);
                    }
                    vo.setNoGroupList(resNoGroupList);
                }
                List formGroupExtendVoList = vo.getSysFormGroupVos();
                ArrayList<DashFormGroupDto> resFormGroupExtendVoList = new ArrayList<DashFormGroupDto>();
                for (DashFormGroupDto formGroupExtendVo : formGroupExtendVoList) {
                    List formDataVoList = formGroupExtendVo.getSysFormList();
                    if (formDataVoList != null) {
                        ArrayList<DashFormDto> resFormDataVoList = new ArrayList<DashFormDto>();
                        for (DashFormDto sysFormDataVo : formDataVoList) {
                            resFormDataVoList.add(sysFormDataVo);
                        }
                        formGroupExtendVo.setSysFormList(resFormDataVoList);
                    }
                    resFormGroupExtendVoList.add(formGroupExtendVo);
                }
                vo.setSysFormGroupVos(resFormGroupExtendVoList);
                dataList.add(BeanUtil.beanToMap((Object)vo));
            }
        }
        return dataList;
    }

    public Map<String, Object> getDataSourceInfo(String type, String appId, String formId, String appCode, String apiCode) {
        HashMap<String, Object> resMap = new HashMap();
        WordDataSetInfo wordDataSetInfo = (WordDataSetInfo)this.getDataSetService().getById((Serializable)((Object)formId));
        resMap = DataSetToSysFormUtil.dataSetToSysFormAndField(wordDataSetInfo);
        return resMap;
    }

    public List<Map<String, Object>> getDataOption(Map<String, Object> queryMap) {
        String fieldName = queryMap.get("fieldName").toString();
        String fieldType = queryMap.get("fieldType").toString();
        ArrayList<Map<String, Object>> resList = new ArrayList<Map<String, Object>>();
        HashMap<String, Serializable> paramsData = new HashMap<String, Serializable>();
        paramsData.put("size", Integer.valueOf(Integer.MAX_VALUE));
        paramsData.put("current", Integer.valueOf(1));
        HashMap groupAggregation = new HashMap();
        ArrayList<String> groupList = new ArrayList<String>();
        groupList.add(fieldName);
        groupAggregation.put("group", groupList);
        paramsData.put("groupAggregation", groupAggregation);
        Object response = this.dataSetToDashboardService.excuteDataSet(queryMap, queryMap.get("formId").toString());
        if (HussarUtils.isNotEmpty((Object)response)) {
            PageVo data = (PageVo)response;
            if (HussarUtils.isEmpty((Object)data)) {
                return resList;
            }
            List res = data.getData();
            HashSet seenValues = new HashSet();
            for (Map map : res) {
                Object fieldValue;
                if (map == null || !seenValues.add(fieldValue = map.get(fieldName))) continue;
                HashMap resMap = new HashMap();
                resMap.put("label", fieldValue);
                resMap.put("value", fieldValue);
                resList.add(resMap);
            }
        }
        return resList;
    }

    public Map<String, Object> queryDataChart(ReportQueryDataJson queryDataJson) {
        int limit;
        boolean enable;
        HashMap data = new HashMap();
        Map<Object, Object> paramsData = new HashMap();
        String chartType = queryDataJson.getWidget().getChartType();
        List fieldDetails = new ArrayList();
        String dataSetType = queryDataJson.getType();
        Map<String, Object> dataSourceInfo = this.getDataSourceInfo(queryDataJson.getType(), queryDataJson.getAppId(), queryDataJson.getFormId(), queryDataJson.getAppCode(), queryDataJson.getApiCode());
        if (HussarUtils.isNotEmpty(dataSourceInfo) && HussarUtils.isNotEmpty((Object)dataSourceInfo.get("list"))) {
            fieldDetails = (List)dataSourceInfo.get("list");
        }
        ArrayList metrics = new ArrayList();
        metrics.addAll(queryDataJson.getWidget().getMetrics());
        List xFields = queryDataJson.getWidget().getxFields();
        HashMap<String, String> dateFormatMap = new HashMap<String, String>();
        if (fieldDetails != null) {
            for (WidgetField widgetField : fieldDetails) {
                if (!HussarUtils.equals((Object)widgetField.getType(), (Object)WidgetType.DATE.getType()) || !HussarUtils.isNotEmpty((Object)widgetField.getProps()) || !HussarUtils.isNotEmpty((Object)widgetField.getProps().get((Object)"format"))) continue;
                dateFormatMap.put(widgetField.getName(), widgetField.getProps().get((Object)"format").toString());
            }
        }
        paramsData = this.initAggregation(queryDataJson, dateFormatMap);
        Map rowFilter = queryDataJson.getWidget().getRowsFilter();
        if (HussarUtils.isNotEmpty((Object)rowFilter)) {
            boolean bl = enable = rowFilter.get("enable") == null ? false : Boolean.parseBoolean(rowFilter.get("enable").toString());
            limit = enable ? (rowFilter.get("index") != null ? Integer.parseInt(rowFilter.get("index").toString()) : Integer.MAX_VALUE) : Integer.MAX_VALUE;
        } else {
            limit = queryDataJson.getLimit() == 0 ? Integer.MAX_VALUE : queryDataJson.getLimit();
            enable = true;
        }
        if (enable) {
            if (limit == Integer.MAX_VALUE) {
                paramsData.put("size", Integer.MAX_VALUE);
            } else {
                paramsData.put("size", limit + 1);
            }
        } else {
            paramsData.put("size", Integer.MAX_VALUE);
        }
        paramsData.put("current", 1);
        Map<String, Object> optionMap = new HashMap<String, Object>();
        PageVo response = (PageVo)this.dataSetToDashboardService.excuteDataSet(paramsData, queryDataJson.getFormId());
        if (ReportChartType.METRIC_TABLE.getType().equals(chartType)) {
            if (xFields.size() > 0) {
                Object resList;
                HashMap sumParam = new HashMap();
                BeanUtil.copy(paramsData, sumParam);
                ((Map)sumParam.get("groupAggregation")).put("group", null);
                ApiResponse<Object> sumResponse = this.executeQueryByDataSetType(dataSetType, queryDataJson, paramsData);
                if (sumResponse.isSuccess() && HussarUtils.isNotEmpty((Object)(resList = ((PageVo)sumResponse.getData()).getData()))) {
                    Map sumMap = (Map)resList.get(0);
                    data.put("sumMap", sumMap);
                }
            } else {
                List resList = response.getData();
                if (HussarUtils.isNotEmpty((Object)resList)) {
                    Map sumMap = (Map)resList.get(0);
                    data.put("sumMap", sumMap);
                }
            }
        }
        ReportParamsData paramsDataObj = (ReportParamsData)BeanUtil.mapToBean(paramsData, ReportParamsData.class, (boolean)false);
        if (response.getData() != null) {
            ArrayList<Map> resList = new ArrayList<Map>();
            for (Map map : response.getData()) {
                if (map == null || resList.size() >= limit) continue;
                resList.add(map);
            }
            for (Object dimension : xFields) {
                int i;
                String decimalStr;
                String value;
                String[] numStrArr;
                String decimalString;
                BigDecimal decimalValue;
                String numStr;
                ArrayList<Map> mapList;
                if (WidgetType.JXDNSwitch.getType().equals(dimension.getType())) {
                    List textEntry = (List)dimension.getProps().get("textEntry");
                    for (Map map : resList) {
                        if ("".equals(map.get(dimension.getName())) || map.get(dimension.getName()) == null) continue;
                        int yesOrNo = Integer.parseInt(map.get(dimension.getName()).toString());
                        map.put(dimension.getName(), textEntry.get(yesOrNo));
                    }
                }
                if (WidgetType.DATE.getType().equals(dimension.getType())) {
                    if (HussarUtils.isEmpty((Object)dimension.getProps())) continue;
                    for (Map resMap3 : resList) {
                        if (resMap3.get(dimension.getName()) == null) continue;
                        String string = dimension.getProps().get("format").toString();
                        LocalDateTime localDateTime = (LocalDateTime)resMap3.get(dimension.getName());
                        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(string);
                        resMap3.put(dimension.getName(), dateTimeFormatter.format(localDateTime));
                    }
                }
                if (WidgetType.NUMBER.getType().equals(dimension.getType())) {
                    if (HussarUtils.isEmpty((Object)dimension.getProps())) continue;
                    int decimalNum = Integer.parseInt(dimension.getProps().get("decimalNum").toString());
                    mapList = new ArrayList<Map>();
                    for (Map resMap4 : resList) {
                        if (resMap4 == null) continue;
                        if (resMap4.get(dimension.getName()) != null) {
                            numStr = resMap4.get(dimension.getName()).toString();
                            decimalValue = new BigDecimal(numStr);
                            decimalString = decimalValue.toPlainString();
                            numStrArr = decimalString.split("\\.");
                            value = numStrArr[0];
                            if (numStrArr.length > 1 && decimalNum > 0) {
                                if (numStrArr[1].length() >= decimalNum) {
                                    value = value + "." + numStrArr[1].substring(0, decimalNum);
                                } else {
                                    decimalStr = "." + numStrArr[1];
                                    for (i = 0; i < decimalNum - numStrArr[1].length(); ++i) {
                                        decimalStr = decimalStr + "0";
                                    }
                                    value = value + decimalStr;
                                }
                            }
                            resMap4.put(dimension.getName(), value);
                        }
                        mapList.add(resMap4);
                    }
                    resList = mapList;
                }
                if (WidgetType.SELECT_MUL.getType().equals(dimension.getType()) || WidgetType.CHECK_BOX_GROUP.getType().equals(dimension.getType())) {
                    for (Map resMap : resList) {
                        if (resMap.get(this.getLabel(dimension.getName(), dimension.getType())) == null) continue;
                        String string = resMap.get(this.getLabel(dimension.getName(), dimension.getType())).toString();
                        if ("[]".equals(string)) {
                            resMap.put(this.getLabel(dimension.getName(), dimension.getType()), "");
                        }
                        if (string.length() <= 4) continue;
                        String string2 = string.substring(2, string.length() - 2).replace("\",\"", ",");
                        resMap.put(this.getLabel(dimension.getName(), dimension.getType()), string2);
                    }
                }
                if (WidgetType.ADDRESS.getType().equals(dimension.getType()) && Boolean.parseBoolean(dimension.getProps().get("fullAddress").toString())) {
                    String addressDetailName = dimension.getName() + "_detailed";
                    String addressName = this.getLabel(dimension.getName(), dimension.getType());
                    for (Map resMap5 : resList) {
                        if (resMap5.get(addressName) == null) continue;
                        resMap5.put(addressName, resMap5.get(addressName).toString() + (resMap5.get(addressDetailName) == null ? "" : resMap5.get(addressDetailName).toString()));
                    }
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (Object fieldName : paramsDataObj.getGroupAggregation().getGroup()) {
                        if (((String)fieldName).equals(addressDetailName)) continue;
                        arrayList.add(fieldName);
                    }
                    paramsDataObj.getGroupAggregation().setGroup(arrayList);
                }
                if ("PROCESS_STATE".equals(dimension.getName())) {
                    List options = (List)dimension.getProps().get("options");
                    for (Map map : resList) {
                        Object fieldName;
                        if (map.get(dimension.getName()) == null) continue;
                        String value2 = map.get(dimension.getName()).toString();
                        fieldName = options.iterator();
                        while (fieldName.hasNext()) {
                            Map option = (Map)fieldName.next();
                            if (!((String)option.get("value")).equals(value2)) continue;
                            map.put(dimension.getName(), option.get("label"));
                        }
                    }
                }
                if (!WidgetType.JXDNAggregate.getType().equals(dimension.getType())) continue;
                int decimalNum = Integer.parseInt(dimension.getProps().get("decimalNum").toString());
                mapList = new ArrayList();
                for (Map resMap6 : resList) {
                    if (resMap6 == null) continue;
                    if (resMap6.get(dimension.getName()) != null) {
                        numStr = resMap6.get(dimension.getName()).toString();
                        decimalValue = new BigDecimal(numStr);
                        decimalString = decimalValue.toPlainString();
                        numStrArr = decimalString.split("\\.");
                        value = numStrArr[0];
                        if (numStrArr.length > 1 && decimalNum > 0) {
                            if (numStrArr[1].length() >= decimalNum) {
                                value = value + "." + numStrArr[1].substring(0, decimalNum);
                            } else {
                                decimalStr = "." + numStrArr[1];
                                for (i = 0; i < decimalNum - numStrArr[1].length(); ++i) {
                                    decimalStr = decimalStr + "0";
                                }
                                value = value + decimalStr;
                            }
                        }
                        resMap6.put(dimension.getName(), value);
                    }
                    mapList.add(resMap6);
                }
                resList = mapList;
            }
            if (chartType.equals(ReportChartType.PROGRESS_CHART.getType())) {
                if (resList.size() > 1) {
                    ((Map)resList.get(0)).putIfAbsent("target", 0);
                    ((Map)resList.get(0)).putIfAbsent("value", 0);
                }
            } else {
                HashMap<String, Object> aggNameMap = new HashMap<String, Object>();
                for (String str : paramsDataObj.getGroupAggregation().getAgg().keySet()) {
                    String aggName = (String)paramsDataObj.getGroupAggregation().getAgg().get(str);
                    int n = aggName.lastIndexOf("_agg");
                    aggNameMap.put(aggName.substring(0, n), aggName);
                }
                for (ReportMetric metric : metrics) {
                    if (!metric.getType().equals(WidgetType.NUMBER.getType())) continue;
                    for (Map map : resList) {
                        map.putIfAbsent(aggNameMap.get(metric.getName()), 0);
                    }
                }
            }
            JSONArray json = JSONArray.parseArray((String)JSON.toJSONString(resList));
            data.put("widget", queryDataJson.getWidget());
            data.put("dataMap", paramsDataObj);
            data.put("json", json);
            AbstractPluginBaseRemoteService service = (AbstractPluginBaseRemoteService)SpringUtil.getBean((String)("report_" + chartType), AbstractPluginBaseRemoteService.class);
            ConvertData newValue = new ConvertData(null, null, data);
            ConvertData convertData = service.convertPluginData(newValue);
            optionMap = (Map)convertData.getData();
        }
        return optionMap;
    }

    public Map<String, Object> queryDataTable(ReportQueryDataJson queryDataJson) {
        PageVo businessData;
        HashMap<String, Object> data = new HashMap<String, Object>();
        List dataSourceDetail = new ArrayList();
        String dataSetType = queryDataJson.getType();
        Map<String, Object> dataSourceInfo = this.getDataSourceInfo(queryDataJson.getType(), queryDataJson.getAppId(), queryDataJson.getFormId(), queryDataJson.getAppCode(), queryDataJson.getApiCode());
        if (HussarUtils.isNotEmpty(dataSourceInfo) && HussarUtils.isNotEmpty((Object)dataSourceInfo.get("list"))) {
            dataSourceDetail = (List)dataSourceInfo.get("list");
        }
        HashMap<String, String> dateFormatMap = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty(dataSourceDetail)) {
            for (WidgetField widgetField : dataSourceDetail) {
                if (!HussarUtils.equals((Object)WidgetType.DATE.getType(), (Object)widgetField.getType()) || HussarUtils.isEmpty((Object)widgetField.getProps())) continue;
                dateFormatMap.put(widgetField.getName(), widgetField.getProps().get((Object)"format").toString());
            }
        }
        Map<String, Object> paramsData = this.initAggregation(queryDataJson, dateFormatMap);
        paramsData.remove("groupAggregation");
        ArrayList<ReportQueryOrder> queryOrderList = new ArrayList<ReportQueryOrder>();
        for (ReportShowField field : queryDataJson.getWidget().getFields()) {
            ReportQueryOrder queryOrder = new ReportQueryOrder();
            queryOrder.setColumn(this.getValue(field.getName(), field.getType()));
            if (field.getSort() == ConstantUtil.ASC_ORDER.intValue()) {
                queryOrder.setAsc(Boolean.valueOf(true));
                queryOrderList.add(queryOrder);
                continue;
            }
            if (field.getSort() != ConstantUtil.DESC_ORDER.intValue()) continue;
            queryOrder.setAsc(Boolean.valueOf(false));
            queryOrderList.add(queryOrder);
        }
        if (!queryOrderList.isEmpty()) {
            HashMap<String, ArrayList<ReportQueryOrder>> groupAggregation = new HashMap<String, ArrayList<ReportQueryOrder>>();
            groupAggregation.put("orders", queryOrderList);
            paramsData.put("groupAggregation", groupAggregation);
        }
        paramsData.put("size", queryDataJson.getLimit());
        paramsData.put("current", queryDataJson.getCurrent());
        Object responseObj = this.dataSetToDashboardService.excuteDataSet(paramsData, queryDataJson.getFormId());
        Map<String, Object> optionMap = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty((Object)responseObj) && (businessData = (PageVo)responseObj) != null && businessData.getData() != null) {
            String chartType = ReportChartType.DATA_TABLE.getType();
            for (WidgetField fieldDetail : dataSourceDetail) {
                int i;
                String decimalStr;
                String value;
                String[] numStrArr;
                String decimalString;
                Object decimalValue;
                String numStr;
                if (HussarUtils.equals((Object)fieldDetail.getType(), (Object)WidgetType.DATE.getType())) {
                    if (HussarUtils.isEmpty((Object)fieldDetail.getProps())) continue;
                    for (Object map : businessData.getData()) {
                        if (map.get(fieldDetail.getName()) == null) continue;
                        String formatStr = fieldDetail.getProps().getString("format");
                        LocalDateTime localDateTime = (LocalDateTime)map.get(fieldDetail.getName());
                        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(formatStr);
                        map.put(fieldDetail.getName(), dateTimeFormatter.format(localDateTime));
                    }
                }
                if (WidgetType.NUMBER.getType().equals(fieldDetail.getType())) {
                    Object map;
                    if (HussarUtils.isEmpty((Object)fieldDetail.getProps())) continue;
                    int decimalNum = Integer.parseInt(fieldDetail.getProps().get((Object)"decimalNum").toString());
                    map = businessData.getData().iterator();
                    while (map.hasNext()) {
                        Map map2 = (Map)map.next();
                        if (map2.get(fieldDetail.getName()) == null) continue;
                        numStr = map2.get(fieldDetail.getName()).toString();
                        decimalValue = new BigDecimal(numStr);
                        decimalString = ((BigDecimal)decimalValue).toPlainString();
                        numStrArr = decimalString.split("\\.");
                        value = numStrArr[0];
                        if (numStrArr.length > 1 && decimalNum > 0) {
                            if (numStrArr[1].length() >= decimalNum) {
                                value = value + "." + numStrArr[1].substring(0, decimalNum);
                            } else {
                                decimalStr = "." + numStrArr[1];
                                for (i = 0; i < decimalNum - numStrArr[1].length(); ++i) {
                                    decimalStr = decimalStr + "0";
                                }
                                value = value + decimalStr;
                            }
                        }
                        map2.put(fieldDetail.getName(), value);
                    }
                }
                if (WidgetType.SELECT_MUL.getType().equals(fieldDetail.getType()) || WidgetType.CHECK_BOX_GROUP.getType().equals(fieldDetail.getType())) {
                    for (Object map : businessData.getData()) {
                        if (map.get(this.getLabel(fieldDetail.getName(), fieldDetail.getType())) == null) continue;
                        Object labelStr = map.get(this.getLabel(fieldDetail.getName(), fieldDetail.getType())).toString();
                        if ("[]".equals(labelStr)) {
                            map.put(this.getLabel(fieldDetail.getName(), fieldDetail.getType()), "");
                        }
                        if (((String)labelStr).length() <= 4) continue;
                        labelStr = ((String)labelStr).substring(2, ((String)labelStr).length() - 2).replace("\",\"", ",");
                        map.put(this.getLabel(fieldDetail.getName(), fieldDetail.getType()), labelStr);
                    }
                }
                if (WidgetType.ADDRESS.getType().equals(fieldDetail.getType()) && Boolean.parseBoolean(fieldDetail.getProps().get((Object)"fullAddress").toString())) {
                    String addressDetailName = fieldDetail.getName() + "_detailed";
                    String addressName = this.getLabel(fieldDetail.getName(), fieldDetail.getType());
                    for (Map map : businessData.getData()) {
                        if (map.get(addressName) == null) continue;
                        map.put(addressName, map.get(addressName).toString() + (map.get(addressDetailName) == null ? "" : map.get(addressDetailName).toString()));
                    }
                }
                if ("PROCESS_STATE".equals(fieldDetail.getName())) {
                    List options = (List)fieldDetail.getProps().get((Object)"options");
                    for (Map map2 : businessData.getData()) {
                        if (map2.get(fieldDetail.getName()) == null) continue;
                        String value2 = map2.get(fieldDetail.getName()).toString();
                        for (Map option : options) {
                            if (!((String)option.get("value")).equals(value2)) continue;
                            map2.put(fieldDetail.getName(), option.get("label"));
                        }
                    }
                }
                if (!WidgetType.JXDNAggregate.getType().equals(fieldDetail.getType())) continue;
                int decimalNum = Integer.parseInt(fieldDetail.getProps().get((Object)"decimalNum").toString());
                for (Map map2 : businessData.getData()) {
                    if (map2.get(fieldDetail.getName()) == null) continue;
                    numStr = map2.get(fieldDetail.getName()).toString();
                    decimalValue = new BigDecimal(numStr);
                    decimalString = ((BigDecimal)decimalValue).toPlainString();
                    numStrArr = decimalString.split("\\.");
                    value = numStrArr[0];
                    if (numStrArr.length > 1 && decimalNum > 0) {
                        if (numStrArr[1].length() >= decimalNum) {
                            value = value + "." + numStrArr[1].substring(0, decimalNum);
                        } else {
                            decimalStr = "." + numStrArr[1];
                            for (i = 0; i < decimalNum - numStrArr[1].length(); ++i) {
                                decimalStr = decimalStr + "0";
                            }
                            value = value + decimalStr;
                        }
                    }
                    map2.put(fieldDetail.getName(), value);
                }
            }
            JSONObject json = JSONObject.parseObject((String)JSON.toJSONString((Object)businessData));
            data.put("dataSourceDetail", dataSourceDetail);
            data.put("widget", queryDataJson.getWidget());
            data.put("dataMap", paramsData);
            data.put("json", json);
            data.put("formId", queryDataJson.getFormId());
            data.put("limit", queryDataJson.getLimit());
            data.put("current", queryDataJson.getCurrent());
            data.putAll(queryDataJson.getWidget().getRowsFilter());
            AbstractPluginBaseRemoteService service = (AbstractPluginBaseRemoteService)SpringUtil.getBean((String)("report_" + chartType), AbstractPluginBaseRemoteService.class);
            ConvertData newValue = new ConvertData(null, null, data);
            ConvertData convertData = service.convertPluginData(newValue);
            optionMap = (Map)convertData.getData();
            if (ReportChartType.GANTT_CHART.getType().equals(queryDataJson.getWidget().getChartType()) && queryDataJson.getWidget().getHasXAxis().booleanValue()) {
                paramsData.put("size", Integer.MAX_VALUE);
                paramsData.put("current", 1);
                Object responseObjG = this.dataSetToDashboardService.excuteDataSet(paramsData, queryDataJson.getFormId());
                if (HussarUtils.isNotEmpty((Object)responseObjG)) {
                    PageVo businessDataGantt = (PageVo)responseObjG;
                    List ganttData = businessDataGantt.getData();
                    optionMap.put("xAxis", ganttData);
                }
            }
        }
        return optionMap;
    }

    private Map<String, Object> initAggregation(ReportQueryDataJson queryDataJson, Map<String, String> dateFormatMap) {
        ArrayList metrics = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)queryDataJson.getWidget().getMetrics())) {
            metrics.addAll(queryDataJson.getWidget().getMetrics());
        }
        String chartType = queryDataJson.getWidget().getChartType();
        if (ReportChartType.MULTI_AXES_CHART.getType().equals(chartType) && queryDataJson.getWidget().getRtmetrics() != null) {
            metrics.addAll(queryDataJson.getWidget().getRtmetrics());
        }
        ArrayList<ReportDimension> xField = new ArrayList<ReportDimension>();
        if (HussarUtils.isNotEmpty((Object)queryDataJson.getWidget().getxFields())) {
            xField.addAll(queryDataJson.getWidget().getxFields());
        }
        List filterDataList = queryDataJson.getWidget().getFilter();
        if (ReportChartType.SANKEY_CHART.getType().equals(chartType)) {
            if (queryDataJson.getWidget().getSource() != null) {
                xField.add(queryDataJson.getWidget().getSource());
            }
            if (queryDataJson.getWidget().getTarget() != null) {
                xField.add(queryDataJson.getWidget().getTarget());
            }
        }
        HashMap<String, Object> paramsData = new HashMap<String, Object>();
        ReportGroupAggregation resGroupAggregation = new ReportGroupAggregation();
        ArrayList<ReportQueryOrder> groupOrders = new ArrayList<ReportQueryOrder>();
        if (HussarUtils.isNotEmpty(xField)) {
            ArrayList<String> group = new ArrayList<String>();
            for (ReportDimension dimension : xField) {
                ReportQueryOrder queryOrder;
                ReportQueryOrder queryOrder2;
                String groupName = this.getLabel(dimension.getName(), dimension.getType());
                group.add(groupName);
                if (ReportChartType.MAP_CHART.getType().equals(chartType)) {
                    group.add(dimension.getName() + "_code");
                }
                resGroupAggregation.setGroup(group);
                if (dimension.getSort() == ConstantUtil.ASC_ORDER) {
                    queryOrder2 = new ReportQueryOrder();
                    queryOrder2.setColumn(groupName);
                    queryOrder2.setAsc(Boolean.valueOf(true));
                    groupOrders.add(queryOrder2);
                } else if (dimension.getSort() == ConstantUtil.DESC_ORDER) {
                    queryOrder2 = new ReportQueryOrder();
                    queryOrder2.setColumn(groupName);
                    queryOrder2.setAsc(Boolean.valueOf(false));
                    groupOrders.add(queryOrder2);
                }
                if (!dimension.getType().equals(WidgetType.ADDRESS.getType()) || dimension.getProps().get("fullAddress") == null || !Boolean.parseBoolean(dimension.getProps().get("fullAddress").toString())) continue;
                String addressDetailName = dimension.getName() + "_detailed";
                group.add(addressDetailName);
                if (dimension.getSort() == ConstantUtil.ASC_ORDER) {
                    queryOrder = new ReportQueryOrder();
                    queryOrder.setColumn(addressDetailName);
                    queryOrder.setAsc(Boolean.valueOf(true));
                    groupOrders.add(queryOrder);
                    continue;
                }
                if (dimension.getSort() != ConstantUtil.DESC_ORDER) continue;
                queryOrder = new ReportQueryOrder();
                queryOrder.setColumn(addressDetailName);
                queryOrder.setAsc(Boolean.valueOf(false));
                groupOrders.add(queryOrder);
            }
        }
        if (HussarUtils.isNotEmpty(metrics)) {
            HashMap<String, String> aggMap = new HashMap<String, String>();
            if (ReportChartType.PROGRESS_CHART.getType().equals(queryDataJson.getWidget().getChartType())) {
                List targetValues;
                if (HussarUtils.isNotEmpty(metrics)) {
                    String op = ((ReportMetric)metrics.get(0)).getOp();
                    String aggName = this.getValue(((ReportMetric)metrics.get(0)).getName(), ((ReportMetric)metrics.get(0)).getType());
                    if ("JXDNNumber".equals(((ReportMetric)metrics.get(0)).getType())) {
                        if ("countDistinct".equals(op)) {
                            aggMap.put("COUNT( DISTINCT CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", "value");
                        } else if ("count".equals(op)) {
                            aggMap.put("COUNT( CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", "value");
                        } else {
                            aggMap.put(op.toUpperCase() + "(${" + aggName + "})", "value");
                        }
                    } else if ("countDistinct".equals(op)) {
                        aggMap.put("COUNT( DISTINCT CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", "value");
                    } else if ("count".equals(op)) {
                        aggMap.put("COUNT( CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", "value");
                    } else {
                        aggMap.put(op.toUpperCase() + "(${" + aggName + "})", "value");
                    }
                }
                if (HussarUtils.isNotEmpty((Object)(targetValues = queryDataJson.getWidget().getTargetValues()))) {
                    String op = ((ReportMetric)targetValues.get(0)).getOp();
                    String aggName = this.getValue(((ReportMetric)targetValues.get(0)).getName(), ((ReportMetric)targetValues.get(0)).getType());
                    if ("JXDNNumber".equals(((ReportMetric)targetValues.get(0)).getType())) {
                        if ("countDistinct".equals(op)) {
                            aggMap.put("COUNT( DISTINCT CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", "target");
                        } else if ("count".equals(op)) {
                            aggMap.put("COUNT( CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", "target");
                        } else {
                            aggMap.put(op.toUpperCase() + "(${" + aggName + "})", "target");
                        }
                    } else if ("countDistinct".equals(op)) {
                        aggMap.put("COUNT( DISTINCT CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", "target");
                    } else if ("count".equals(op)) {
                        aggMap.put("COUNT( CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", "target");
                    } else {
                        aggMap.put(op.toUpperCase() + "(${" + aggName + "})", "target");
                    }
                }
                resGroupAggregation.setAgg(aggMap);
            } else {
                for (ReportMetric obj : metrics) {
                    String op = obj.getOp();
                    String aggName = this.getValue(obj.getName(), obj.getType());
                    String name = obj.getName() + "_agg";
                    if (xField != null && xField.size() > 0) {
                        boolean isNotUnique = true;
                        block18: while (isNotUnique) {
                            for (int i = 0; i < xField.size(); ++i) {
                                if (((ReportDimension)xField.get(i)).equals(name)) {
                                    name = name + "a";
                                    continue block18;
                                }
                                if (i != xField.size() - 1) continue;
                                isNotUnique = false;
                            }
                        }
                    }
                    if ("JXDNNumber".equals(obj.getType())) {
                        if ("countDistinct".equals(op)) {
                            aggMap.put("COUNT( DISTINCT CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", name);
                        } else if ("count".equals(op)) {
                            aggMap.put("COUNT( CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", name);
                        } else {
                            aggMap.put(op.toUpperCase() + "(${" + aggName + "})", name);
                        }
                    } else if ("countDistinct".equals(op)) {
                        aggMap.put("COUNT( DISTINCT CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", name);
                    } else if ("count".equals(op)) {
                        aggMap.put("COUNT( CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", name);
                    } else {
                        aggMap.put(op.toUpperCase() + "(${" + aggName + "})", name);
                    }
                    resGroupAggregation.setAgg(aggMap);
                    if (obj.getSort() == ConstantUtil.ASC_ORDER) {
                        ReportQueryOrder queryOrder = new ReportQueryOrder();
                        queryOrder.setColumn(name);
                        queryOrder.setAsc(Boolean.valueOf(true));
                        groupOrders.add(queryOrder);
                        continue;
                    }
                    if (obj.getSort() != ConstantUtil.DESC_ORDER) continue;
                    ReportQueryOrder queryOrder = new ReportQueryOrder();
                    queryOrder.setColumn(name);
                    queryOrder.setAsc(Boolean.valueOf(false));
                    groupOrders.add(queryOrder);
                }
            }
        }
        if (groupOrders.size() > 0) {
            resGroupAggregation.setOrders(groupOrders);
        } else if (xField != null && !xField.isEmpty()) {
            ReportQueryOrder queryOrder = new ReportQueryOrder();
            queryOrder.setColumn(this.getLabel(((ReportDimension)xField.get(0)).getName(), ((ReportDimension)xField.get(0)).getType()));
            queryOrder.setAsc(Boolean.valueOf(true));
            groupOrders.add(queryOrder);
            resGroupAggregation.setOrders(groupOrders);
        }
        if (HussarUtils.isNotEmpty((Object)filterDataList)) {
            ArrayList<ReportSuperQueryConditionDto> superQueryConditionDtos = new ArrayList<ReportSuperQueryConditionDto>();
            for (ReportFilterData filterData : filterDataList) {
                String rel;
                ReportSuperQueryConditionDto dto = new ReportSuperQueryConditionDto();
                dto.setField(this.getValue(filterData.getName(), filterData.getType()));
                if (HussarUtils.equals((Object)WidgetType.DATE.getType(), (Object)filterData.getType()) && HussarUtils.isNotEmpty(dateFormatMap) && (!"yyyy-MM-dd HH:mm:ss".equals(dateFormatMap.get(filterData.getName())) || filterData.getName().equals("START_TIME") || filterData.getName().equals("FINISH_TIME")) && (filterData.getFilterItem().getMethod().equals(OperatorType.EQ.getValue()) || filterData.getFilterItem().getMethod().equals(OperatorType.NE.getValue())) && filterData.getFilterItem().getValue().length > 0 && HussarUtils.isNotEmpty((Object)filterData.getFilterItem().getValue()[0])) {
                    String equalDateValue = filterData.getFilterItem().getValue()[0];
                    DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    LocalDateTime localDateTime = LocalDateTime.parse(equalDateValue, dateTimeFormatter);
                    String year = String.valueOf(localDateTime.getYear());
                    String month = localDateTime.getMonthValue() > 9 ? String.valueOf(localDateTime.getMonthValue()) : "0" + localDateTime.getMonthValue();
                    String day = localDateTime.getDayOfMonth() > 9 ? String.valueOf(localDateTime.getDayOfMonth()) : "0" + localDateTime.getDayOfMonth();
                    String hour = localDateTime.getHour() > 9 ? String.valueOf(localDateTime.getHour()) : "0" + localDateTime.getHour();
                    String minute = localDateTime.getMinute() > 9 ? String.valueOf(localDateTime.getMinute()) : "0" + localDateTime.getMinute();
                    String second = localDateTime.getSecond() > 9 ? String.valueOf(localDateTime.getSecond()) : "0" + localDateTime.getSecond();
                    String startTime = "";
                    String endTime = "";
                    switch (dateFormatMap.get(filterData.getName())) {
                        case "yyyy": {
                            startTime = year + "-01-01 00:00:00";
                            endTime = year + "-12-31 23:59:59";
                            break;
                        }
                        case "yyyy-MM": {
                            int lastDayOfMonth = localDateTime.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth();
                            startTime = year + "-" + month + "-01 00:00:00";
                            endTime = year + "-" + month + "-" + lastDayOfMonth + " 23:59:59";
                            break;
                        }
                        case "yyyy-MM-dd": {
                            startTime = year + "-" + month + "-" + day + " 00:00:00";
                            endTime = year + "-" + month + "-" + day + " 23:59:59";
                            break;
                        }
                        case "yyyy-MM-dd HH": {
                            startTime = year + "-" + month + "-" + day + " " + hour + ":00:00";
                            endTime = year + "-" + month + "-" + day + " " + hour + ":59:59";
                            break;
                        }
                        case "yyyy-MM-dd HH:mm": {
                            startTime = year + "-" + month + "-" + day + " " + hour + ":" + minute + ":00";
                            endTime = year + "-" + month + "-" + day + " " + hour + ":" + minute + ":59";
                            break;
                        }
                        case "yyyy-MM-dd HH:mm:ss": {
                            startTime = year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second + ".000";
                            endTime = year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second + ".999";
                            break;
                        }
                    }
                    String[] timeRange = new String[]{startTime, endTime};
                    filterData.getFilterItem().setValue(timeRange);
                    if (OperatorType.EQ.getValue().equals(filterData.getFilterItem().getMethod())) {
                        filterData.getFilterItem().setMethod(OperatorType.BETWEEN.getValue());
                    } else if (OperatorType.NE.getValue().equals(filterData.getFilterItem().getMethod())) {
                        filterData.getFilterItem().setMethod(OperatorType.NOT_BETWEEN.getValue());
                    }
                }
                if (HussarUtils.isEmpty((Object)(rel = filterData.getRel()))) {
                    rel = "and";
                }
                dto.setMatch(rel.toUpperCase());
                dto.setRule(filterData.getFilterItem().getMethod());
                String value = "";
                for (int i = 0; i < filterData.getFilterItem().getValue().length; ++i) {
                    if (filterData.getFilterItem().getValue()[i] != null) {
                        value = value + filterData.getFilterItem().getValue()[i];
                    }
                    if (i >= filterData.getFilterItem().getValue().length - 1) continue;
                    value = value + ",";
                }
                dto.setVal(value);
                superQueryConditionDtos.add(dto);
            }
            paramsData.put("superQueryConditionDto", superQueryConditionDtos);
        }
        paramsData.put("groupAggregation", BeanUtil.beanToMap((Object)resGroupAggregation));
        return paramsData;
    }

    String getLabel(String name, String type) {
        WidgetType widgetType;
        String res = name;
        if (!"PROCESS_STATE".equals(name) && HussarUtils.isNotEmpty((Object)((Object)(widgetType = WidgetType.getWidgetType(type))))) {
            switch (widgetType) {
                case SELECT_MUL: 
                case SELECT: 
                case RADIO_GROUP: 
                case CHECK_BOX_GROUP: 
                case JXDNUser: 
                case JXDNUserMulti: 
                case JXDNOrg: 
                case JXDNOrgMulti: 
                case ADDRESS: {
                    res = name + "_label";
                    break;
                }
            }
        }
        return res;
    }

    String getValue(String name, String type) {
        String res = name;
        WidgetType widgetType = WidgetType.getWidgetType(type);
        if (HussarUtils.isNotEmpty((Object)((Object)widgetType)) && !"createUser_user".equals(name) && !"updateUser_user".equals(name)) {
            switch (widgetType) {
                case JXDNUser: 
                case JXDNUserMulti: 
                case JXDNOrg: 
                case JXDNOrgMulti: {
                    res = name + "_id";
                    break;
                }
                case ADDRESS: {
                    res = name + "_code";
                    break;
                }
            }
        }
        return res;
    }

    private ApiResponse<Object> executeQueryByDataSetType(String dataSetType, ReportQueryDataJson queryDataJson, Map<String, Object> paramsData) {
        ApiResponse response = null;
        response = ApiResponse.success((Object)this.dataSetToDashboardService.excuteDataSet(paramsData, queryDataJson.getFormId()));
        return response;
    }
}

