/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.report.dashboard.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.report.dashboard.dao.ReportDashEntryRunMapper;
import com.jxdinfo.hussar.report.dashboard.json.ReportDashboardJsonData;
import com.jxdinfo.hussar.report.dashboard.json.ReportWidgetJsonData;
import com.jxdinfo.hussar.report.dashboard.model.ReportDashEntry;
import com.jxdinfo.hussar.report.dashboard.service.IReportDashEntryRunService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class ReportDashEntryRunServiceImpl
extends HussarServiceImpl<ReportDashEntryRunMapper, ReportDashEntry>
implements IReportDashEntryRunService {
    @Resource
    private ReportDashEntryRunMapper dashEntryMapper;

    public ReportDashboardJsonData getEntryInfo(Long panelId) {
        ReportDashboardJsonData dashboardJsonData = this.getJsonData(panelId);
        return dashboardJsonData;
    }

    private ReportDashboardJsonData getJsonData(Long panelId) {
        ReportDashEntry dashEntry = (ReportDashEntry)this.dashEntryMapper.selectById(panelId);
        if (HussarUtils.isNotEmpty((Object)dashEntry)) {
            ReportDashboardJsonData dashboardJsonData = (ReportDashboardJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), ReportDashboardJsonData.class);
            if (dashboardJsonData == null) {
                dashboardJsonData = new ReportDashboardJsonData();
            }
            dashboardJsonData.setGroupId(dashEntry.getGroupId());
            dashboardJsonData.setIcon(dashEntry.getIcon());
            dashboardJsonData.setEntryName(dashEntry.getEntryName());
            return dashboardJsonData;
        }
        return null;
    }

    public ReportWidgetJsonData getChartInfo(Long entryId) {
        ReportWidgetJsonData reportWidgetJsonData = new ReportWidgetJsonData();
        ReportDashEntry dashEntry = (ReportDashEntry)this.dashEntryMapper.selectById(entryId);
        if (dashEntry != null) {
            reportWidgetJsonData = (ReportWidgetJsonData)JSONObject.parseObject((String)dashEntry.getEntryOption(), ReportWidgetJsonData.class);
        }
        return reportWidgetJsonData;
    }

    public List<ReportDashEntry> selectList(Long entryId) {
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)entryId);
        return this.dashEntryMapper.selectList(wrapper);
    }
}

