/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.report.dashboard.controller;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.report.dashboard.json.ReportQueryDataJson;
import com.jxdinfo.hussar.report.dashboard.service.IReportDashboardFeignService;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.jxdinfo.hussar.report.dashboard.controller.DashboardFeignController")
@RequestMapping(value={"/reportDashboard/dashboardFeign"})
@AuditLog(moduleName="\u4eea\u8868\u76d8-\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3")
@Api(tags={"\u4eea\u8868\u76d8-\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3"})
public class ReportDashboardFeignController {
    @Resource
    private IReportDashboardFeignService dashboardFeignService;

    @GetMapping(value={"/getDataSourceList"})
    public ApiResponse<List<Map<String, Object>>> getDataSourceList(String type, String key) {
        List dataSourceList = this.dashboardFeignService.getDataSourceList(type, key);
        return ApiResponse.success((Object)dataSourceList);
    }

    @GetMapping(value={"/getDataSourceDetail"})
    public ApiResponse<Map<String, Object>> getDataSourceDetailUpgrade(String type, String appId, String formId, String appCode, String apiCode) {
        Map resMap = this.dashboardFeignService.getDataSourceInfo(type, appId, formId, appCode, apiCode);
        return ApiResponse.success((Object)resMap);
    }

    @PostMapping(value={"/queryDataChart"})
    public ApiResponse<Map<String, Object>> queryDataChart(@RequestBody String chartInfo) {
        try {
            ReportQueryDataJson queryDataJson = (ReportQueryDataJson)JSON.parseObject((String)chartInfo, ReportQueryDataJson.class);
            if (queryDataJson == null) {
                return ApiResponse.fail((String)"\u53c2\u6570\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (HussarUtils.isEmpty((Object)queryDataJson.getWidget())) {
                return ApiResponse.fail((String)"\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            Map res = this.dashboardFeignService.queryDataChart(queryDataJson);
            return ApiResponse.success((Object)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u7a0b\u5e8f\u5f02\u5e38\u3002");
        }
    }

    @PostMapping(value={"/queryDataTable"})
    public ApiResponse<Map<String, Object>> queryDataTable(@RequestBody String chartInfo) {
        ReportQueryDataJson queryDataJson = new ReportQueryDataJson();
        try {
            queryDataJson = (ReportQueryDataJson)JSON.parseObject((String)chartInfo, ReportQueryDataJson.class);
            if (queryDataJson == null) {
                return ApiResponse.fail((String)"\u53c2\u6570\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            Map res = this.dashboardFeignService.queryDataTable(queryDataJson);
            return ApiResponse.success((Object)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u7a0b\u5e8f\u5f02\u5e38\u3002");
        }
    }

    @PostMapping(value={"/getDataOption"})
    public ApiResponse<List<Map<String, Object>>> getDataOption(@RequestBody Map<String, Object> queryMap) {
        List res = this.dashboardFeignService.getDataOption(queryMap);
        return ApiResponse.success((Object)res);
    }
}

