/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.report.dashboard.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.report.dashboard.json.ReportDashboardJsonData;
import com.jxdinfo.hussar.report.dashboard.json.ReportWidgetJsonData;
import com.jxdinfo.hussar.report.dashboard.model.ReportDashEntry;
import com.jxdinfo.hussar.report.dashboard.service.IReportDashEntryRunService;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.jxdinfo.hussar.report.dashboard.controller.DashEntryRunController")
@RequestMapping(value={"/reportDashboard/dashentryRun"})
@AuditLog(moduleName="\u4eea\u8868\u76d8-\u4eea\u8868\u76d8\u4fe1\u606f\u8868")
@Api(tags={"\u4eea\u8868\u76d8-\u4eea\u8868\u76d8\u5904\u7406"})
public class ReportDashEntryRunController
extends HussarBaseController<ReportDashEntry, IReportDashEntryRunService> {
    Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private IReportDashEntryRunService dashEntryRunService;

    @PostMapping(value={"/pageList"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u4eea\u8868\u76d8\u4fe1\u606f", notes="\u5206\u9875\u67e5\u8be2\u4eea\u8868\u76d8\u4fe1\u606f")
    public ApiResponse<Page<ReportDashEntry>> getPageList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") @RequestBody JSONObject jsonObject) {
        Page page = (Page)jsonObject.toJavaObject(Page.class);
        ReportDashEntry dashEntry = (ReportDashEntry)jsonObject.toJavaObject(ReportDashEntry.class);
        AbstractWrapper queryWrapper = ((QueryWrapper)new QueryWrapper().eq((Object)"ENTRY_TYPE", (Object)"panel")).like(!HussarUtils.isEmpty((Object)dashEntry.getEntryName()), (Object)"ENTRY_NAME", (Object)dashEntry.getEntryName());
        return ApiResponse.success((Object)this.dashEntryRunService.page((IPage)page, (Wrapper)queryWrapper));
    }

    @GetMapping(value={"/getEntryInfo"})
    public ApiResponse<ReportDashboardJsonData> getEntryInfo(@RequestParam(value="parentId") Long parentId) {
        if (HussarUtils.isEmpty((Object)parentId)) {
            return ApiResponse.fail((String)"\u4eea\u8868\u76d8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ReportDashboardJsonData dashboardJsonData = this.dashEntryRunService.getEntryInfo(parentId);
        return ApiResponse.success((Object)dashboardJsonData);
    }

    @GetMapping(value={"/getChartInfo"})
    public ApiResponse<ReportWidgetJsonData> getChartInfo(@RequestParam(value="entryId") Long entryId) {
        if (HussarUtils.isEmpty((Object)entryId)) {
            return ApiResponse.fail((String)"\u4eea\u8868\u76d8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ReportWidgetJsonData reportWidgetJsonData = this.dashEntryRunService.getChartInfo(entryId);
        return ApiResponse.success((Object)reportWidgetJsonData);
    }
}

