/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.report.dashboard.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.report.dashboard.Vo.ReportDashGroupVo;
import com.jxdinfo.hussar.report.dashboard.dao.ReportDashGroupMapper;
import com.jxdinfo.hussar.report.dashboard.model.ReportDashEntry;
import com.jxdinfo.hussar.report.dashboard.model.ReportDashGroup;
import com.jxdinfo.hussar.report.dashboard.service.IReportDashEntryService;
import com.jxdinfo.hussar.report.dashboard.service.IReportDashGroupService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.sync.sync.union.dto.SyncGroupDto;
import com.jxdinfo.hussar.sync.sync.union.service.ReportSyncService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.dashboard.service.impl.DashGroupServiceImpl")
@HussarTokenDs
public class ReportDashGroupServiceImpl
extends HussarServiceImpl<ReportDashGroupMapper, ReportDashGroup>
implements IReportDashGroupService {
    @Resource
    private ReportSyncService reportSyncService;
    @Resource
    private IReportDashEntryService reportDashEntryService;
    @Resource
    private ReportDashGroupMapper reportDashGroupMapper;
    private static final Long MODEL_ID = 6L;

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> addDashGroup(ReportDashGroup dashGroup) {
        ReportDashGroup maxSeqDash;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.orderByDesc(ReportDashGroup::getSeq);
        Page page = new Page(1L, 1L);
        Page resultPage = (Page)this.reportDashGroupMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        List records = resultPage.getRecords();
        ReportDashGroup reportDashGroup = maxSeqDash = HussarUtils.isNotEmpty((Object)records) ? (ReportDashGroup)records.get(0) : null;
        if (HussarUtils.isNotEmpty((Object)maxSeqDash)) {
            int maxGroupSeq = maxSeqDash.getSeq();
            dashGroup.setSeq(Integer.valueOf(maxGroupSeq + 1));
        } else {
            dashGroup.setSeq(Integer.valueOf(1));
        }
        SecurityUser userDetails = BaseSecurityUtil.getUser();
        if (HussarUtils.isNotEmpty((Object)userDetails)) {
            dashGroup.setCreateName(userDetails.getUserName());
        }
        this.save((BaseEntity)dashGroup);
        this.reportSyncService.syncReportGroup("add", this.convertToSyncGroupDto(dashGroup));
        return ApiResponse.success((Object)true);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> editDashGroup(ReportDashGroup dashGroup) {
        SecurityUser userDetails = BaseSecurityUtil.getUser();
        if (HussarUtils.isNotEmpty((Object)userDetails)) {
            dashGroup.setLastEditorName(userDetails.getUserName());
        }
        boolean updated = this.updateById((BaseEntity)dashGroup);
        this.reportSyncService.syncReportGroup("edit", this.convertToSyncGroupDto(dashGroup));
        return ApiResponse.success((Object)updated);
    }

    public ApiResponse<Boolean> editDashGroups(List<ReportDashGroup> dashGroups) {
        return ApiResponse.success((Object)this.updateBatchById(dashGroups));
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> delDashGroup(List<Long> groupIds) {
        for (Long groupId : groupIds) {
            if (!HussarUtils.isNotEmpty((Object)this.reportDashEntryService.getDashEntryVoByGroupId(groupId))) continue;
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff0c\u5206\u7ec4\u4e0b\u5b58\u5728\u4eea\u8868\u76d8!");
        }
        boolean removed = this.removeByIds(groupIds);
        if (HussarUtils.isNotEmpty(groupIds)) {
            Long groupId;
            groupId = groupIds.get(0);
            ReportDashGroup dashGroup = new ReportDashGroup();
            dashGroup.setGroupId(groupId);
            this.reportSyncService.syncReportGroup("del", this.convertToSyncGroupDto(dashGroup));
        }
        return ApiResponse.success((Object)removed);
    }

    public ApiResponse<ReportDashGroup> getDashGroupById(Long groupId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ReportDashGroup::getGroupId, (Object)groupId);
        ReportDashGroup dashGroup = (ReportDashGroup)((ReportDashGroupMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
        return ApiResponse.success((Object)dashGroup);
    }

    public ApiResponse<List<ReportDashGroup>> getDashGroupByName(String groupName) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(ReportDashGroup::getGroupName, (Object)groupName);
        List dashGroups = ((ReportDashGroupMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return ApiResponse.success((Object)dashGroups);
    }

    public List<ReportDashGroup> getAllDashGroup() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.orderByAsc(ReportDashGroup::getSeq);
        List dashGroups = ((ReportDashGroupMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return dashGroups;
    }

    public ApiResponse<List<ReportDashGroupVo>> getAllDashAndGroup() {
        ArrayList<ReportDashGroupVo> dashGroupVos = new ArrayList<ReportDashGroupVo>();
        List<ReportDashGroup> dashGroups = this.getAllDashGroup();
        ReportDashGroupVo dashGroupVoNoGroup = new ReportDashGroupVo();
        dashGroupVoNoGroup.setDashEntrys(this.reportDashEntryService.getDashEntryVoByGroupId(null));
        dashGroupVos.add(dashGroupVoNoGroup);
        for (ReportDashGroup dashGroup : dashGroups) {
            ReportDashGroupVo dashGroupVo = new ReportDashGroupVo();
            dashGroupVo.setGroupId(dashGroup.getGroupId());
            dashGroupVo.setGroupName(dashGroup.getGroupName());
            dashGroupVo.setGroupType(dashGroup.getGroupType());
            dashGroupVo.setGroupIcon(dashGroup.getGroupIcon());
            dashGroupVo.setGroupIconType(dashGroup.getGroupIconType());
            dashGroupVo.setGroupIconColor(dashGroup.getGroupIconColor());
            dashGroupVo.setDescription(dashGroup.getDescription());
            dashGroupVo.setSeq(dashGroup.getSeq());
            dashGroupVo.setCreateTime(dashGroup.getCreateTime());
            dashGroupVo.setLastTime(dashGroup.getLastTime());
            dashGroupVo.setCreator(dashGroup.getCreator());
            dashGroupVo.setLastEditor(dashGroup.getLastEditor());
            dashGroupVo.setDashEntrys(this.reportDashEntryService.getDashEntryVoByGroupId(dashGroup.getGroupId()));
            dashGroupVos.add(dashGroupVo);
        }
        return ApiResponse.success(dashGroupVos);
    }

    public ApiResponse<Boolean> editGroupAndDash(List<ReportDashGroupVo> dashGroupVoList) {
        for (int i = 0; i < dashGroupVoList.size(); ++i) {
            dashGroupVoList.get(i).setSeq(Integer.valueOf(i));
            if (HussarUtils.isEmpty((Object)dashGroupVoList.get(i).getDashEntrys())) continue;
            for (int j = 0; j < dashGroupVoList.get(i).getDashEntrys().size(); ++j) {
                ((ReportDashEntry)dashGroupVoList.get(i).getDashEntrys().get(j)).setSeq(j);
                ((ReportDashEntry)dashGroupVoList.get(i).getDashEntrys().get(j)).setGroupId(dashGroupVoList.get(i).getGroupId());
            }
        }
        List dashGroups = dashGroupVoList.stream().map(entity -> {
            ReportDashGroup dashGroup = new ReportDashGroup();
            BeanUtils.copyProperties((Object)entity, (Object)dashGroup);
            return dashGroup;
        }).collect(Collectors.toList());
        this.updateBatchById(dashGroups);
        ArrayList dashList = new ArrayList();
        for (ReportDashGroupVo dashGroupVo : dashGroupVoList) {
            dashList.addAll(dashGroupVo.getDashEntrys());
        }
        boolean result = this.reportDashEntryService.updateBatchById(dashList);
        return ApiResponse.success((Object)result);
    }

    public ApiResponse<Page<ReportDashGroup>> getDashGroupByNameByPage(String dashGroupName, int pageNum, int pageSize) {
        Page page = new Page((long)pageNum, (long)pageSize);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(ReportDashGroup::getGroupName, (Object)dashGroupName);
        Page dashGroups = (Page)((ReportDashGroupMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)queryWrapper);
        return ApiResponse.success((Object)dashGroups);
    }

    private SyncGroupDto convertToSyncGroupDto(ReportDashGroup reportDashGroup) {
        SyncGroupDto syncGroupDto = new SyncGroupDto();
        syncGroupDto.setGroupId(reportDashGroup.getGroupId());
        syncGroupDto.setGroupName(reportDashGroup.getGroupName());
        syncGroupDto.setParentModelId(MODEL_ID);
        syncGroupDto.setGroupIcon(reportDashGroup.getGroupIcon());
        return syncGroupDto;
    }
}

