/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.report.dashboard.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.report.dashboard.dao.ReportDashEntryMapper;
import com.jxdinfo.hussar.report.dashboard.json.ReportDashboardJsonData;
import com.jxdinfo.hussar.report.dashboard.json.ReportWidgetJsonData;
import com.jxdinfo.hussar.report.dashboard.model.ReportDashEntry;
import com.jxdinfo.hussar.report.dashboard.model.ReportDashEntryHis;
import com.jxdinfo.hussar.report.dashboard.model.ReportDashGroup;
import com.jxdinfo.hussar.report.dashboard.service.IReportDashEntryHisService;
import com.jxdinfo.hussar.report.dashboard.service.IReportDashEntryService;
import com.jxdinfo.hussar.report.dashboard.service.IReportDashGroupService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.sync.sync.union.dto.SyncReportDto;
import com.jxdinfo.hussar.sync.sync.union.service.ReportSyncService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@HussarTokenDs
public class ReportDashEntryServiceImpl
extends HussarServiceImpl<ReportDashEntryMapper, ReportDashEntry>
implements IReportDashEntryService {
    @Resource
    private ReportDashEntryMapper reportDashEntryMapper;
    @Resource
    private IReportDashEntryHisService reportDashEntryHisService;
    @Resource
    private IReportDashGroupService reportDashGroupService;
    @Resource
    private ReportSyncService reportSyncService;
    private static final Long MODEL_ID = 6L;
    private static final String STRATEGY = "6";
    private static final String RES_PATH = "/dashEntry/";
    private static final Logger logger = LoggerFactory.getLogger(ReportDashEntryServiceImpl.class);

    public Long savePanelData(ReportDashEntry dashentry) {
        boolean isAdd;
        Long entryId = IdWorker.getId((Object)new ReportDashEntry());
        dashentry.setEntryId(entryId);
        dashentry.setEntryType("panel");
        ReportDashboardJsonData dashboardJsonData = new ReportDashboardJsonData();
        dashboardJsonData.setPanelId(entryId);
        dashboardJsonData.setEntryName(dashentry.getEntryName());
        dashboardJsonData.setAppId(dashentry.getAppId());
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)dashboardJsonData));
        String jsonStr = JSON.toJSONString((Object)jsonObject);
        dashentry.setEntryOption(jsonStr);
        SecurityUser user = BaseSecurityUtil.getUser();
        dashentry.setCreator(user.getUserId());
        Date date = new Date();
        dashentry.setCreateTime(date);
        if (HussarUtils.isEmpty((Object)dashentry.getAppId())) {
            ReportDashEntry maxSeqReport;
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            if (HussarUtils.isNotEmpty((Object)dashentry.getGroupId())) {
                queryWrapper.eq(ReportDashEntry::getGroupId, (Object)dashentry.getGroupId());
            } else {
                queryWrapper.and(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(ReportDashEntry::getGroupId)).or()).eq(ReportDashEntry::getGroupId, (Object)"");
                });
            }
            queryWrapper.orderByDesc(ReportDashEntry::getSeq);
            Page page = new Page(1L, 1L);
            Page resultPage = (Page)this.reportDashEntryMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
            List records = resultPage.getRecords();
            ReportDashEntry reportDashEntry = maxSeqReport = HussarUtils.isNotEmpty((Object)records) ? (ReportDashEntry)records.get(0) : null;
            if (HussarUtils.isNotEmpty((Object)maxSeqReport)) {
                int maxReportSeq = maxSeqReport.getSeq();
                dashentry.setSeq(maxReportSeq + 1);
            } else {
                dashentry.setSeq(1);
            }
        }
        if ((isAdd = this.save((BaseEntity)dashentry)) && HussarUtils.equals((Object)dashentry.getEntryType(), (Object)"panel")) {
            this.reportSyncService.syncReport("add", this.convertToSyncReportDto(dashentry));
        }
        return entryId;
    }

    public Long saveWidgetData(ReportDashEntry dashEntry) {
        Long entryId = IdWorker.getId((Object)new ReportDashEntry());
        dashEntry.setEntryId(entryId);
        dashEntry.setParentId(null);
        dashEntry.setEntryType("widget");
        dashEntry.setEntryStatus("1");
        ReportWidgetJsonData reportWidgetJsonData = (ReportWidgetJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), ReportWidgetJsonData.class);
        if (reportWidgetJsonData != null) {
            reportWidgetJsonData.setDataSourceId(dashEntry.getDatasourceId());
            reportWidgetJsonData.setDataSourceName(dashEntry.getDatasourceName());
            reportWidgetJsonData.setDataSourceType(dashEntry.getDatasourceType());
            reportWidgetJsonData.setAppId(dashEntry.getAppId());
            reportWidgetJsonData.setTitle(dashEntry.getEntryName());
            reportWidgetJsonData.setEntryId(entryId);
            reportWidgetJsonData.setRel("and");
        } else {
            reportWidgetJsonData = new ReportWidgetJsonData();
        }
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)reportWidgetJsonData));
        String jsonStr = JSON.toJSONString((Object)jsonObject);
        dashEntry.setEntryOption(jsonStr);
        SecurityUser user = BaseSecurityUtil.getUser();
        dashEntry.setCreator(user.getUserId());
        Date date = new Date();
        dashEntry.setCreateTime(date);
        this.reportDashEntryMapper.insert(dashEntry);
        return entryId;
    }

    public Long updateWidgetData(String widgetInfo) {
        logger.info("\u4fdd\u5b58\u56fe\u8868\u4fe1\u606f-----" + widgetInfo);
        ReportWidgetJsonData reportWidgetJsonData = (ReportWidgetJsonData)JSON.parseObject((String)widgetInfo, ReportWidgetJsonData.class);
        ReportDashEntry dashEntry = (ReportDashEntry)this.reportDashEntryMapper.selectById(reportWidgetJsonData.getEntryId());
        if (dashEntry != null) {
            dashEntry.setEntryName(reportWidgetJsonData.getTitle());
            dashEntry.setDatasourceId(reportWidgetJsonData.getDataSourceId());
            dashEntry.setDatasourceName(reportWidgetJsonData.getDataSourceName());
            dashEntry.setDatasourceType(reportWidgetJsonData.getDataSourceType());
            Map map = (Map)JSON.parse((String)widgetInfo);
            String jsonStr = JSON.toJSONString((Object)map);
            dashEntry.setEntryOption(jsonStr);
            SecurityUser user = BaseSecurityUtil.getUser();
            dashEntry.setLastEditor(user.getUserId());
            Date date = new Date();
            dashEntry.setLastTime(date);
            this.reportDashEntryMapper.updateById(dashEntry);
            return reportWidgetJsonData.getEntryId();
        }
        return null;
    }

    public Boolean deleteData(Long entryId) {
        ReportDashboardJsonData dashboardJsonData = this.getJsonData(entryId);
        ReportDashEntryHis dashEntryHis = new ReportDashEntryHis();
        dashEntryHis.setHisPanelId(entryId);
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)dashboardJsonData));
        String jsonStr = JSON.toJSONString((Object)jsonObject);
        dashEntryHis.setHisPanelOption(jsonStr);
        this.reportDashEntryHisService.save((Object)dashEntryHis);
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)entryId);
        List dashEntryList = this.reportDashEntryMapper.selectList(wrapper);
        for (ReportDashEntry dashEntry : dashEntryList) {
            this.reportDashEntryMapper.deleteById(dashEntry.getEntryId());
        }
        this.reportDashEntryMapper.deleteById(entryId);
        SyncReportDto syncReportDto = new SyncReportDto();
        syncReportDto.setReportId(entryId);
        this.reportSyncService.syncReport("del", syncReportDto);
        return true;
    }

    private ReportDashboardJsonData getJsonData(Long entryId) {
        ReportDashEntry dashEntry = (ReportDashEntry)this.reportDashEntryMapper.selectById(entryId);
        ReportDashboardJsonData dashboardJsonData = (ReportDashboardJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), ReportDashboardJsonData.class);
        dashboardJsonData.setEntryName(dashEntry.getEntryName());
        return dashboardJsonData;
    }

    public Long copyWidget(String widgetInfo) {
        logger.info("\u590d\u5236\u56fe\u8868\u6570\u636e-----" + widgetInfo);
        Long entryId = IdWorker.getId((Object)new ReportDashEntry());
        ReportWidgetJsonData reportWidgetJsonData = (ReportWidgetJsonData)JSON.parseObject((String)widgetInfo, ReportWidgetJsonData.class);
        if (reportWidgetJsonData != null) {
            ReportDashEntry widget = (ReportDashEntry)this.reportDashEntryMapper.selectById(reportWidgetJsonData.getEntryId());
            ReportDashEntry dashEntry = new ReportDashEntry();
            dashEntry.setEntryId(entryId);
            dashEntry.setEntryName(reportWidgetJsonData.getTitle());
            dashEntry.setParentId(widget != null ? widget.getParentId() : null);
            dashEntry.setDatasourceId(reportWidgetJsonData.getDataSourceId());
            dashEntry.setDatasourceName(reportWidgetJsonData.getDataSourceName());
            dashEntry.setDatasourceType(reportWidgetJsonData.getDataSourceType());
            reportWidgetJsonData.setEntryId(entryId);
            JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)reportWidgetJsonData));
            String jsonStr = JSON.toJSONString((Object)jsonObject);
            dashEntry.setEntryOption(jsonStr);
            dashEntry.setEntryType("widget");
            SecurityUser user = BaseSecurityUtil.getUser();
            dashEntry.setCreator(user.getUserId());
            Date date = new Date();
            dashEntry.setCreateTime(date);
            this.reportDashEntryMapper.insert(dashEntry);
            return entryId;
        }
        return null;
    }

    public List<ReportDashEntry> selectList(Long entryId) {
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)entryId);
        return this.reportDashEntryMapper.selectList(wrapper);
    }

    public ReportDashEntry copyPanel(Long entryId, String name) {
        ReportWidgetJsonData reportWidgetJsonData;
        ReportDashEntry dashEntryPanel = (ReportDashEntry)this.getById(entryId);
        Long copyPanelId = IdWorker.getId((Object)new ReportDashEntry());
        dashEntryPanel.setEntryId(copyPanelId);
        dashEntryPanel.setEntryName(name);
        List<ReportDashEntry> widgetList = this.selectList(entryId);
        ArrayList<ReportDashEntry> filterList = new ArrayList<ReportDashEntry>();
        HashMap<Long, Long> entryIdMap = new HashMap<Long, Long>();
        JSONArray componentsArray = new JSONArray();
        for (ReportDashEntry widget : widgetList) {
            Long widgetId = IdWorker.getId((Object)new ReportDashEntry());
            entryIdMap.put(widget.getEntryId(), widgetId);
            widget.setEntryId(widgetId);
            widget.setParentId(copyPanelId);
            reportWidgetJsonData = (ReportWidgetJsonData)JSON.parseObject((String)widget.getEntryOption(), ReportWidgetJsonData.class);
            logger.info("\u590d\u5236\u4eea\u8868\u76d8\u6570\u636e-----" + reportWidgetJsonData);
            if (reportWidgetJsonData == null) continue;
            if ("board_filter".equals(reportWidgetJsonData.getType())) {
                filterList.add(widget);
                continue;
            }
            entryIdMap.put(widget.getEntryId(), widgetId);
            reportWidgetJsonData.setEntryId(widgetId);
            JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)reportWidgetJsonData, (boolean)false, (boolean)true));
            String jsonStr = JSON.toJSONString((Object)jsonObject);
            widget.setEntryOption(jsonStr);
            Iterator user = BaseSecurityUtil.getUser();
            widget.setCreator(user.getUserId());
            Date date = new Date();
            widget.setCreateTime(date);
            this.reportDashEntryMapper.insert(widget);
            componentsArray.add((Object)jsonObject);
        }
        for (ReportDashEntry dashEntry : filterList) {
            Long filterId = IdWorker.getId((Object)new ReportDashEntry());
            dashEntry.setParentId(copyPanelId);
            dashEntry.setEntryId(filterId);
            reportWidgetJsonData = (ReportWidgetJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), ReportWidgetJsonData.class);
            reportWidgetJsonData.setEntryId(filterId);
            JSONArray triggers = reportWidgetJsonData.getProps().getJSONArray("triggers");
            JSONArray newTriggers = new JSONArray();
            for (Object obj : triggers) {
                String trigger = obj.toString();
                if (entryIdMap.get(Long.parseLong(trigger)) != null) {
                    newTriggers.add((Object)((Long)entryIdMap.get(Long.parseLong(trigger))).toString());
                    continue;
                }
                newTriggers.add((Object)trigger);
            }
            reportWidgetJsonData.getProps().put("triggers", (Object)newTriggers);
            JSONArray fields = reportWidgetJsonData.getProps().getJSONArray("fields");
            JSONArray newFields = new JSONArray();
            for (Object obj : fields) {
                Map map = (Map)obj;
                if (entryIdMap.get(Long.parseLong((String)map.get("entryId"))) != null) {
                    map.put("entryId", ((Long)entryIdMap.get(Long.parseLong(((String)map.get("entryId")).toString()))).toString());
                }
                newFields.add((Object)map);
            }
            reportWidgetJsonData.getProps().put("fields", (Object)newFields);
            JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)reportWidgetJsonData, (boolean)false, (boolean)true));
            String jsonStr = JSON.toJSONString((Object)jsonObject);
            dashEntry.setEntryOption(jsonStr);
            SecurityUser user = BaseSecurityUtil.getUser();
            dashEntry.setCreator(user.getUserId());
            Date date = new Date();
            dashEntry.setCreateTime(date);
            this.reportDashEntryMapper.insert(dashEntry);
            componentsArray.add((Object)jsonObject);
        }
        ReportDashboardJsonData dashboardJsonData = (ReportDashboardJsonData)JSON.parseObject((String)dashEntryPanel.getEntryOption(), ReportDashboardJsonData.class);
        dashboardJsonData.setPanelId(copyPanelId);
        dashboardJsonData.setEntryName(name);
        dashboardJsonData.setComponents(componentsArray);
        dashboardJsonData.setPublicConfig(null);
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)dashboardJsonData));
        String jsonStr = JSON.toJSONString((Object)jsonObject);
        dashEntryPanel.setEntryOption(jsonStr);
        SecurityUser user = BaseSecurityUtil.getUser();
        dashEntryPanel.setCreator(user.getUserId());
        Date date = new Date();
        dashEntryPanel.setCreateTime(date);
        this.reportDashEntryMapper.insert(dashEntryPanel);
        return dashEntryPanel;
    }

    public boolean updatePanel(ReportDashEntry dashEntry) {
        if (dashEntry != null) {
            ReportDashEntry dashEntryNew = (ReportDashEntry)this.reportDashEntryMapper.selectById(dashEntry.getEntryId());
            ReportDashboardJsonData dashboardJsonData = (ReportDashboardJsonData)JSON.parseObject((String)dashEntryNew.getEntryOption(), ReportDashboardJsonData.class);
            dashboardJsonData.setEntryName(dashEntry.getEntryName());
            String jsonStr = JSON.toJSONString((Object)dashboardJsonData);
            dashEntryNew.setEntryOption(jsonStr);
            dashEntryNew.setGroupId(dashEntry.getGroupId());
            dashEntryNew.setIcon(dashEntry.getIcon());
            dashEntryNew.setEntryName(dashEntry.getEntryName());
            SecurityUser user = BaseSecurityUtil.getUser();
            dashEntryNew.setLastEditor(user.getUserId());
            Date date = new Date();
            dashEntryNew.setLastTime(date);
            dashEntryNew.setIsMenu(dashEntry.getIsMenu());
            this.reportDashEntryMapper.updateById(dashEntryNew);
            if (HussarUtils.equals((Object)dashEntryNew.getEntryType(), (Object)"panel")) {
                this.reportSyncService.syncReport("edit", this.convertToSyncReportDto(dashEntryNew));
            }
            return true;
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean savePanel(ReportDashboardJsonData dashboardJsonData) {
        Wrapper wrapper;
        List dashEntryList;
        logger.info("\u4fdd\u5b58\u4eea\u8868\u76d8\u6570\u636e-----" + dashboardJsonData);
        SecurityUser user = BaseSecurityUtil.getUser();
        Date date = new Date();
        Long panelId = dashboardJsonData.getPanelId();
        ReportDashEntry dashEntry = (ReportDashEntry)this.reportDashEntryMapper.selectById(panelId);
        if (dashEntry == null) {
            return false;
        }
        dashEntry.setEntryName(dashboardJsonData.getEntryName());
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)dashboardJsonData));
        String jsonStr = JSON.toJSONString((Object)jsonObject);
        dashEntry.setEntryOption(jsonStr);
        dashEntry.setLastEditor(user.getUserId());
        dashEntry.setLastTime(date);
        this.reportDashEntryMapper.updateById(dashEntry);
        if (HussarUtils.equals((Object)dashEntry.getEntryType(), (Object)"panel")) {
            this.reportSyncService.syncReport("edit", this.convertToSyncReportDto(dashEntry));
        }
        if ((dashEntryList = this.reportDashEntryMapper.selectList(wrapper = (Wrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)panelId))).size() > 0) {
            for (ReportDashEntry widgetInfo : dashEntryList) {
                this.saveHisDashboard(widgetInfo);
                this.reportDashEntryMapper.deleteById(widgetInfo.getEntryId());
            }
        }
        JSONArray jsonArray = dashboardJsonData.getComponents();
        logger.info("\u5168\u90e8\u7ec4\u4ef6\u6570\u636e-----" + jsonArray);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject component = jsonArray.getJSONObject(i);
            logger.info("\u7ec4\u4ef6JSON\u6570\u636e-----" + component);
            String componentStr = JSON.toJSONString((Object)component);
            ReportWidgetJsonData reportWidgetJsonData = (ReportWidgetJsonData)JSON.parseObject((String)componentStr, ReportWidgetJsonData.class);
            logger.info("\u7ec4\u4ef6\u6570\u636e-----" + reportWidgetJsonData);
            if (reportWidgetJsonData == null) continue;
            ReportDashEntry widget = new ReportDashEntry();
            if (reportWidgetJsonData.getEntryId() == null) {
                widget.setEntryId(Long.valueOf(IdWorker.getId((Object)new ReportDashEntry())));
                reportWidgetJsonData.setEntryId(widget.getEntryId());
            } else {
                ReportDashEntry oldDash = (ReportDashEntry)this.reportDashEntryMapper.selectById(reportWidgetJsonData.getEntryId());
                if (oldDash != null && HussarUtils.isEmpty((Object)oldDash.getParentId())) {
                    this.saveHisDashboard(oldDash);
                    this.reportDashEntryMapper.deleteById(reportWidgetJsonData.getEntryId());
                }
                widget.setEntryId(reportWidgetJsonData.getEntryId());
            }
            widget.setEntryName(reportWidgetJsonData.getTitle());
            widget.setParentId(panelId);
            widget.setEntryType("widget");
            widget.setDatasourceId(reportWidgetJsonData.getDataSourceId());
            widget.setDatasourceName(reportWidgetJsonData.getDataSourceName());
            widget.setDatasourceType(reportWidgetJsonData.getDataSourceType());
            JSONObject jsonObjectWidget = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)reportWidgetJsonData));
            String widgetStr = JSON.toJSONString((Object)jsonObjectWidget);
            logger.info("\u5c01\u88c5\u540e\u7684\u7ec4\u4ef6\u6570\u636e-----" + widgetStr);
            widget.setEntryOption(widgetStr);
            widget.setCreator(user.getUserId());
            widget.setCreateTime(date);
            this.reportDashEntryMapper.insert(widget);
        }
        return true;
    }

    private void saveHisDashboard(ReportDashEntry widgetInfo) {
        ReportDashEntryHis dashEntryHis = new ReportDashEntryHis();
        dashEntryHis.setHisPanelId(widgetInfo.getEntryId());
        dashEntryHis.setHisPanelOption(widgetInfo.getEntryOption());
        SecurityUser user = BaseSecurityUtil.getUser();
        dashEntryHis.setCreator(user.getUserId());
        Date date = new Date();
        dashEntryHis.setCreateTime(date);
        this.reportDashEntryHisService.save((Object)dashEntryHis);
    }

    public void importPanelData(Long panelId, String icon, Long groupId, String formName, Long appId, List<ReportDashEntry> dashEntryList, Map<Long, Long> formIdMap, Map<Long, Long> dashboardImageIdMap, Boolean isCover) {
        JSONObject jsonObject;
        ReportWidgetJsonData reportWidgetJsonData;
        ReportDashboardJsonData panelJsonData = new ReportDashboardJsonData();
        JSONArray components = new JSONArray();
        HashMap<Long, Long> entryIdMapping = new HashMap<Long, Long>();
        ArrayList<ReportDashEntry> filterList = new ArrayList<ReportDashEntry>();
        ArrayList<ReportDashEntry> newEntryList = new ArrayList<ReportDashEntry>();
        for (int i = 0; i < dashEntryList.size(); ++i) {
            ReportDashEntry dashEntry = dashEntryList.get(i);
            dashEntry.setAppId(appId);
            if ("panel".equals(dashEntry.getEntryType())) {
                JSONObject jsonObject2;
                JSONObject dashboardStyleWidget;
                dashEntry.setEntryId(panelId);
                panelJsonData = (ReportDashboardJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), ReportDashboardJsonData.class);
                panelJsonData.setPanelId(panelId);
                panelJsonData.setAppId(appId);
                panelJsonData.setPublicConfig(null);
                if (formName != null) {
                    panelJsonData.setEntryName(formName);
                    dashEntry.setEntryName(formName);
                }
                if (icon != null) {
                    panelJsonData.setIcon(icon);
                    dashEntry.setIcon(icon);
                }
                if (groupId != null) {
                    panelJsonData.setGroupId(groupId);
                    dashEntry.setGroupId(groupId);
                }
                newEntryList.add(dashEntry);
                if (!HussarUtils.isNotEmpty((Object)panelJsonData.getStyles())) continue;
                JSONObject dashboardStyleBackgroud = panelJsonData.getStyles().getJSONObject("background");
                if (HussarUtils.isNotEmpty((Object)dashboardStyleBackgroud) && HussarUtils.isNotEmpty((Object)dashboardStyleBackgroud.getString("imageUrl"))) {
                    Long backgroudId = Long.parseLong(dashboardStyleBackgroud.getString("imageUrl"));
                    if (dashboardImageIdMap != null) {
                        for (Long key : dashboardImageIdMap.keySet()) {
                            if (!backgroudId.equals(key)) continue;
                            dashboardStyleBackgroud.put("imageUrl", (Object)String.valueOf(dashboardImageIdMap.get(key)));
                        }
                    }
                }
                if (!HussarUtils.isNotEmpty((Object)(dashboardStyleWidget = panelJsonData.getStyles().getJSONObject("widget"))) || !HussarUtils.isNotEmpty((Object)(jsonObject2 = dashboardStyleWidget.getJSONObject("background"))) || !HussarUtils.isNotEmpty((Object)jsonObject2.getString("imageUrl"))) continue;
                Long widgetId = Long.parseLong(jsonObject2.getString("imageUrl"));
                if (dashboardImageIdMap == null) continue;
                for (Long key : dashboardImageIdMap.keySet()) {
                    if (!widgetId.equals(key)) continue;
                    jsonObject2.put("imageUrl", (Object)String.valueOf(dashboardImageIdMap.get(key)));
                }
                continue;
            }
            reportWidgetJsonData = (ReportWidgetJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), ReportWidgetJsonData.class);
            if (!"board_filter".equals(reportWidgetJsonData.getType())) {
                boolean flag = false;
                Long dataSourceId = dashEntry.getDatasourceId();
                if (formIdMap != null) {
                    for (Long key : formIdMap.keySet()) {
                        if (dashEntry.getDatasourceId() == null || !dashEntry.getDatasourceId().equals(key)) continue;
                        flag = true;
                        dataSourceId = formIdMap.get(key);
                    }
                }
                Long entryId = Boolean.TRUE.equals(isCover) ? dashEntry.getEntryId() : Long.valueOf(IdWorker.getId((Object)new ReportDashEntry()));
                entryIdMapping.put(dashEntry.getEntryId(), entryId);
                dashEntry.setParentId(panelId);
                dashEntry.setEntryId(entryId);
                reportWidgetJsonData.setEntryId(entryId);
                reportWidgetJsonData.setAppId(appId);
                if (flag) {
                    dashEntry.setDatasourceId(dataSourceId);
                    reportWidgetJsonData.setDataSourceId(dataSourceId);
                }
                if ("board_image".equals(reportWidgetJsonData.getType())) {
                    JSONObject imageContent = reportWidgetJsonData.getImageContent();
                    JSONArray imageList = imageContent.getJSONArray("imageList");
                    if (HussarUtils.isNotEmpty((Object)imageList)) {
                        for (int j = 0; j < imageList.size(); ++j) {
                            jsonObject = imageList.getJSONObject(j);
                            if (!HussarUtils.isNotEmpty((Object)jsonObject.getString("id"))) continue;
                            Long imageId = Long.parseLong(jsonObject.getString("id"));
                            if (dashboardImageIdMap == null) continue;
                            for (Long key : dashboardImageIdMap.keySet()) {
                                if (!imageId.equals(key)) continue;
                                jsonObject.put("id", (Object)String.valueOf(dashboardImageIdMap.get(key)));
                            }
                        }
                    }
                } else {
                    JSONObject jsonObject3;
                    JSONObject objWidget;
                    JSONObject jsonObjectStyle = reportWidgetJsonData.getStyles();
                    if (HussarUtils.isNotEmpty((Object)jsonObjectStyle) && HussarUtils.isNotEmpty((Object)(objWidget = jsonObjectStyle.getJSONObject("widget"))) && HussarUtils.isNotEmpty((Object)(jsonObject3 = objWidget.getJSONObject("background"))) && HussarUtils.isNotEmpty((Object)jsonObject3.getString("imageUrl"))) {
                        Long backgroudId = Long.parseLong(jsonObject3.getString("imageUrl"));
                        if (dashboardImageIdMap != null) {
                            for (Long l : dashboardImageIdMap.keySet()) {
                                if (!backgroudId.equals(l)) continue;
                                jsonObject3.put("imageUrl", (Object)String.valueOf(dashboardImageIdMap.get(l)));
                            }
                        }
                    }
                }
                Iterator jsonObject4 = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)reportWidgetJsonData, (boolean)false, (boolean)true));
                String jsonStr = JSON.toJSONString((Object)jsonObject4);
                dashEntry.setEntryOption(jsonStr);
                newEntryList.add(dashEntry);
                components.add((Object)jsonObject4);
                continue;
            }
            filterList.add(dashEntry);
        }
        for (ReportDashEntry dashEntry : filterList) {
            reportWidgetJsonData = (ReportWidgetJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), ReportWidgetJsonData.class);
            Long entryId = Boolean.TRUE.equals(isCover) ? dashEntry.getEntryId() : Long.valueOf(IdWorker.getId((Object)new ReportDashEntry()));
            entryIdMapping.put(dashEntry.getEntryId(), entryId);
            dashEntry.setParentId(panelId);
            dashEntry.setEntryId(entryId);
            reportWidgetJsonData.setEntryId(entryId);
            JSONArray triggers = reportWidgetJsonData.getProps().getJSONArray("triggers");
            JSONArray newTriggers = new JSONArray();
            for (Object obj : triggers) {
                String trigger = obj.toString();
                if (entryIdMapping.get(Long.parseLong(trigger)) != null) {
                    newTriggers.add((Object)((Long)entryIdMapping.get(Long.parseLong(trigger))).toString());
                    continue;
                }
                newTriggers.add((Object)trigger);
            }
            reportWidgetJsonData.getProps().put("triggers", (Object)newTriggers);
            JSONArray fields = reportWidgetJsonData.getProps().getJSONArray("fields");
            JSONArray newFields = new JSONArray();
            for (Object obj : fields) {
                Map map = (Map)obj;
                if (entryIdMapping.get(Long.parseLong((String)map.get("entryId"))) != null) {
                    map.put("entryId", ((Long)entryIdMapping.get(Long.parseLong(((String)map.get("entryId")).toString()))).toString());
                }
                if (formIdMap != null) {
                    for (Long key : formIdMap.keySet()) {
                        Long id = Long.parseLong((String)map.get("dataSourceId"));
                        if (!id.equals(key)) continue;
                        map.put("dataSourceId", id.toString());
                    }
                }
                newFields.add((Object)map);
            }
            reportWidgetJsonData.getProps().put("fields", (Object)newFields);
            JSONObject filter = reportWidgetJsonData.getProps().getJSONObject("filter");
            if (formIdMap != null) {
                Object obj;
                obj = formIdMap.keySet().iterator();
                while (obj.hasNext()) {
                    Long key = (Long)obj.next();
                    Long l = Long.parseLong(filter.get((Object)"dataSourceId").toString());
                    if (!l.equals(key)) continue;
                    filter.put("dataSourceId", (Object)l.toString());
                }
            }
            reportWidgetJsonData.getProps().put("filter", (Object)filter);
            dashEntry.setEntryOption(JSON.toJSONString((Object)reportWidgetJsonData));
            jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)reportWidgetJsonData, (boolean)false, (boolean)true));
            components.add((Object)jsonObject);
        }
        newEntryList.addAll(filterList);
        panelJsonData.setComponents(components);
        JSONObject jsonObject5 = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)panelJsonData));
        String jsonStr = JSON.toJSONString((Object)jsonObject5);
        ((ReportDashEntry)newEntryList.get(0)).setEntryOption(jsonStr);
        this.saveOrUpdateBatch(newEntryList);
    }

    public List<ReportDashEntry> getDashEntryVoByGroupId(Long groupId) {
        return this.reportDashEntryMapper.selectDashEntrysByGroupId(groupId);
    }

    public Boolean addMenu(Long dashEntryId) {
        ReportDashEntry reportDashEntry = (ReportDashEntry)this.getById(dashEntryId);
        SyncReportDto syncReportDto = this.convertToSyncReportDto(reportDashEntry);
        if (HussarUtils.isNotEmpty((Object)syncReportDto.getGroupId())) {
            ReportDashGroup reportDashGroup = (ReportDashGroup)this.reportDashGroupService.getDashGroupById(reportDashEntry.getGroupId()).getData();
            syncReportDto.setGroupId(reportDashGroup.getGroupId());
            syncReportDto.setGroupName(reportDashGroup.getGroupName());
            syncReportDto.setGroupIcon(reportDashGroup.getGroupIcon());
        }
        this.reportSyncService.addMenu(syncReportDto);
        reportDashEntry.setIsMenu("1");
        this.updatePanel(reportDashEntry);
        return true;
    }

    public Boolean delMenu(Long reportId) {
        ReportDashEntry reportDashEntry = (ReportDashEntry)this.getById(reportId);
        this.reportSyncService.delMenu(reportId);
        reportDashEntry.setIsMenu("0");
        this.updatePanel(reportDashEntry);
        return true;
    }

    public Boolean isMenu(Long reportId) {
        ReportDashEntry sysReport;
        if (HussarUtils.isNotEmpty((Object)reportId) && HussarUtils.isNotEmpty((Object)(sysReport = (ReportDashEntry)this.getById(reportId))) && HussarUtils.equals((Object)"1", (Object)sysReport.getIsMenu())) {
            return true;
        }
        return false;
    }

    private SyncReportDto convertToSyncReportDto(ReportDashEntry reportDashEntry) {
        SyncReportDto syncReportDto = new SyncReportDto();
        syncReportDto.setReportId(reportDashEntry.getEntryId());
        syncReportDto.setReportName(reportDashEntry.getEntryName());
        syncReportDto.setReportIcon(reportDashEntry.getIcon());
        syncReportDto.setParentModelId(MODEL_ID);
        syncReportDto.setPath(RES_PATH);
        syncReportDto.setStrategy(STRATEGY);
        return syncReportDto;
    }
}

