/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.report.dashboard.controller;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionBoService;
import com.jxdinfo.hussar.region.vo.RegionVo;
import com.jxdinfo.hussar.report.dashboard.json.ReportDashboardJsonData;
import com.jxdinfo.hussar.report.dashboard.json.ReportQueryDataJson;
import com.jxdinfo.hussar.report.dashboard.service.IReportDashEntryPubService;
import com.jxdinfo.hussar.report.dashboard.service.IReportDashboardFeignService;
import com.jxdinfo.hussar.report.dashboard.util.DashboardFileUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.theme.config.model.vo.ThemeVO;
import com.jxdinfo.hussar.theme.config.service.IHussarThemeConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(description="\u6253\u5f00\u4eea\u8868\u76d8\u516c\u5f00\u53d1\u5e03\u4fe1\u606f", value="\u6253\u5f00\u4eea\u8868\u76d8\u516c\u5f00\u53d1\u5e03\u4fe1\u606f")
@RestController
@RequestMapping(value={"/reportDashboard/dashPublicRelease/reportDashboard"})
public class ReportDashOpenPublicLinkController {
    @Resource
    private IReportDashEntryPubService dashentrypubService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private IReportDashboardFeignService dashboardFeignService;
    @Resource
    private IHussarBaseRegionBoService regionBoService;
    @Resource
    private IHussarThemeConfigService sysThemeInfoService;
    @Resource
    private OssService ossService;

    @GetMapping(value={"/verifyStatus"})
    public ApiResponse<Boolean> verifyStatus(@RequestParam(value="linkShortAddress") String linkShortAddress, @RequestParam(value="panelId") String panelId) {
        return ApiResponse.success((Object)this.dashentrypubService.verifyStatus(linkShortAddress, panelId));
    }

    @GetMapping(value={"/isLinkPass"})
    public ApiResponse<Boolean> isLinkPass(@RequestParam(value="panelId") String panelId) {
        return ApiResponse.success((Object)this.dashentrypubService.isLinkPass(panelId));
    }

    @GetMapping(value={"/verifyLinkPass"})
    public ApiResponse<Boolean> verifyLinkPass(@RequestParam(value="panelId") String panelId, @RequestParam(value="linkPass") String linkPass) {
        return ApiResponse.success((Object)this.dashentrypubService.verifyLinkPass(panelId, linkPass));
    }

    @GetMapping(value={"/getEntryInfoOpenLink"})
    public ApiResponse<ReportDashboardJsonData> getEntryInfoOpenLink(@RequestParam(value="parentId") Long parentId) {
        if (HussarUtils.isEmpty((Object)parentId)) {
            return ApiResponse.fail((String)"\u4eea\u8868\u76d8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ReportDashboardJsonData dashboardJsonData = this.dashentrypubService.getEntryInfo(parentId);
        return ApiResponse.success((Object)dashboardJsonData);
    }

    @GetMapping(value={"/attachment/showPicture"})
    public void showImage(HttpServletResponse response, @ApiParam(value="\u56fe\u7247id") Long image) {
        try {
            ApiResponse ossResponse = this.ossService.backgroundDownload(image);
            if (ossResponse.isSuccess()) {
                byte[] data = (byte[])ossResponse.getData();
                DashboardFileUtil.showPicture(data, response);
            }
        }
        catch (IOException e) {
            throw new HussarException("\u670d\u52a1\u5668\u51fa\u9519\u4e86");
        }
    }

    @PostMapping(value={"/dashboardFeign/queryDataChart"})
    public ApiResponse<Map<String, Object>> queryDataChart(@RequestBody String chartInfo) {
        try {
            ReportQueryDataJson queryDataJson = (ReportQueryDataJson)JSON.parseObject((String)chartInfo, ReportQueryDataJson.class);
            if (queryDataJson == null) {
                return ApiResponse.fail((String)"\u53c2\u6570\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            Map res = this.dashboardFeignService.queryDataChart(queryDataJson);
            return ApiResponse.success((Object)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u7a0b\u5e8f\u5f02\u5e38\u3002");
        }
    }

    @PostMapping(value={"/dashboardFeign/queryDataTable"})
    public ApiResponse<Map<String, Object>> queryDataTable(@RequestBody String chartInfo) {
        ReportQueryDataJson queryDataJson = new ReportQueryDataJson();
        try {
            queryDataJson = (ReportQueryDataJson)JSON.parseObject((String)chartInfo, ReportQueryDataJson.class);
            if (queryDataJson == null) {
                return ApiResponse.fail((String)"\u53c2\u6570\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            Map res = this.dashboardFeignService.queryDataTable(queryDataJson);
            return ApiResponse.success((Object)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u7a0b\u5e8f\u5f02\u5e38\u3002");
        }
    }

    @PostMapping(value={"/dashboardFeign/getDataOption"})
    public ApiResponse<List<Map<String, Object>>> getDataSourceDetailUpgrade(@RequestBody Map<String, Object> queryMap) {
        List res = this.dashboardFeignService.getDataOption(queryMap);
        return ApiResponse.success((Object)res);
    }

    @GetMapping(value={"/formdesign/region/getRegionInfoByLevel"})
    public ApiResponse<List<RegionVo>> getRegionInfoByLevel(@RequestParam String level) {
        return ApiResponse.success((Object)this.regionBoService.getRegionInfoByLevel(level));
    }

    @ResponseBody
    @GetMapping(value={"/themeConfig/getCurrentApplicationTheme"})
    public ApiResponse<ThemeVO> getCurrentApplicationTheme() {
        return this.sysThemeInfoService.getCurrentApplicationTheme();
    }
}

