/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.report.dashboard.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.report.dashboard.json.ReportDashboardJsonData;
import com.jxdinfo.hussar.report.dashboard.model.ReportDashEntry;
import com.jxdinfo.hussar.report.dashboard.service.IReportDashEntryService;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.jxdinfo.hussar.report.dashboard.controller.ReportDashEntryController")
@RequestMapping(value={"/reportDashboard/dashentry"})
@AuditLog(moduleName="\u4eea\u8868\u76d8-\u4eea\u8868\u76d8\u4fe1\u606f\u8868")
@Api(tags={"\u4eea\u8868\u76d8-\u4eea\u8868\u76d8\u5904\u7406"})
public class ReportDashEntryController
extends HussarBaseController<ReportDashEntry, IReportDashEntryService> {
    Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private IReportDashEntryService reportDashentryService;

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u4eea\u8868\u76d8\u4fe1\u606f\u4fdd\u5b58", notes="\u4eea\u8868\u76d8\u4fe1\u606f\u4fdd\u5b58")
    public ApiResponse<Long> add(@RequestBody ReportDashEntry dashentry) {
        return ApiResponse.success((Object)this.reportDashentryService.savePanelData(dashentry));
    }

    @PostMapping(value={"/edit"})
    @ApiOperation(value="\u4eea\u8868\u76d8\u4fe1\u606f\u4fee\u6539", notes="\u4eea\u8868\u76d8\u4fe1\u606f\u4fee\u6539")
    public ApiResponse<Long> edit(@RequestBody ReportDashEntry dashentry) {
        if (this.reportDashentryService.updatePanel(dashentry)) {
            return ApiResponse.success((Object)dashentry.getEntryId());
        }
        return ApiResponse.fail((String)"\u4eea\u8868\u76d8\u6570\u636e\u4fee\u6539\u5931\u8d25");
    }

    @GetMapping(value={"/deleteWidgetById"})
    public ApiResponse<Boolean> deleteWidgetById(@RequestParam Long entryId) {
        if (HussarUtils.isEmpty((Object)entryId)) {
            return ApiResponse.fail((String)"\u5220\u9664\u4eea\u8868\u76d8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Wrapper queryWrapper = (Wrapper)new QueryWrapper().eq((Object)"ENTRY_ID", (Object)entryId);
        ReportDashEntry dashEntry = (ReportDashEntry)this.reportDashentryService.getOne(queryWrapper);
        if (dashEntry == null) {
            return ApiResponse.fail((String)"\u5220\u9664\u56fe\u8868\u6570\u636e\u4e0d\u5b58\u5728");
        }
        dashEntry.setEntryStatus("0");
        Boolean flag = this.reportDashentryService.updateById((Object)dashEntry);
        return ApiResponse.success((Object)flag);
    }

    @GetMapping(value={"/deletePanelById"})
    public ApiResponse<Boolean> deletePanelById(@RequestParam Long entryId) {
        if (HussarUtils.isEmpty((Object)entryId)) {
            return ApiResponse.fail((String)"\u5220\u9664\u4eea\u8868\u76d8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Boolean flag = this.reportDashentryService.deleteData(entryId);
        return ApiResponse.success((Object)flag);
    }

    @PostMapping(value={"/addChart"})
    @ApiOperation(value="\u65b0\u589e\u7ec4\u4ef6", notes="\u65b0\u589e\u7ec4\u4ef6")
    public ApiResponse<Long> addChart(@RequestBody ReportDashEntry dashEntry) {
        return ApiResponse.success((Object)this.reportDashentryService.saveWidgetData(dashEntry));
    }

    @PostMapping(value={"/updateChart"})
    @ApiOperation(value="\u4fee\u6539\u7ec4\u4ef6", notes="\u4fee\u6539\u7ec4\u4ef6")
    public ApiResponse<Long> updateChart(@RequestBody String widgetInfo) {
        if (HussarUtils.isEmpty((Object)widgetInfo)) {
            return ApiResponse.fail((String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ApiResponse.success((Object)this.reportDashentryService.updateWidgetData(widgetInfo));
    }

    @PostMapping(value={"/copyWidget"})
    @ApiOperation(value="\u56fe\u8868\u4fe1\u606f\u590d\u5236", notes="\u56fe\u8868\u4fe1\u606f\u590d\u5236")
    public ApiResponse<Long> copyWidget(@RequestBody String widgetInfo) {
        return ApiResponse.success((Object)this.reportDashentryService.copyWidget(widgetInfo));
    }

    @GetMapping(value={"/copyPanel"})
    @ApiOperation(value="\u4eea\u8868\u76d8\u590d\u5236", notes="\u4eea\u8868\u76d8\u590d\u5236")
    public ApiResponse<ReportDashEntry> copyPanel(@RequestParam(value="entryId") Long entryId, @RequestParam(value="name") String name) {
        if (HussarUtils.isEmpty((Object)entryId) || HussarUtils.isEmpty((Object)name)) {
            return ApiResponse.fail((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ReportDashEntry dashEntry = this.reportDashentryService.copyPanel(entryId, name);
        return ApiResponse.success((Object)dashEntry);
    }

    @PostMapping(value={"/savePanel"})
    @ApiOperation(value="\u4fdd\u5b58\u4eea\u8868\u76d8", notes="\u4fdd\u5b58\u4eea\u8868\u76d8")
    public ApiResponse<Boolean> savePanel(@RequestBody ReportDashboardJsonData dashboardJsonData) {
        if (HussarUtils.isEmpty((Object)dashboardJsonData)) {
            return ApiResponse.fail((String)"\u4eea\u8868\u76d8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ApiResponse.success((Object)this.reportDashentryService.savePanel(dashboardJsonData));
    }

    @GetMapping(value={"/addMenu"})
    @ApiOperation(value="\u65b0\u589e\u83dc\u5355", notes="\u65b0\u589e\u83dc\u5355")
    public ApiResponse<Boolean> addMenu(@RequestParam Long dashEntryId) {
        return ApiResponse.success((Object)this.reportDashentryService.addMenu(dashEntryId));
    }

    @GetMapping(value={"/delMenu"})
    @ApiOperation(value="\u5220\u9664\u83dc\u5355", notes="\u5220\u9664\u83dc\u5355")
    public ApiResponse<Boolean> delMenu(@RequestParam Long dashEntryId) {
        return ApiResponse.success((Object)this.reportDashentryService.delMenu(dashEntryId));
    }

    @GetMapping(value={"/isMenu"})
    @ApiOperation(value="\u662f\u5426\u914d\u7f6e\u83dc\u5355", notes="\u662f\u5426\u914d\u7f6e\u83dc\u5355")
    public ApiResponse<Boolean> isMenu(@RequestParam Long dashEntryId) {
        return ApiResponse.success((Object)this.reportDashentryService.isMenu(dashEntryId));
    }
}

