package org.plugins.scan.BroadcastDemo;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceHolder.Callback;
import android.view.SurfaceView;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.Toast;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.Result;
import com.jxdinfo.plugin_scan.R;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import org.plugins.scan.view.ViewfinderView;
import org.plugins.scan.zxing.android.BeepManager;
import org.plugins.scan.zxing.android.CaptureActivityHandler;
import org.plugins.scan.zxing.android.FinishListener;
import org.plugins.scan.zxing.android.InactivityTimer;
import org.plugins.scan.zxing.android.IntentSource;
import org.plugins.scan.zxing.camera.CameraManager;


/**
 * Initial the camera
 *
 * @author Ryan.Tang
 */
public class HussarBarcodeScannerPlugin extends Activity implements Callback {

    public static final String AUTOACTION = "autoAction";
    private CaptureActivityHandler handler;
    private ViewfinderView viewfinderView;
    private boolean hasSurface;
    private Vector<BarcodeFormat> decodeFormats;
    private String characterSet;
    private InactivityTimer inactivityTimer;
    private MediaPlayer mediaPlayer;
    private boolean playBeep;
    private static final float BEEP_VOLUME = 0.10f;
    private boolean vibrate;
    private BeepManager beepManager;
    private CameraManager cameraManager;
    private IntentSource source;
    private Map<DecodeHintType, ?> decodeHints;
    private Camera camera;
    private boolean autoAction;

    /**
     * Called when the activity is first created.
     */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        Window window = getWindow();
        window.addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        setContentView(R.layout.activity_hussar_scan_sacnner);
        autoAction = getIntent().getBooleanExtra(AUTOACTION, false);
        hasSurface = false;
        inactivityTimer = new InactivityTimer(this);
        beepManager = new BeepManager(this);
        CheckBox flashlight = (CheckBox) findViewById(R.id.scan_flashlight);
        flashlight.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Log.e("lala","点击了！");
            }
        });
        flashlight.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    openLightOn();
                } else {
                    closeLightOff();
                }
            }
        });
        ImageView imageView = (ImageView) findViewById(R.id.iv_back);
        imageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                finish();
            }
        });

    }

    @Override
    protected void onResume() {
        super.onResume();
        // CameraManager必须在这里初始化，而不是在onCreate()中。
        // 这是必须的，因为当我们第一次进入时需要显示帮助页，我们并不想打开Camera,测量屏幕大小
        // 当扫描框的尺寸不正确时会出现bug
        cameraManager = new CameraManager(getApplication());

        viewfinderView = (ViewfinderView) findViewById(R.id.viewfinder_view);
        viewfinderView.setCameraManager(cameraManager);
        handler = null;
        SurfaceView surfaceView = (SurfaceView) findViewById(R.id.preview_view);
//        SurfaceView surfaceView = (SurfaceView) findViewById(getId("preview_view","id"));
        SurfaceHolder surfaceHolder = surfaceView.getHolder();
        if (hasSurface) {
            // activity在paused时但不会stopped,因此surface仍旧存在；
            // surfaceCreated()不会调用，因此在这里初始化camera
            initCamera(surfaceHolder);
        } else {
            // 重置callback，等待surfaceCreated()来初始化camera
            surfaceHolder.addCallback(this);
//            surfaceHolder.setType(SurfaceHolder.SURFACE_TYPE_PUSH_BUFFERS);
        }
        beepManager.updatePrefs();
        inactivityTimer.onResume();

        source = IntentSource.NONE;
        decodeFormats = null;
        characterSet = null;

    }

    @Override
    protected void onPause() {
        super.onPause();
        closeLightOff();
        if (handler != null) {
            handler.quitSynchronously();
            handler = null;
        }
        inactivityTimer.onPause();
        beepManager.close();
        cameraManager.closeDriver();
        if (!hasSurface) {
            SurfaceView surfaceView = (SurfaceView) findViewById(R.id.preview_view);
            SurfaceHolder surfaceHolder = surfaceView.getHolder();
            surfaceHolder.removeCallback(this);
        }
        super.onPause();
    }

    @Override
    protected void onDestroy() {

        inactivityTimer.shutdown();
        super.onDestroy();
    }

    /**
     * 扫描成功，处理反馈信息
     *
     * @param result
     * @param barcode
     * @param scaleFacto
     */
    public void handleDecode(Result result, Bitmap barcode, float scaleFacto) {
        inactivityTimer.onActivity();
//        playBeepSoundAndVibrate();
        String resultString = result.getText();
        if (TextUtils.isEmpty(resultString)) {
            Toast.makeText(HussarBarcodeScannerPlugin.this, "扫码失败!", Toast.LENGTH_SHORT).show();
        } else {

                beepManager.playBeepSoundAndVibrate();
                Intent resultIntent = new Intent();
                Bundle bundle = new Bundle();
                bundle.putString("result", resultString);
//            bundle.putParcelable("bitmap", barcode);
                resultIntent.putExtras(bundle);
                setResult(RESULT_OK, resultIntent);
//            Intent intent = getIntent();
//            intent.putExtra("codedContent", resultString);
//            intent.putExtra("codedBitmap", barcode);
//            setResult(RESULT_OK, intent);

//            finish();
        }
        finish();
    }

    /**
     * 初始化Camera
     *
     * @param surfaceHolder
     */
    private void initCamera(SurfaceHolder surfaceHolder) {
        if (surfaceHolder == null) {
            throw new IllegalStateException("No SurfaceHolder provided");
        }
        if (cameraManager.isOpen()) {
            return;
        }
        try {
            // 打开Camera硬件设备
            cameraManager.openDriver(surfaceHolder);
            // 创建一个handler来打开预览，并抛出一个运行时异常
            if (handler == null) {
                handler = new CaptureActivityHandler(this, decodeFormats,
                        decodeHints, characterSet, cameraManager);
            }
        } catch (IOException ioe) {

            displayFrameworkBugMessageAndExit();
        } catch (RuntimeException e) {
            displayFrameworkBugMessageAndExit();
        }
    }

    /**
     * 显示底层错误信息并退出应用
     */
    private void displayFrameworkBugMessageAndExit() {
        String appName = "提示";
        try {
            PackageManager packageManager = getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(
                    getPackageName(), 0);
            int labelRes = packageInfo.applicationInfo.labelRes;
            appName = getResources().getString(labelRes);
        } catch (Exception e) {
            e.printStackTrace();
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle(appName);
        builder.setMessage("对不起，扫码失败！");
        builder.setPositiveButton("ok", new FinishListener(this));
        builder.setOnCancelListener(new FinishListener(this));
        builder.show();
    }

    @Override
    public void surfaceChanged(SurfaceHolder holder, int format, int width,
                               int height) {

    }

    @Override
    public void surfaceCreated(SurfaceHolder holder) {
        if (!hasSurface) {
            hasSurface = true;
            initCamera(holder);
        }

    }

    @Override
    public void surfaceDestroyed(SurfaceHolder holder) {
        hasSurface = false;

    }


    public Handler getHandler() {
        return handler;
    }

    public ViewfinderView getViewfinderView() {
        return viewfinderView;
    }

    public void drawViewfinder() {
        viewfinderView.drawViewfinder();

    }

    public CameraManager getCameraManager() {
        return cameraManager;
    }

    private static final long VIBRATE_DURATION = 200L;


    private Camera m_Camera = null;
    private boolean isflashlightOpen = false;



    private void openLightOn() {
        if (isflashlightOpen) {
            return;
        }
        m_Camera = cameraManager.getCamera();
        Camera.Parameters parameter = m_Camera.getParameters();

        parameter.setFlashMode(Camera.Parameters.FLASH_MODE_TORCH);

        m_Camera.setParameters(parameter);
//        try {
//            camera = Camera.open(1);
//            camera.startPreview();
//            Camera.Parameters parameters = camera.getParameters();
//            parameters.setFlashMode(Camera.Parameters.FLASH_MODE_TORCH);
//            camera.setParameters(parameters);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
        isflashlightOpen = true;
    }

    private void closeLightOff() {
        if (isflashlightOpen && m_Camera != null) {
            Camera.Parameters parameter = m_Camera.getParameters();
            parameter.setFlashMode(Camera.Parameters.FLASH_MODE_OFF);
            m_Camera.setParameters(parameter);
            isflashlightOpen = false;
        }
//        if (isflashlightOpen && camera != null)
//            try {
//
//                Camera.Parameters parameters = camera.getParameters();
//                parameters.setFlashMode(Camera.Parameters.FLASH_MODE_OFF);
//                camera.setParameters(parameters);
//                camera.stopPreview();
//                camera.release();
//                camera = null;
//            } catch (Exception e) {
//                e.printStackTrace();
//            }
    }
}
