package org.plugins.scan;

import android.Manifest;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import androidx.core.content.ContextCompat;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.PermissionHelper;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.plugins.scan.BroadcastDemo.HussarBarcodeScannerPlugin;

public class BarcodeScanner extends CordovaPlugin {

  private CallbackContext callbackContext;
  /** 二维码扫描 */
  // private static final int REQUEST_CODE_ZXING_SCANNER = 1;
  // private static final String DECODED_CONTENT_KEY = "codedContent";
  // // 动态申请权限
  private static final int MY_PERMISSION_REQUEST_CODE = 10;

  private static final int SCANNIN_GREQUEST_CODE = 1;
  private Activity mActivity;
  private String[] permissions = {Manifest.permission.CAMERA, Manifest.permission.VIBRATE};
  private static final String CANCELLED = "cancelled";
  private static final String FORMAT = "format";
  private static final String TEXT = "text";

  @Override
  public boolean execute(String action, JSONArray args, CallbackContext callbackContext)
      throws JSONException {

    mActivity = cordova.getActivity();
    this.callbackContext = callbackContext;

    if ("scan".equals(action)) {
      if (!hasPermisssion()) {
        requestPermissions(0);
      } else {
        cordova.setActivityResultCallback(this);
        Intent intent = new Intent(cordova.getActivity(), HussarBarcodeScannerPlugin.class);
        cordova.getActivity().startActivityForResult(intent, SCANNIN_GREQUEST_CODE);
      }
    }
    return true;
  }

  /** check application's permissions */
  public boolean hasPermisssion() {
    for (String p : permissions) {
      if (!PermissionHelper.hasPermission(this, p)) {
        return false;
      }
    }
    return true;
  }

  /**
   * We override this so that we can access the permissions variable, which no longer exists in the
   * parent class, since we can't initialize it reliably in the constructor!
   *
   * @param requestCode The code to get request action
   */
  public void requestPermissions(int requestCode) {
    PermissionHelper.requestPermissions(this, requestCode, permissions);
  }

  /** 检查是否拥有指定的所有权限 */
  private boolean checkPermissionAllGranted(String[] permissions) {
    for (String permission : permissions) {
      if (ContextCompat.checkSelfPermission(mActivity, permission)
          != PackageManager.PERMISSION_GRANTED) {
        // 只要有一个权限没有被授予, 则直接返回 false
        return false;
      }
    }
    return true;
  }

  @Override
  public void onRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults)
      throws JSONException {
    super.onRequestPermissionResult(requestCode, permissions, grantResults);

    PluginResult result;
    for (int r : grantResults) {
      if (r == PackageManager.PERMISSION_DENIED) {
        result = new PluginResult(PluginResult.Status.ILLEGAL_ACCESS_EXCEPTION);
        this.callbackContext.sendPluginResult(result);
        return;
      }
    }

    switch (requestCode) {
      case 0:
        cordova.setActivityResultCallback(this);
        Intent intent = new Intent(cordova.getActivity(), HussarBarcodeScannerPlugin.class);
        cordova.getActivity().startActivityForResult(intent, SCANNIN_GREQUEST_CODE);
        break;
    }
  }

  @Override
  public void onRestoreStateForActivityResult(Bundle state, CallbackContext callbackContext) {
    this.callbackContext = callbackContext;
  }

  /** 第 3 步: 申请权限结果返回处理 */
  @Override
  public void onActivityResult(int requestCode, int resultCode, Intent data) {
    super.onActivityResult(requestCode, resultCode, data);
    switch (requestCode) {
      case SCANNIN_GREQUEST_CODE:
        if (resultCode == Activity.RESULT_OK) {
          //
          JSONObject obj = new JSONObject();
          try {
            Bundle bundle = data.getExtras();

            obj.put(TEXT, bundle.getString("result"));
            obj.put(FORMAT, "");
            obj.put(CANCELLED, false);
          } catch (JSONException e) {
            Log.d("scan--->", "This should never happen");
          }
          callbackContext.success(obj);
        } else if (resultCode == Activity.RESULT_CANCELED) {
          JSONObject obj = new JSONObject();
          try {
            obj.put(TEXT, "");
            obj.put(FORMAT, "");
            obj.put(CANCELLED, true);
          } catch (JSONException e) {
            Log.d("scan--->", "This should never happen");
          }
          // this.success(new PluginResult(PluginResult.Status.OK, obj), this.callback);
          this.callbackContext.success(obj);
        } else {
          // this.error(new PluginResult(PluginResult.Status.ERROR), this.callback);
          this.callbackContext.error("Unexpected error");
        }
        break;
    }
  }
}
