package org.plugins.appversion;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.json.JSONArray;
import org.json.JSONException;

/**
 * 文件描述：获取APP版本信息
 *
 * <p>
 * 作者：王真
 *
 * <p>
 * 创建时间：2019/6/18
 *
 * <p>
 * 版本号：1.0
 */
public class AppVersion extends CordovaPlugin {

    /**
     * 获取版本信息的方法
     *
     * @param action
     *            需要获取的版本信息类型
     * @param args
     *            需用的参数，当前方法中未使用
     * @param callbackContext
     *            获取版本信息的回调
     * @return
     * @throws JSONException
     */
    @Override
    public boolean execute(
            String action, JSONArray args, CallbackContext callbackContext) throws JSONException {

        try {
            if ("getAppName".equals(action)) {
                PackageManager packageManager = this.cordova.getActivity().getPackageManager();
                ApplicationInfo app = packageManager.getApplicationInfo(this.cordova.getActivity().getPackageName(), 0);
                callbackContext.success((String)packageManager.getApplicationLabel(app));
                return true;
            }
            if ("getPackageName".equals(action)) {
                callbackContext.success(this.cordova.getActivity().getPackageName());
                return true;
            }
            if ("getVersionNumber".equals(action)) {
                PackageManager packageManager = this.cordova.getActivity().getPackageManager();
                callbackContext
                    .success(packageManager.getPackageInfo(this.cordova.getActivity().getPackageName(), 0).versionName);
                return true;
            }
            if ("getVersionCode".equals(action)) {
                PackageManager packageManager = this.cordova.getActivity().getPackageManager();
                callbackContext
                    .success(packageManager.getPackageInfo(this.cordova.getActivity().getPackageName(), 0).versionCode);
                return true;
            }
            return false;
        } catch (NameNotFoundException e) {
            callbackContext.success("N/A");
            return true;
        }
    }
}
