/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.platform.cloud.business.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.entity.SysDict;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.feign.RemoteDictService;
import com.jxdinfo.hussar.platform.cloud.business.system.api.dto.UserInfo;
import com.jxdinfo.hussar.platform.cloud.business.system.api.entity.SysUser;
import com.jxdinfo.hussar.platform.cloud.business.system.service.SysUserService;
import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.LoginUser;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"})
@Api(value="user", tags={"\u7528\u6237\u7ba1\u7406\u6a21\u5757"})
public class SysUserController {
    private final SysUserService userService;
    private final RemoteDictService remoteDictService;

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u5168\u90e8\u4fe1\u606f", notes="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u5168\u90e8\u4fe1\u606f")
    @GetMapping(value={"/info/{username}"})
    public ApiResponse info(@ApiParam(value="\u7528\u6237\u540d") @PathVariable String username) {
        SysUser user = (SysUser)this.userService.getOne((Wrapper)Wrappers.query().lambda().eq(SysUser::getUsername, (Object)username));
        if (user == null) {
            return ApiResponse.fail(null, (String)String.format("\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a %s", username));
        }
        ApiResponse dictById = this.remoteDictService.getDictById(Long.valueOf(1L));
        UserInfo userInfo = this.userService.findUserInfo(user);
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty((Object)dictById) && dictById.isSuccess()) {
            returnMap.put("dict_ino", dictById.getData());
        }
        returnMap.put("user_info", userInfo);
        return ApiResponse.success(returnMap);
    }

    @Inner
    @GetMapping(value={"/details/{username}"})
    public ApiResponse user(@PathVariable String username) {
        SysUser condition = new SysUser();
        condition.setUsername(username);
        return ApiResponse.success((Object)this.userService.getOne((Wrapper)new QueryWrapper((Object)condition)));
    }

    @Inner
    @PostMapping(value={"/doLoingByUserName"})
    public ApiResponse<UserDetails> doLoingByUserName(@RequestBody LoginUser loginUser) {
        return ApiResponse.success((Object)this.userService.doLoingByUserName(loginUser));
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u4fe1\u606f", notes="\u83b7\u53d6\u5b57\u5178\u4fe1\u606f")
    @PostMapping(value={"/getDict"})
    public ApiResponse<SysDict> getDict() {
        return this.remoteDictService.getDictById(Long.valueOf(1L));
    }

    @Inner
    @PostMapping(value={"/doCheckUserPassword"})
    public ApiResponse<Boolean> doCheckUserPassword(@RequestBody String password) {
        return ApiResponse.success((Object)this.userService.doCheckUserPassword(password));
    }

    public SysUserController(SysUserService userService, RemoteDictService remoteDictService) {
        this.userService = userService;
        this.remoteDictService = remoteDictService;
    }
}

