/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.platform.cloud.business.system.service.impl;

import cn.hutool.core.util.ArrayUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.platform.cloud.business.system.api.dto.PermissionDto;
import com.jxdinfo.hussar.platform.cloud.business.system.api.dto.UserInfo;
import com.jxdinfo.hussar.platform.cloud.business.system.api.entity.SysRole;
import com.jxdinfo.hussar.platform.cloud.business.system.api.entity.SysUser;
import com.jxdinfo.hussar.platform.cloud.business.system.api.vo.MenuVO;
import com.jxdinfo.hussar.platform.cloud.business.system.mapper.SysUserMapper;
import com.jxdinfo.hussar.platform.cloud.business.system.service.SysMenuService;
import com.jxdinfo.hussar.platform.cloud.business.system.service.SysRoleService;
import com.jxdinfo.hussar.platform.cloud.business.system.service.SysUserService;
import com.jxdinfo.hussar.platform.core.support.service.dto.LoginUser;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysUserServiceImpl
extends HussarServiceImpl<SysUserMapper, SysUser>
implements SysUserService {
    private static final Logger log = LoggerFactory.getLogger(SysUserServiceImpl.class);
    private final SysMenuService sysMenuService;
    private final SysRoleService sysRoleService;

    @Override
    public UserDetails doLoingByUserName(LoginUser loginUser) {
        if (HussarUtils.isEmpty((Object)loginUser)) {
            throw new HussarException("\u767b\u5f55\u5931\u8d25,\u4f20\u9012\u6761\u4ef6\u4e3a\u7a7a");
        }
        LambdaQueryWrapper sysUserLambdaQueryWrapper = Wrappers.lambdaQuery();
        sysUserLambdaQueryWrapper.eq(SysUser::getUsername, (Object)loginUser.getUserName());
        SysUser one = (SysUser)this.getOne((Wrapper)sysUserLambdaQueryWrapper, false);
        if (HussarUtils.isEmpty((Object)one)) {
            throw new HussarException("\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef");
        }
        if (!one.getPassword().equalsIgnoreCase(loginUser.getPassword())) {
            throw new HussarException("\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef");
        }
        UserDetails userDetails = new UserDetails();
        userDetails.setUserId(one.getId());
        userDetails.setUserName(one.getUsername());
        userDetails.setMaxSameCount(one.getMaxSessions());
        PermissionDto permissionDto = new PermissionDto();
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("12344");
        strings.add("22222");
        permissionDto.setPermissList(strings);
        ArrayList<PermissionDto> list = new ArrayList<PermissionDto>();
        list.add(permissionDto);
        userDetails.setGrantedAuthoritys(list);
        return userDetails;
    }

    @Override
    public UserInfo findUserInfo(SysUser sysUser) {
        UserInfo userInfo = new UserInfo();
        userInfo.setSysUser(sysUser);
        List<Long> roleIds = this.sysRoleService.findRolesByUserId(sysUser.getId()).stream().map(SysRole::getId).collect(Collectors.toList());
        userInfo.setRoles((Long[])ArrayUtil.toArray(roleIds, Long.class));
        HashSet permissions = new HashSet();
        roleIds.forEach(roleId -> {
            List permissionList = this.sysMenuService.findMenuByRoleId((Long)roleId).stream().filter(menuVo -> StringUtils.isNotEmpty((String)menuVo.getPermission())).map(MenuVO::getPermission).collect(Collectors.toList());
            permissions.addAll(permissionList);
        });
        userInfo.setPermissions((String[])ArrayUtil.toArray(permissions, String.class));
        return userInfo;
    }

    public SysUserServiceImpl(SysMenuService sysMenuService, SysRoleService sysRoleService) {
        this.sysMenuService = sysMenuService;
        this.sysRoleService = sysRoleService;
    }
}

