/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.platform.cloud.business.system.service.impl;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jxdinfo.hussar.platform.cloud.business.system.api.entity.SysCloudRouteConf;
import com.jxdinfo.hussar.platform.cloud.business.system.mapper.SysCloudRouteConfMapper;
import com.jxdinfo.hussar.platform.cloud.business.system.service.SysCloudRouteConfService;
import com.jxdinfo.hussar.platform.cloud.support.gateway.support.DynamicRouteInitEvent;
import com.jxdinfo.hussar.platform.cloud.support.gateway.vo.RouteDefinitionVo;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Mono;

@Service(value="sysRouteConfService")
public class SysCloudRouteConfServiceImpl
extends HussarServiceImpl<SysCloudRouteConfMapper, SysCloudRouteConf>
implements SysCloudRouteConfService {
    private static final Logger log = LoggerFactory.getLogger(SysCloudRouteConfServiceImpl.class);
    private final RedisTemplate redisTemplate;
    private final ApplicationEventPublisher applicationEventPublisher;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Mono<Void> updateRoutes(JSONArray routes) {
        Boolean result = this.redisTemplate.delete((Object)"global:gateway_route_key");
        log.info("\u6e05\u7a7a\u7f51\u5173\u8def\u7531 {} ", (Object)result);
        ArrayList routeDefinitionVoList = new ArrayList();
        try {
            routes.forEach(value -> {
                Object order;
                Object uri;
                Object filters;
                Object predicates;
                Object routeName;
                log.info("\u66f4\u65b0\u8def\u7531 ->{}", value);
                RouteDefinitionVo vo = new RouteDefinitionVo();
                Map map = (Map)value;
                Object id = map.get("routeId");
                if (id != null) {
                    vo.setId(String.valueOf(id));
                }
                if ((routeName = map.get("routeName")) != null) {
                    vo.setRouteName(String.valueOf(routeName));
                }
                if ((predicates = map.get("predicates")) != null) {
                    JSONArray predicatesArray = (JSONArray)predicates;
                    List predicateDefinitionList = predicatesArray.toList(PredicateDefinition.class);
                    vo.setPredicates(predicateDefinitionList);
                }
                if ((filters = map.get("filters")) != null) {
                    JSONArray filtersArray = (JSONArray)filters;
                    List filterDefinitionList = filtersArray.toList(FilterDefinition.class);
                    vo.setFilters(filterDefinitionList);
                }
                if ((uri = map.get("uri")) != null) {
                    vo.setUri(URI.create(String.valueOf(uri)));
                }
                if ((order = map.get("order")) != null) {
                    vo.setOrder(Integer.parseInt(String.valueOf(order)));
                }
                this.redisTemplate.setHashValueSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(RouteDefinitionVo.class));
                this.redisTemplate.opsForHash().put((Object)"global:gateway_route_key", (Object)vo.getId(), (Object)vo);
                routeDefinitionVoList.add(vo);
            });
            SysCloudRouteConf condition = new SysCloudRouteConf();
            condition.setDelFlag("0");
            this.remove((Wrapper)new UpdateWrapper((Object)condition));
            List routeConfList = routeDefinitionVoList.stream().map(vo -> {
                SysCloudRouteConf routeConf = new SysCloudRouteConf();
                routeConf.setRouteId(vo.getId());
                routeConf.setRouteName(vo.getRouteName());
                routeConf.setFilters(JSONUtil.toJsonStr((Object)vo.getFilters()));
                routeConf.setPredicates(JSONUtil.toJsonStr((Object)vo.getPredicates()));
                routeConf.setRouteOrder(Integer.valueOf(vo.getOrder()));
                routeConf.setUri(vo.getUri().toString());
                return routeConf;
            }).collect(Collectors.toList());
            this.saveBatch(routeConfList);
            log.debug("\u66f4\u65b0\u7f51\u5173\u8def\u7531\u7ed3\u675f ");
            this.redisTemplate.convertAndSend("gateway_jvm_route_reload_topic", (Object)"\u8def\u7531\u4fe1\u606f,\u7f51\u5173\u7f13\u5b58\u66f4\u65b0");
        }
        catch (Exception e) {
            log.error("\u8def\u7531\u914d\u7f6e\u89e3\u6790\u5931\u8d25", (Throwable)e);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new DynamicRouteInitEvent((Object)this));
            throw new RuntimeException(e);
        }
        return Mono.empty();
    }

    public SysCloudRouteConfServiceImpl(RedisTemplate redisTemplate, ApplicationEventPublisher applicationEventPublisher) {
        this.redisTemplate = redisTemplate;
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

