/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.platform.cloud.common.utils;

import cn.hutool.core.codec.Base64;
import com.jxdinfo.hussar.platform.cloud.common.exception.CheckedException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityUtils {
    private static final Logger log = LoggerFactory.getLogger(SecurityUtils.class);
    private static final String BASIC_ = "Basic ";

    public static String extractClientId(String header, String defVal) {
        byte[] decoded;
        if (header == null || !header.startsWith(BASIC_)) {
            log.debug("\u8bf7\u6c42\u5934\u4e2dclient\u4fe1\u606f\u4e3a\u7a7a: {}", (Object)header);
            return defVal;
        }
        byte[] base64Token = header.substring(6).getBytes(StandardCharsets.UTF_8);
        try {
            decoded = Base64.decode((byte[])base64Token);
        }
        catch (IllegalArgumentException e) {
            log.debug("Failed to decode basic authentication token: {}", (Object)header);
            return defVal;
        }
        String token = new String(decoded, StandardCharsets.UTF_8);
        int delim = token.indexOf(":");
        if (delim == -1) {
            log.debug("Invalid basic authentication token: {}", (Object)header);
            return defVal;
        }
        return token.substring(0, delim);
    }

    public static Optional<String> extractClientId(String header) {
        return Optional.ofNullable(SecurityUtils.extractClientId(header, null));
    }

    public static String getClientId(String header) {
        String clientId = SecurityUtils.extractClientId(header, null);
        if (clientId == null) {
            throw new CheckedException("Invalid basic authentication token");
        }
        return clientId;
    }

    private SecurityUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

