/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.push.controller;

import cn.hutool.core.util.StrUtil;
import com.jxdinfo.hussar.push.model.DeviceTokenDO;
import com.jxdinfo.hussar.push.model.DeviceTokenDTO;
import com.jxdinfo.hussar.push.service.DeviceTokenService;
import com.jxdinfo.hussar.response.ApiResponse;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"v1/push"})
public class DeviceTokenController {
    private DeviceTokenService deviceTokenService;

    @Autowired
    public DeviceTokenController(DeviceTokenService deviceTokenService) {
        this.deviceTokenService = deviceTokenService;
    }

    @PostMapping(value={"token"})
    public ApiResponse<Boolean> saveToken(@RequestBody DeviceTokenDTO deviceTokenDTO) {
        if (StrUtil.isNotEmpty((CharSequence)deviceTokenDTO.getUserId()) && StrUtil.isNotEmpty((CharSequence)deviceTokenDTO.getDeviceToken())) {
            DeviceTokenDO deviceTokenDO = new DeviceTokenDO();
            BeanUtils.copyProperties((Object)deviceTokenDTO, (Object)deviceTokenDO);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            deviceTokenDO.setCreateTime(simpleDateFormat.format(new Date()));
            deviceTokenDO.setModifyTime(simpleDateFormat.format(new Date()));
            return ApiResponse.data((Object)this.deviceTokenService.saveOrUpdate(deviceTokenDO));
        }
        return ApiResponse.fail((String)"\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
    }

    @GetMapping(value={"token"})
    public ApiResponse<DeviceTokenDTO> getTokenByUserId(@RequestParam String userId) {
        DeviceTokenDO deviceTokenDO = (DeviceTokenDO)this.deviceTokenService.getById((Serializable)((Object)userId));
        if (deviceTokenDO == null) {
            return ApiResponse.data(null);
        }
        DeviceTokenDTO deviceTokenDTO = new DeviceTokenDTO();
        BeanUtils.copyProperties((Object)deviceTokenDO, (Object)deviceTokenDTO);
        return ApiResponse.data((Object)deviceTokenDTO);
    }
}

