/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.utils;

import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class LogicPathUtils {
    private static final boolean IS_WINDOWS = "\\".equals(File.separator);

    private LogicPathUtils() {
    }

    public static String posixPath(String ... segments) {
        if ((segments = LogicPathUtils.preprocessPathSegments(segments)).length == 0) {
            return "";
        }
        boolean leadingSlash = segments[0].startsWith("/") || segments[0].startsWith("\\");
        boolean trailingSlash = segments[segments.length - 1].endsWith("/") || segments[segments.length - 1].endsWith("\\");
        String path = Arrays.stream(segments).flatMap(segment -> Arrays.stream(segment.split("[/\\\\]", -1))).filter(segment -> !segment.isEmpty()).collect(Collectors.joining("/"));
        if (path.isEmpty() && leadingSlash && trailingSlash) {
            return "/";
        }
        path = leadingSlash ? "/" + path : path;
        path = trailingSlash ? path + "/" : path;
        return path;
    }

    public static String systemPath(String ... segments) {
        boolean leadingSlash;
        if ((segments = LogicPathUtils.preprocessPathSegments(segments)).length == 0) {
            return "";
        }
        boolean leadingUnc = IS_WINDOWS && segments[0].startsWith("\\\\");
        boolean bl = leadingSlash = segments[0].startsWith("/") || segments[0].startsWith("\\");
        String prefix = leadingUnc ? "\\\\" : (leadingSlash ? File.separator : "");
        boolean trailingSlash = segments[segments.length - 1].endsWith("/") || segments[segments.length - 1].endsWith("\\");
        String suffix = trailingSlash ? File.separator : "";
        String path = Arrays.stream(segments).flatMap(segment -> Arrays.stream(segment.split("[/\\\\]", -1))).filter(segment -> !segment.isEmpty()).collect(Collectors.joining(File.separator));
        if (path.isEmpty() && !prefix.isEmpty() && !suffix.isEmpty()) {
            return prefix;
        }
        return prefix + path + suffix;
    }

    public static String packagePath(String ... segments) {
        if ((segments = LogicPathUtils.preprocessPathSegments(segments)).length == 0) {
            return "";
        }
        return Arrays.stream(segments).flatMap(segment -> Arrays.stream(segment.split("[./\\\\]", -1))).filter(segment -> !segment.isEmpty()).map(String::toLowerCase).collect(Collectors.joining("."));
    }

    public static String packageToPosixPath(String pkg) {
        return pkg.replace('.', '/');
    }

    private static String[] preprocessPathSegments(String[] segments) {
        if (segments == null) {
            return new String[0];
        }
        return (String[])Arrays.stream(segments).filter(segment -> segment != null && !segment.isEmpty()).toArray(String[]::new);
    }
}

