/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.ReadContext;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.jxdinfo.hussar.logic.utils.LogicJsonUtils;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public final class LogicJsonPathUtils {
    private static final ParseContext PARSE_CONTEXT = LogicJsonPathUtils.createJsonPathParseContext(LogicJsonUtils.getObjectMapper());

    private LogicJsonPathUtils() {
    }

    private static ParseContext createJsonPathParseContext(ObjectMapper objectMapper) {
        Configuration configuration = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider(objectMapper)).mappingProvider((MappingProvider)new JacksonMappingProvider(objectMapper)).build();
        return JsonPath.using((Configuration)configuration);
    }

    public static ReadContext parse(String json) {
        return PARSE_CONTEXT.parse(json);
    }

    public static ReadContext parse(byte[] json) {
        return PARSE_CONTEXT.parse(new String(json, StandardCharsets.UTF_8));
    }

    public static ReadContext parse(InputStream json) {
        return PARSE_CONTEXT.parse(json, StandardCharsets.UTF_8.name());
    }

    public static ReadContext parse(Object json) {
        return PARSE_CONTEXT.parse(json);
    }
}

