/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.structure.visitor;

import com.jxdinfo.hussar.logic.structure.sourcemap.LogicSourceMap;
import com.jxdinfo.hussar.logic.structure.type.LogicType;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;

public final class LogicGeneratedCode {
    private String code;
    private LogicSourceMap sourceMap;
    private LogicType type;

    public static LogicGeneratedCode byCode(String sourceId, String code) {
        if (code == null) {
            throw new NullPointerException();
        }
        LogicGeneratedCode generatedCode = new LogicGeneratedCode();
        generatedCode.setCode(code);
        if (sourceId != null) {
            LogicSourceMap sourceMap = LogicSourceMap.Builder.of((String)sourceId).add(code).build();
            generatedCode.setSourceMap(sourceMap);
        }
        return generatedCode;
    }

    public static LogicGeneratedCode concat(LogicGeneratedCode ... sequence) {
        boolean useSourceMap;
        if (ArrayUtils.getLength((Object)sequence) == 0) {
            throw new IllegalArgumentException();
        }
        long sourceMapCount = Arrays.stream(sequence).map(LogicGeneratedCode::getSourceMap).filter(Objects::nonNull).count();
        boolean bl = useSourceMap = sourceMapCount > 0L;
        if (useSourceMap && sourceMapCount != (long)sequence.length) {
            throw new IllegalArgumentException("some concatenation items missing source map");
        }
        StringBuilder codeBuilder = new StringBuilder();
        LogicSourceMap.Builder sourceMapBuilder = useSourceMap ? LogicSourceMap.Builder.of((String)sequence[0].getSourceMap().getOwner()) : null;
        for (LogicGeneratedCode item : sequence) {
            codeBuilder.append(item.getCode());
            if (!useSourceMap) continue;
            sourceMapBuilder.add(item.getSourceMap());
        }
        LogicGeneratedCode result = new LogicGeneratedCode();
        result.setCode(codeBuilder.toString());
        if (useSourceMap) {
            result.setSourceMap(sourceMapBuilder.build());
        }
        return result;
    }

    public LogicGeneratedCode typed(LogicType type) {
        this.setType(type);
        return this;
    }

    public LogicGeneratedCode postprocess(Function<LogicGeneratedCode, LogicGeneratedCode> processor) {
        if (processor == null) {
            return this;
        }
        return processor.apply(this);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public LogicSourceMap getSourceMap() {
        return this.sourceMap;
    }

    public void setSourceMap(LogicSourceMap sourceMap) {
        this.sourceMap = sourceMap;
    }

    public LogicType getType() {
        return this.type;
    }

    public void setType(LogicType type) {
        this.type = type;
    }
}

