/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.structure.check;

import com.jxdinfo.hussar.logic.structure.type.LogicType;

public enum TypeConstraint {
    COMPARABLE,
    NUMBER;


    public Boolean check(LogicType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        switch (this) {
            case COMPARABLE: {
                if (!type.isBuiltin()) {
                    return null;
                }
                switch (type.getBuiltinTypeName()) {
                    case BOOLEAN: 
                    case INTEGER: 
                    case LONG: 
                    case DOUBLE: 
                    case STRING: 
                    case DATE: {
                        return true;
                    }
                    case LIST: 
                    case MAP: {
                        return false;
                    }
                }
                return null;
            }
            case NUMBER: {
                if (!type.isBuiltin()) {
                    return null;
                }
                switch (type.getBuiltinTypeName()) {
                    case INTEGER: 
                    case LONG: 
                    case DOUBLE: {
                        return true;
                    }
                    case BOOLEAN: 
                    case STRING: 
                    case DATE: 
                    case LIST: 
                    case MAP: {
                        return false;
                    }
                }
                return null;
            }
        }
        throw new UnsupportedOperationException();
    }
}

