/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.visitor.arguments;

import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateFeature;
import com.jxdinfo.hussar.logic.generator.visitor.named.LogicGenerateNamedArgument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public abstract class LogicGenerateArguments {
    private final Set<LogicGenerateFeature> features;
    private final Map<String, Object> namedArguments;
    private final List<Object> positionalArguments;

    protected LogicGenerateArguments(Object ... arguments) {
        if (arguments == null) {
            this.features = Collections.emptySet();
            this.namedArguments = Collections.emptyMap();
            this.positionalArguments = Collections.emptyList();
        } else {
            LinkedHashSet<LogicGenerateFeature> features = new LinkedHashSet<LogicGenerateFeature>();
            LinkedHashMap namedArguments = new LinkedHashMap();
            ArrayList<Object> positionalArguments = new ArrayList<Object>();
            for (Object argument : arguments) {
                if (argument instanceof LogicGenerateFeature) {
                    features.add((LogicGenerateFeature)argument);
                    continue;
                }
                if (argument instanceof LogicGenerateNamedArgument) {
                    LogicGenerateNamedArgument namedArgument = (LogicGenerateNamedArgument)argument;
                    namedArguments.put(namedArgument.getName(), namedArgument.getValue());
                    continue;
                }
                positionalArguments.add(argument);
            }
            this.features = Collections.unmodifiableSet(features);
            this.namedArguments = Collections.unmodifiableMap(namedArguments);
            this.positionalArguments = Collections.unmodifiableList(positionalArguments);
        }
    }

    public boolean satisfy(LogicGenerateFeature desire) {
        return CollectionUtils.isNotEmpty(this.match(desire));
    }

    public List<LogicGenerateFeature> match(LogicGenerateFeature desire) {
        if (desire == null) {
            return null;
        }
        ArrayList<LogicGenerateFeature> matched = null;
        for (LogicGenerateFeature feature : this.features) {
            Boolean satisfy = feature.satisfy(desire);
            if (satisfy == null) continue;
            if (satisfy.booleanValue()) {
                if (matched == null) {
                    matched = new ArrayList<LogicGenerateFeature>();
                }
                matched.add(feature);
                continue;
            }
            return null;
        }
        return CollectionUtils.isNotEmpty(matched) ? matched : null;
    }

    public Object getNamedArgument(String name) {
        return this.namedArguments.get(name);
    }

    public <T> T getNamedArgument(String name, Class<T> clazz) {
        return clazz.cast(this.getNamedArgument(name));
    }

    public Object getPositionalArgument(int index) {
        if (index < 0 || index >= this.positionalArguments.size()) {
            return null;
        }
        return this.positionalArguments.get(index);
    }

    public <T> T getPositionalArgument(int index, Class<T> clazz) {
        return clazz.cast(this.getPositionalArgument(index));
    }

    public Set<LogicGenerateFeature> getFeatures() {
        return this.features;
    }

    public Map<String, Object> getNamedArguments() {
        return this.namedArguments;
    }

    public List<Object> getPositionalArguments() {
        return this.positionalArguments;
    }
}

