/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.visitor;

import com.fasterxml.jackson.databind.JavaType;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.context.LogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.utils.LogicComponentConvertUtils;
import com.jxdinfo.hussar.logic.generator.visitor.LogicGenerateVisitor;
import com.jxdinfo.hussar.logic.generator.visitor.arguments.LogicGenerateArguments;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import com.jxdinfo.hussar.logic.structure.visitor.props.BaseLogicProps;
import com.jxdinfo.hussar.logic.utils.LogicJsonUtils;
import java.util.Arrays;
import org.springframework.core.ResolvableType;

public abstract class AbstractLogicGenerateVisitor<T extends BaseLogicProps>
implements LogicGenerateVisitor {
    protected volatile JavaType propsDtoType = null;

    @Override
    public boolean filter(LogicCanvasComponent component) {
        return true;
    }

    @Override
    public LogicGeneratedCode generate(LogicGenerateContext context, LogicCanvasComponent component, LogicGenerateArguments arguments) {
        if (context == null || context.getMetadata() == null || context.getConfigure() == null || component == null) {
            throw new NullPointerException();
        }
        JavaType propsType = this.getPropsDtoTypeSynchronized();
        LogicGenerateComponent typedComponent = LogicComponentConvertUtils.convertComponent(component, propsType);
        return this.generate(context, typedComponent, arguments);
    }

    public abstract LogicGeneratedCode generate(LogicGenerateContext var1, LogicGenerateComponent<T> var2, LogicGenerateArguments var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaType getPropsDtoTypeSynchronized() {
        if (this.propsDtoType == null) {
            AbstractLogicGenerateVisitor abstractLogicGenerateVisitor = this;
            synchronized (abstractLogicGenerateVisitor) {
                if (this.propsDtoType == null) {
                    this.propsDtoType = this.getPropsDtoType();
                }
            }
        }
        return this.propsDtoType;
    }

    private JavaType getPropsDtoType() {
        try {
            ResolvableType resolvableType;
            for (resolvableType = ResolvableType.forClass(this.getClass()); resolvableType != ResolvableType.NONE && resolvableType.getRawClass() != AbstractLogicGenerateVisitor.class; resolvableType = resolvableType.getSuperType()) {
            }
            if (resolvableType == ResolvableType.NONE) {
                throw new HussarLogicGenerateVisitorException("visitor ancestor mismatches: " + AbstractLogicGenerateVisitor.class.getSimpleName() + " !> " + this.getClass().getSimpleName());
            }
            ResolvableType resolvableDtoType = resolvableType.getGeneric(new int[]{0});
            if (resolvableDtoType == ResolvableType.NONE) {
                throw new HussarLogicGenerateVisitorException("props dto type parameter not found");
            }
            return AbstractLogicGenerateVisitor.toJavaType(resolvableDtoType);
        }
        catch (HussarLogicGenerateVisitorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new HussarLogicGenerateVisitorException("failed to resolve props dto type", ex);
        }
    }

    private static JavaType toJavaType(ResolvableType resolvableType) {
        Class resolvedClass = resolvableType.resolve();
        if (resolvedClass == null) {
            throw new HussarLogicGenerateVisitorException("props dto type not resolvable");
        }
        JavaType[] parameterTypes = (JavaType[])Arrays.stream(resolvableType.getGenerics()).map(AbstractLogicGenerateVisitor::toJavaType).toArray(JavaType[]::new);
        return LogicJsonUtils.getTypeFactory().constructSimpleType(resolvedClass, parameterTypes);
    }
}

