/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.utils;

import com.jxdinfo.hussar.logic.structure.type.LogicBuiltinType;
import com.jxdinfo.hussar.logic.structure.type.LogicType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public final class LogicTypeCheckUtils {
    private LogicTypeCheckUtils() {
    }

    public static boolean isSame(LogicType left, LogicType right) {
        if (left == null && right == null) {
            return true;
        }
        if (left != null && right != null) {
            if (left.isBuiltin() != right.isBuiltin() || left.getArgumentCount() != right.getArgumentCount()) {
                return false;
            }
            if (left.isBuiltin() && left.getBuiltinTypeName() != right.getBuiltinTypeName()) {
                return false;
            }
            if (!left.isBuiltin() && !Objects.equals(left.getCustomTypeName(), right.getCustomTypeName())) {
                return false;
            }
            for (int i = 0; i < left.getArgumentCount(); ++i) {
                LogicType rightArgument;
                LogicType leftArgument = (LogicType)left.getTypeArguments().get(i);
                if (LogicTypeCheckUtils.isSame(leftArgument, rightArgument = (LogicType)right.getTypeArguments().get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isConcrete(LogicType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (!type.isBuiltin() && StringUtils.startsWith((CharSequence)type.getCustomTypeName(), (CharSequence)"generic:")) {
            return false;
        }
        if (CollectionUtils.isNotEmpty((Collection)type.getTypeArguments())) {
            for (LogicType typeArgument : type.getTypeArguments()) {
                if (LogicTypeCheckUtils.isConcrete(typeArgument)) continue;
                return false;
            }
        }
        return true;
    }

    public static Map<String, LogicType> match(LogicType pattern, LogicType concrete) {
        if (pattern == null || concrete == null) {
            throw new NullPointerException();
        }
        if (!LogicTypeCheckUtils.isConcrete(concrete)) {
            throw new IllegalArgumentException("match against non-concrete type");
        }
        LinkedHashMap<String, LogicType> reifications = new LinkedHashMap<String, LogicType>();
        if (LogicTypeCheckUtils.doMatch(reifications, pattern, concrete)) {
            return reifications;
        }
        return null;
    }

    private static boolean doMatch(Map<String, LogicType> reifications, LogicType pattern, LogicType concrete) {
        if (pattern.isBuiltin()) {
            if (!concrete.isBuiltin() || pattern.getBuiltinTypeName() != concrete.getBuiltinTypeName()) {
                return false;
            }
        } else {
            if (StringUtils.startsWith((CharSequence)pattern.getCustomTypeName(), (CharSequence)"generic:")) {
                String variableName = StringUtils.removeStart((String)pattern.getCustomTypeName(), (String)"generic:");
                LogicType previousType = reifications.get(variableName);
                if (previousType != null && !LogicTypeCheckUtils.isSame(concrete, previousType)) {
                    return false;
                }
                reifications.put(variableName, concrete);
                return true;
            }
            if (concrete.isBuiltin() || !Objects.equals(pattern.getCustomTypeName(), concrete.getCustomTypeName())) {
                return false;
            }
        }
        if (concrete.getArgumentCount() != pattern.getArgumentCount()) {
            return false;
        }
        for (int i = 0; i < concrete.getArgumentCount(); ++i) {
            LogicType concreteArgument;
            LogicType patternArgument = (LogicType)pattern.getTypeArguments().get(i);
            if (LogicTypeCheckUtils.doMatch(reifications, patternArgument, concreteArgument = (LogicType)concrete.getTypeArguments().get(i))) continue;
            return false;
        }
        return true;
    }

    public static LogicType specialize(LogicType type, Map<String, LogicType> reifications) {
        return LogicTypeCheckUtils.specialize(type, reifications, false);
    }

    public static LogicType specialize(LogicType type, Map<String, LogicType> reifications, boolean partial) {
        if (type == null) {
            throw new NullPointerException();
        }
        Map<String, Object> map = reifications = reifications != null ? reifications : Collections.emptyMap();
        if (!reifications.values().stream().allMatch(LogicTypeCheckUtils::isConcrete)) {
            throw new IllegalArgumentException("reifications must be concrete");
        }
        return LogicTypeCheckUtils.doSpecialize(type, reifications, partial);
    }

    private static LogicType doSpecialize(LogicType type, Map<String, LogicType> reifications, boolean partial) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (!type.isBuiltin() && StringUtils.startsWith((CharSequence)type.getCustomTypeName(), (CharSequence)"generic:")) {
            if (CollectionUtils.isNotEmpty((Collection)type.getTypeArguments())) {
                throw new IllegalArgumentException("generic variable cannot be type owner: " + type);
            }
            String variableName = StringUtils.removeStart((String)type.getCustomTypeName(), (String)"generic:");
            LogicType concreteType = reifications.get(variableName);
            if (concreteType == null && !partial) {
                throw new IllegalArgumentException("reification for generic variable '" + variableName + "' is missing");
            }
            if (concreteType != null) {
                return concreteType;
            }
            return type;
        }
        ArrayList<LogicType> typeArguments = null;
        if (type.getArgumentCount() > 0) {
            typeArguments = new ArrayList<LogicType>(type.getArgumentCount());
            for (LogicType argumentType : Optional.ofNullable(type.getTypeArguments()).orElse(Collections.emptyList())) {
                typeArguments.add(LogicTypeCheckUtils.doSpecialize(argumentType, reifications, partial));
            }
        }
        if (type.isBuiltin()) {
            return LogicType.of((LogicBuiltinType)type.getBuiltinTypeName(), typeArguments);
        }
        return LogicType.of((String)type.getCustomTypeName(), typeArguments);
    }
}

