/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LogicSlotPlaceholderUtils {
    private static final String PLACEHOLDER_PREFIX = "<#placeholder>";
    private static final String PLACEHOLDER_SUFFIX = "</#placeholder>";
    private static final String IDENTIFIER_PATTERN_SEGMENT = "[a-zA-Z_$@][a-zA-Z0-9_$@.:-]*";
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("^[a-zA-Z_$@][a-zA-Z0-9_$@.:-]*$");
    private static final String PLACEHOLDER_GROUP_NAME = "name";
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile(Pattern.quote("<#placeholder>") + "(?<" + "name" + ">" + "[a-zA-Z_$@][a-zA-Z0-9_$@.:-]*" + ")" + Pattern.quote("</#placeholder>"));

    private LogicSlotPlaceholderUtils() {
    }

    public static boolean isSlotNameValid(String name) {
        return name != null && IDENTIFIER_PATTERN.matcher(name).matches();
    }

    public static String placeholderOf(String name) {
        if (LogicSlotPlaceholderUtils.isSlotNameValid(name)) {
            return PLACEHOLDER_PREFIX + name + PLACEHOLDER_SUFFIX;
        }
        return null;
    }

    public static List<Segment> parse(String raw) {
        if (raw == null) {
            return null;
        }
        ArrayList<Segment> segments = new ArrayList<Segment>();
        int since = 0;
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(raw);
        boolean matches = matcher.find();
        if (matches) {
            do {
                int until;
                if ((until = matcher.start()) > since) {
                    segments.add(Segment.codeOf(raw.substring(since, until)));
                }
                segments.add(Segment.placeholderOf(matcher.group(PLACEHOLDER_GROUP_NAME)));
                since = matcher.end();
            } while (matches = matcher.find());
            if (since < raw.length()) {
                segments.add(Segment.codeOf(raw.substring(since)));
            }
        } else if (raw.length() > 0) {
            segments.add(Segment.codeOf(raw));
        }
        return segments;
    }

    public static final class Segment {
        private final boolean placeholder;
        private final String name;
        private final String code;

        private Segment(boolean placeholder, String name, String code) {
            this.placeholder = placeholder;
            this.name = name;
            this.code = code;
        }

        private static Segment placeholderOf(String name) {
            return new Segment(true, name, null);
        }

        private static Segment codeOf(String code) {
            return new Segment(false, null, code);
        }

        public boolean isPlaceholder() {
            return this.placeholder;
        }

        public String getName() {
            return this.name;
        }

        public String getCode() {
            return this.code;
        }
    }
}

