/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.utils;

import com.jxdinfo.hussar.logic.generator.tag.LogicGenerateTag;
import com.jxdinfo.hussar.logic.generator.tag.LogicTagToleration;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationFrontend;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationLanguage;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationPlatform;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationRuntime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogicGenerateTagUtils {
    private static final Logger logger = LoggerFactory.getLogger(LogicGenerateTagUtils.class);
    public static final String MISSING_TOPIC = "";

    private LogicGenerateTagUtils() {
    }

    public static LogicTagToleration getTolerationFromGenerateConfigure(LogicGenerateConfigure configure) {
        if (configure == null) {
            return null;
        }
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        if (configure.getLanguage() != null) {
            switch (configure.getLanguage()) {
                case JAVA: {
                    tags.add("language:java");
                    break;
                }
                case JAVASCRIPT: {
                    tags.add("language:javascript");
                    break;
                }
                default: {
                    logger.warn("unimplemented tolerant tag translation for {} ({})", (Object)configure.getLanguage(), LogicGenerationLanguage.class);
                }
            }
        }
        if (configure.getPlatform() != null) {
            switch (configure.getPlatform()) {
                case LOW_CODE_PLATFORM: {
                    tags.add("platform:low_code");
                    break;
                }
                case EAI_PLATFORM: {
                    tags.add("platform:eai");
                    break;
                }
                default: {
                    logger.warn("unimplemented tolerant tag translation for {} ({})", (Object)configure.getPlatform(), LogicGenerationPlatform.class);
                }
            }
        }
        if (configure.getRuntime() != null) {
            switch (configure.getRuntime()) {
                case MVC: {
                    tags.add("runtime:mvc");
                    break;
                }
                case ENGINE: {
                    tags.add("runtime:engine");
                    break;
                }
                default: {
                    logger.warn("unimplemented tolerant tag translation for {} ({})", (Object)configure.getRuntime(), LogicGenerationRuntime.class);
                }
            }
        }
        if (configure.getFrontend() != null) {
            switch (configure.getFrontend()) {
                case WEB_FRONTEND: {
                    tags.add("frontend:web");
                    break;
                }
                case MOBILE_FRONTEND: {
                    tags.add("frontend:mobile");
                    break;
                }
                default: {
                    logger.warn("unimplemented tolerant tag translation for {} ({})", (Object)configure.getFrontend(), LogicGenerationFrontend.class);
                }
            }
        }
        if (configure.getAdditionalTolerationTags() != null) {
            tags.addAll(configure.getAdditionalTolerationTags());
        }
        return LogicTagToleration.from(tags.toArray(new String[0]));
    }

    public static Map<String, List<String>> convertTagsToInternalIndex(String[] tags) {
        List parsed = tags != null ? Arrays.stream(tags).map(LogicGenerateTag::parse).collect(Collectors.toList()) : null;
        return LogicGenerateTagUtils.convertTagsToInternalIndex(parsed);
    }

    public static Map<String, List<String>> convertTagsToInternalIndex(List<LogicGenerateTag> tags) {
        LinkedHashMap<String, ArrayList<String>> converted = new LinkedHashMap<String, ArrayList<String>>();
        if (tags != null) {
            for (LogicGenerateTag logicGenerateTag : tags) {
                if (logicGenerateTag == null) continue;
                String topic = Optional.ofNullable(logicGenerateTag.getTopic()).orElse(MISSING_TOPIC);
                String tag = logicGenerateTag.getTag();
                if (converted.containsKey(topic)) {
                    ((List)converted.get(topic)).add(tag);
                    continue;
                }
                converted.put(topic, new ArrayList<String>(Collections.singletonList(tag)));
            }
        }
        for (Map.Entry entry : converted.entrySet()) {
            entry.setValue(Collections.unmodifiableList((List)entry.getValue()));
        }
        return Collections.unmodifiableMap(converted);
    }

    public static List<LogicGenerateTag> convertInternalIndexToTags(Map<String, List<String>> internalIndex) {
        if (internalIndex == null) {
            return null;
        }
        ArrayList<LogicGenerateTag> tags = new ArrayList<LogicGenerateTag>();
        for (Map.Entry<String, List<String>> entry : internalIndex.entrySet()) {
            String topic = Objects.equals(entry.getKey(), MISSING_TOPIC) ? null : entry.getKey();
            for (String tag : Optional.ofNullable(entry.getValue()).orElseGet(Collections::emptyList)) {
                tags.add(LogicGenerateTag.of(topic, tag));
            }
        }
        return tags;
    }

    public static boolean internalIndexEquals(Map<String, List<String>> left, Map<String, List<String>> right) {
        if (left != null && right != null) {
            if (left.size() != right.size()) {
                return false;
            }
            return Stream.concat(left.keySet().stream(), right.keySet().stream()).distinct().allMatch(key -> {
                if (!left.containsKey(key) || !right.containsKey(key)) {
                    return false;
                }
                List leftTags = (List)left.get(key);
                List rightTags = (List)right.get(key);
                if (leftTags != null && rightTags != null) {
                    if (leftTags.size() != rightTags.size()) {
                        return false;
                    }
                    return Stream.concat(leftTags.stream(), rightTags.stream()).allMatch(tag -> leftTags.contains(tag) && rightTags.contains(tag));
                }
                return leftTags == null && rightTags == null;
            });
        }
        return left == null && right == null;
    }

    public static int internalIndexHash(Map<String, List<String>> internalIndex) {
        if (internalIndex == null) {
            return 0;
        }
        HashCodeBuilder builder = new HashCodeBuilder();
        internalIndex.keySet().stream().sorted().forEach(key -> {
            builder.append(key);
            List tags = (List)internalIndex.get(key);
            if (tags == null) {
                builder.append((Object[])null);
            } else {
                tags.stream().sorted().forEach(arg_0 -> ((HashCodeBuilder)builder).append(arg_0));
            }
        });
        return builder.build();
    }
}

