/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.props.BaseLogicProps;
import com.jxdinfo.hussar.logic.structure.visitor.props.LogicJsonProps;
import com.jxdinfo.hussar.logic.utils.LogicJsonUtils;
import com.jxdinfo.hussar.platform.core.utils.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class LogicComponentConvertUtils {
    private LogicComponentConvertUtils() {
    }

    public static <T extends BaseLogicProps> LogicGenerateComponent<T> convertComponent(LogicCanvasComponent component, Class<T> propsClass) {
        if (component == null || propsClass == null) {
            throw new NullPointerException();
        }
        return LogicComponentConvertUtils.convertComponent(component, LogicJsonUtils.getTypeFactory().constructType(propsClass));
    }

    public static <T extends BaseLogicProps> LogicGenerateComponent<T> convertComponent(LogicCanvasComponent component, TypeReference<T> propsTypeRef) {
        if (component == null || propsTypeRef == null) {
            throw new NullPointerException();
        }
        return LogicComponentConvertUtils.convertComponent(component, LogicJsonUtils.getTypeFactory().constructType(propsTypeRef.getType()));
    }

    public static <T extends BaseLogicProps> LogicGenerateComponent<T> convertComponent(LogicCanvasComponent component, JavaType propsType) {
        if (component == null || propsType == null) {
            throw new NullPointerException();
        }
        LogicGenerateComponent<T> generateComponent = new LogicGenerateComponent<T>();
        generateComponent.setName((String)StringUtils.defaultIfEmpty((CharSequence)component.getName(), null));
        generateComponent.setAlias((String)StringUtils.defaultIfEmpty((CharSequence)component.getAlias(), null));
        generateComponent.setInstanceKey((String)StringUtils.defaultIfEmpty((CharSequence)component.getInstanceKey(), null));
        Map propsJson = (Map)ObjectUtils.defaultIfNull((Object)component.getProps(), Collections.emptyMap());
        generateComponent.setProps(LogicComponentConvertUtils.getPropsDto(propsJson, propsType));
        Map slotsJson = (Map)ObjectUtils.defaultIfNull((Object)component.getSlots(), Collections.emptyMap());
        LinkedHashMap<String, List<LogicCanvasComponent>> normalizedSlots = new LinkedHashMap<String, List<LogicCanvasComponent>>(slotsJson.size());
        for (Map.Entry entry : slotsJson.entrySet()) {
            List slot = (List)ObjectUtils.defaultIfNull(entry.getValue(), Collections.emptyList());
            if (slot.stream().anyMatch(Objects::isNull)) {
                normalizedSlots.put((String)entry.getKey(), slot.stream().filter(Objects::nonNull).collect(Collectors.toList()));
                continue;
            }
            normalizedSlots.put((String)entry.getKey(), slot.size() > 0 ? slot : new ArrayList());
        }
        generateComponent.setSlots(normalizedSlots);
        return generateComponent;
    }

    private static <T extends BaseLogicProps> T getPropsDto(Map<String, Object> props, JavaType type) {
        if (type.getRawClass() == LogicJsonProps.class) {
            LogicJsonProps propsDto = new LogicJsonProps();
            propsDto.setProps(props);
            return (T)propsDto;
        }
        Object propsDto = LogicJsonUtils.convert(props, (JavaType)type);
        return (T)((BaseLogicProps)propsDto);
    }
}

