/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.utils;

import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasVariable;
import com.jxdinfo.hussar.logic.structure.definition.LogicVariableDefinition;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateSource;
import com.jxdinfo.hussar.logic.structure.metadata.LogicMetadata;
import com.jxdinfo.hussar.logic.structure.type.LogicType;
import com.jxdinfo.hussar.logic.utils.LogicJsonUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class LogicCanvasConvertUtils {
    private LogicCanvasConvertUtils() {
    }

    public static LogicMetadata convertMetadata(LogicGenerateSource source) {
        if (source == null || source.getMeta() == null || source.getRoot() == null) {
            throw new NullPointerException();
        }
        if (StringUtils.isEmpty((CharSequence)source.getMeta().getName())) {
            throw new IllegalArgumentException();
        }
        LogicMetadata metadata = new LogicMetadata();
        metadata.setId(source.getMeta().getId());
        metadata.setName(source.getMeta().getName());
        metadata.setTitle((String)StringUtils.defaultIfEmpty((CharSequence)source.getMeta().getDesc(), null));
        metadata.setDescription((String)Optional.ofNullable(source.getRoot().getProps()).map(props -> props.get("exegesis")).filter(description -> description instanceof String).orElse(null));
        metadata.setModules(Optional.ofNullable(source.getModules()).orElseGet(ArrayList::new));
        metadata.setVariables((Map)ObjectUtils.defaultIfNull(LogicCanvasConvertUtils.convertVariableList(source.getRoot().getVariables()), new LinkedHashMap()));
        metadata.setParameters((Map)ObjectUtils.defaultIfNull(LogicCanvasConvertUtils.convertVariableList(source.getRoot().getParams()), new LinkedHashMap()));
        if (source.getRoot().getResult() != null) {
            LogicCanvasVariable canvasResult = source.getRoot().getResult().stream().filter(Objects::nonNull).findFirst().orElse(null);
            metadata.setResult(LogicCanvasConvertUtils.convertVariable(canvasResult));
        }
        return metadata;
    }

    public static Map<String, LogicVariableDefinition> convertVariableList(List<LogicCanvasVariable> variableList) {
        if (variableList == null) {
            return null;
        }
        LinkedHashMap<String, LogicVariableDefinition> variableMap = new LinkedHashMap<String, LogicVariableDefinition>();
        for (LogicCanvasVariable variable : variableList) {
            if (variable == null) {
                throw new NullPointerException();
            }
            variableMap.put(variable.getName(), LogicCanvasConvertUtils.convertVariable(variable));
        }
        return variableMap;
    }

    public static LogicVariableDefinition convertVariable(LogicCanvasVariable variable) {
        if (variable == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)variable.getName()) || Objects.isNull(variable.getType())) {
            throw new IllegalArgumentException();
        }
        LogicVariableDefinition definition = new LogicVariableDefinition();
        definition.setName(variable.getName());
        definition.setTitle((String)StringUtils.defaultIfEmpty((CharSequence)variable.getTitle(), null));
        definition.setDescription((String)StringUtils.defaultIfEmpty((CharSequence)variable.getDescription(), null));
        definition.setHasDefault(Optional.ofNullable(variable.getHasDefault()).orElse(false));
        definition.setDefaultValue((String)StringUtils.defaultIfEmpty((CharSequence)variable.getDefaultValue(), null));
        try {
            LogicType type = (LogicType)LogicJsonUtils.convert((Object)variable.getType(), LogicType.class);
            definition.setType(type);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("invalid logic variable type: " + variable.getType(), ex);
        }
        return definition;
    }
}

