/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.tag;

import com.jxdinfo.hussar.logic.generator.tag.LogicGenerateTag;
import com.jxdinfo.hussar.logic.generator.utils.LogicGenerateTagUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class LogicTagToleration {
    public static final LogicTagToleration DEFAULT = new LogicTagToleration(Collections.emptyMap());
    private final Map<String, List<String>> tolerationIndex;

    private LogicTagToleration(Map<String, List<String>> tolerationIndex) {
        if (tolerationIndex == null) {
            throw new NullPointerException();
        }
        this.tolerationIndex = tolerationIndex;
    }

    public static LogicTagToleration from(String[] toleration) {
        return new LogicTagToleration(LogicGenerateTagUtils.convertTagsToInternalIndex(toleration));
    }

    public static LogicTagToleration from(List<LogicGenerateTag> toleration) {
        return new LogicTagToleration(LogicGenerateTagUtils.convertTagsToInternalIndex(toleration));
    }

    public boolean tolerant(LogicGenerateTag tag) {
        if (tag == null) {
            return false;
        }
        return this.tolerant(tag.getTopic(), tag.getTag());
    }

    public boolean tolerant(String topic, String tag) {
        List<String> tags = this.tolerationIndex.get(Optional.ofNullable(topic).orElse(""));
        if (tags == null) {
            return false;
        }
        return tags.contains(tag);
    }

    public Map<String, List<String>> getTolerationIndex() {
        return this.tolerationIndex;
    }

    public String toString() {
        return "LogicTagToleration{tags=" + LogicGenerateTagUtils.convertInternalIndexToTags(this.tolerationIndex) + '}';
    }
}

